/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qdb.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qdb.dc.services.Packer;
import kd.ebg.aqap.banks.qdb.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest rqst) {
        Element root = Packer.ccreateCommonHead("CBE001");
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)rqst.getHeader().getBankCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"accountType", (String)"D");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2");
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.createRequestMsg("CBE001", xmlMsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        BankResponse rsp = Parser.parseHeader(rspStr);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()})));
        }
        Element root = JDomUtils.string2Root((String)Parser.getRespXml(rspStr), (String)RequestContextUtils.getCharset());
        Element opResult = root.getChild("opRep").getChild("opResult");
        String currentBalance = opResult.getChildTextTrim("CurrentBalance");
        String freeBalance = opResult.getChildTextTrim("FreeBalance");
        if (StringUtils.isEmpty((String)currentBalance)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]));
        }
        BalanceInfo balInfo = new BalanceInfo();
        balInfo.setBankAcnt(rqst.getAcnt());
        balInfo.setBankCurrency(rqst.getHeader().getBankCurrency());
        balInfo.setBalanceDateTime(LocalDateTime.now());
        balInfo.setCurrentBalance(new BigDecimal(currentBalance));
        if (!StringUtils.isEmpty((String)freeBalance)) {
            balInfo.setAvailableBalance(new BigDecimal(freeBalance));
        }
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>();
        balanceInfoList.add(balInfo);
        return new EBBankBalanceResponse(balanceInfoList);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]);
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(Packer.getUrl());
        Packer.setContentType(factory);
        return factory;
    }
}

