/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qdb.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qdb.dc.services.Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParser {
    private EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseTodayDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        BankResponse rsp = Parser.parseHeader(rspStr);
        if (!"0000".equals(rsp.getResponseCode())) {
            if ("000305".equals(rsp.getResponseCode())) {
                return detailList;
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"DetailParser_4", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()})));
        }
        Element root = JDomUtils.string2Root((String)Parser.getRespXml(rspStr), (String)RequestContextUtils.getCharset());
        Element opResult = root.getChild("opRep").getChild("opResult");
        if (null == opResult) {
            return detailList;
        }
        String turnPageTotalNum = opResult.getChildTextTrim("turnPageTotalNum");
        if (!StringUtils.isEmpty((String)turnPageTotalNum) && Integer.parseInt(turnPageTotalNum) == 0) {
            return detailList;
        }
        String nextPageFlag = opResult.getChildTextTrim("nextPageFlag");
        String nextPageSearchKey = opResult.getChildTextTrim("nextPageSearchKey");
        Element list = opResult.getChild("list");
        List rowList = list.getChildren("row");
        if (rowList == null || rowList.size() == 0) {
            return detailList;
        }
        for (int i = 0; i < rowList.size(); ++i) {
            Element row = (Element)rowList.get(i);
            String oppositeAccNo = row.getChildTextTrim("oppositeAccNo");
            String out_oppositeAccNo = row.getChildTextTrim("out_oppositeAccNo");
            String oppositeAccName = row.getChildTextTrim("oppositeAccName");
            String cd_flag = row.getChildTextTrim("onloanFlag");
            String creditAmt = row.getChildTextTrim("creditAmount");
            String debitAmt = row.getChildTextTrim("debitAmount");
            String tran_date = row.getChildTextTrim("transferDate");
            String tran_time = row.getChildTextTrim("transferTime");
            String balance = row.getChildTextTrim("balance");
            String transDesc = row.getChildTextTrim("TransDesc");
            String purpose = row.getChildTextTrim("purpose");
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(rqst.getBankCurrency());
            detail.setAccNo(rqst.getAcnt().getAccNo());
            detail.setAccName(rqst.getAcnt().getAccName());
            detail.setBankName(rqst.getAcnt().getBankName());
            if (!StringUtils.isEmpty((String)oppositeAccNo) && !"0".equalsIgnoreCase(oppositeAccNo)) {
                detail.setOppAccNo(oppositeAccNo);
            } else {
                detail.setOppAccNo(out_oppositeAccNo);
            }
            detail.setOppAccName(oppositeAccName);
            detail.setOppBankName("");
            if ("C".equals(cd_flag)) {
                detail.setDebitAmount(Parser.ZERO);
                detail.setCreditAmount(new BigDecimal(creditAmt));
            } else if ("D".equals(cd_flag)) {
                detail.setDebitAmount(new BigDecimal(debitAmt));
                detail.setCreditAmount(Parser.ZERO);
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u65b9\u5411<CR_DR_MAINT_IND>\u4e3a%s,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u7684\u501f\u8d37\u65b9\u5411", (String)"DetailParser_5", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]), cd_flag));
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            detail.setExplanation(purpose);
            if (StringUtils.isEmpty((String)tran_date)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f<transferDate>\u4e3a\u7a7a.\u8bf7\u54a8\u8be2\u94f6\u884c\u5904\u7406.", (String)"DetailParser_3", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]));
            }
            LocalDateTime transTime = null;
            transTime = StringUtils.isEmpty((String)tran_time) ? LocalDateTime.parse(tran_date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(tran_date + tran_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detail.setTransDate(LocalDate.parse(tran_date, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setTransTime(transTime);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detailList.add(detail);
        }
        return detailList;
    }
}

