/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qdb.dc.services.payment.allocation;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qdb.dc.services.Packer;
import kd.ebg.aqap.banks.qdb.dc.services.Parser;
import kd.ebg.aqap.banks.qdb.dc.services.Utils;
import kd.ebg.aqap.banks.qdb.dc.services.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.banks.qdb.dc.services.sign.SignHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE103";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5212\u4e0b\u62e8\uff08CBE103\uff09", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_capital_allocation".equals(paymentInfo.getSubBizType()) && !paymentInfo.is2Individual() || "pay".equals(paymentInfo.getSubBizType()) && UseConvertor.isTransfer((PaymentInfo)paymentInfo) && !paymentInfo.is2Individual();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        if (null == paymentInfos || paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8\u3002", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]));
        }
        PaymentInfo payInfo = paymentInfos[0];
        Element root = Packer.ccreateCommonHead("CBE103", payInfo.getBankBatchSeqId());
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"transType", (String)(UseConvertor.isTransUp((PaymentInfo)payInfo) ? "0" : "1"));
        JDomUtils.addChild((Element)ReqParam, (String)"payAccount", (String)payInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"payAccountName", (String)payInfo.getAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"recAccount", (String)payInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"recAccountName", (String)payInfo.getIncomeAccName());
        JDomUtils.addChild((Element)ReqParam, (String)"payAmount", (String)BigDecimalHelper.plain2((BigDecimal)payInfo.getAmount()));
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)payInfo.getCurrency());
        JDomUtils.addChild((Element)ReqParam, (String)"payUse", (String)payInfo.getExplanation());
        StringBuilder signDataFieldBuffer = new StringBuilder();
        signDataFieldBuffer.append(payInfo.getBankBatchSeqId()).append("|");
        signDataFieldBuffer.append(payInfo.getAccNo()).append("|");
        signDataFieldBuffer.append(payInfo.getIncomeAccNo()).append("|");
        signDataFieldBuffer.append(payInfo.getCurrency()).append("|");
        signDataFieldBuffer.append(BigDecimalHelper.plain2((BigDecimal)payInfo.getAmount())).append("|");
        String signData = SignHelper.sign(signDataFieldBuffer.toString());
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)signData);
        JDomUtils.addChild((Element)ReqParam, (String)"signDataField", (String)signDataFieldBuffer.toString());
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2", (String)"");
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.createRequestMsg("CBE103", xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        BankResponse rsp = Parser.parseHeader(rspStr);
        if ("EBLN5004".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element root = JDomUtils.string2Root((String)Parser.getRespXml(rspStr), (String)RequestContextUtils.getCharset());
            Element opResult = root.getChild("opRep").getChild("opResult");
            String orderState = opResult.getChildTextTrim("orderState");
            String responseResult = opResult.getChildTextTrim("responseResult");
            if ("90".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AllocationPayImpl_2", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]), (String)orderState, (String)responseResult);
            } else if ("91".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)orderState, (String)responseResult);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)orderState, (String)responseResult);
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(Packer.getUrl());
        Packer.setContentType(factory);
        return factory;
    }
}

