/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.qdb.dc.services.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.qdb.dc.services.Packer;
import kd.ebg.aqap.banks.qdb.dc.services.Parser;
import kd.ebg.aqap.banks.qdb.dc.services.Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "CBE005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5212\u4e0b\u62e8\uff08CBE103\uff09", (String)"AllocationQueryPayImpl_0", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        if (null == paymentInfos || paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u540c\u6b65\u3002", (String)"AllocationQueryPayImpl_1", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]));
        }
        Element root = Packer.ccreateCommonHead("CBE005");
        Element ReqParam = root.getChild("opReq").getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"orderFlowNo", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"ReqReserved2", (String)"");
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.createRequestMsg("CBE005", xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        PaymentInfo[] paymentInfos = Utils.listToArray(request.getPaymentInfos());
        BankResponse rsp = Parser.parseHeader(rspStr);
        if ("EBLN5004".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"0000".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            Element root = JDomUtils.string2Root((String)Parser.getRespXml(rspStr), (String)RequestContextUtils.getCharset());
            Element opResult = root.getChild("opRep").getChild("opResult");
            String orderState = opResult.getChildTextTrim("orderState");
            String responseResult = opResult.getChildTextTrim("responseResult");
            if ("90".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AllocationQueryPayImpl_2", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]));
            } else if ("91".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)orderState, (String)responseResult);
            } else if ("95".equals(orderState)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)orderState, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406\uff0c%s\u3002", (String)"AllocationQueryPayImpl_4", (String)"ebg-aqap-banks-qdb-dc", (Object[])new Object[0]), responseResult));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)orderState, (String)responseResult);
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(Packer.getUrl());
        Packer.setContentType(factory);
        return factory;
    }
}

