/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.orm.util.Assert;
import kd.ebg.aqap.common.constant.BankFileTypeEnum;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractOverseaHandler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import org.apache.commons.io.FileUtils;

public abstract class AbstractMT942Handler
extends AbstractOverseaHandler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractMT942Handler.class);

    protected abstract void processFile(File var1, List<OverseaDetail> var2, List<PaymentInfo> var3, List<OverseaBalance> var4);

    public void run() {
        try {
            this.preTask();
            this.logger.infoIndex("\u5f00\u59cb\u5904\u7406\u94f6\u884c\u65e5\u95f4\u5bf9\u8d26\u5355\u6587\u4ef6");
            EBContext context = EBContext.getContext();
            Assert.notNull((Object)context, (String)"EBContext not init");
            String mt942FilePath = OverseaFileStorageUtil.getMT942FilePath(context.getBankVersionID());
            List<File> files = OverseaFileStorageUtil.scanFiles(FileCommonUtils.getFileByPath((String)mt942FilePath));
            if (CollectionUtil.isEmpty(files)) {
                this.logger.info("\u626b\u63cf\u94f6\u884cMT942/CAMT052\u6587\u4ef6\u76ee\u5f55{}\u83b7\u53d6\u5230\u6587\u4ef6\u6570\u91cf\u4e3a0,\u672c\u6b21\u4e0d\u5904\u7406", (Object)mt942FilePath);
                return;
            }
            this.logger.info("\u626b\u63cf\u94f6\u884cMT942/CAMT052\u6587\u4ef6\u76ee\u5f55{}\u83b7\u53d6\u5230\u6587\u4ef6\u6570\u91cf\uff1a{}", new Object[]{mt942FilePath, files.size()});
            files.forEach(file -> {
                File newFile = null;
                try {
                    String fileType = BankFileTypeEnum.MT942.getName();
                    String fileName = file.getName().toUpperCase(Locale.ENGLISH);
                    if (fileName.contains("CAMT052") || fileName.contains("CAMT52")) {
                        fileType = BankFileTypeEnum.CAMT052.getName();
                    }
                    this.saveFileContentToDB(FileUtils.readFileToString((File)file, (String)RequestContextUtils.getCharset()), file.getName(), fileType);
                    newFile = this.handleDecryFile((File)file);
                    String needPgp = RequestContextUtils.getBankParameterValue((String)"is_need_pgp");
                    if (Boolean.parseBoolean(needPgp)) {
                        String newName = newFile.getName();
                        newName = "decryption_" + newName;
                        this.saveFileContentToDB(FileUtils.readFileToString((File)newFile, (String)RequestContextUtils.getCharset()), newName, fileType);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u89e3\u5bc6\u6587\u4ef6" + file.getName() + "\u5f02\u5e38", (Throwable)e);
                }
                if (newFile != null && newFile.exists()) {
                    ArrayList<OverseaDetail> detailInfoList = new ArrayList<OverseaDetail>(16);
                    ArrayList<PaymentInfo> payInfoList = new ArrayList<PaymentInfo>(16);
                    ArrayList<OverseaBalance> balanceInfoList = new ArrayList<OverseaBalance>(16);
                    this.processFile(newFile, detailInfoList, payInfoList, balanceInfoList);
                    this.logger.info("\u94f6\u884c\u7684\u660e\u7ec6\u62a5\u544a\uff1a\u6587\u4ef6\u540d=" + file.getName() + ",\u660e\u7ec6\u8bb0\u5f55\u6761\u6570=" + detailInfoList.size());
                    OverseaDBHelper.updateDetailAndPayStateAndBalanceFromMT942(detailInfoList, payInfoList, balanceInfoList);
                    OverseaFileStorageUtil.cutFile(file, OverseaFileStorageUtil.getMT942BakFilePath(context.getBankVersionID()));
                    this.logger.info("\u5907\u4efd\u94f6\u884c\u7684MT942/CAMT052\u660e\u7ec6\u62a5\u544a\u6210\u529f\uff1a" + file.getName());
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u94f6\u884c\u7684MT942/CAMT052\u6587\u4ef6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            this.afterTask();
        }
    }
}

