/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea.bank;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IPayTransfer;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.constant.BankFileTypeEnum;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.BankFile;
import kd.ebg.aqap.common.model.repository.BankFileRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.utils.FileContentWriterUtil;
import kd.ebg.aqap.proxy.oversea.utils.GetKeyStoreHelper;
import kd.ebg.aqap.proxy.oversea.utils.OverseaFileStorageUtil;
import kd.ebg.aqap.proxy.oversea.utils.OverseaSFTPUtils;
import kd.ebg.aqap.proxy.oversea.utils.PgpHelper;
import kd.ebg.aqap.proxy.oversea.utils.SSHDSftpUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBExceptionEnum;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.sdk.ebg.trd.proxy.pgp.SDKPrivateKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKPublicKey;
import kd.sdk.ebg.trd.proxy.pgp.SDKSecretKey;
import org.apache.commons.io.IOUtils;

public abstract class AbstractOverseaPayImpl
implements IPayTransfer,
IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractOverseaPayImpl.class);
    public static final int PROCESS_PACK = EBExceptionEnum.PACK_EXCEPTION.getId();
    public static final int PROCESS_CONNECTION = EBExceptionEnum.CONNECTION_EXCEPTION.getId();
    public static final int PROCESS_CONNECTED = EBExceptionEnum.CONNECTED_EXCEPTION.getId();
    public static final int PROCESS_PARSE = EBExceptionEnum.PARSE_EXCEPTION.getId();

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            String requestStr = this.pack(request);
            String filePath = this.writePayFile(requestStr, this.getPayFileName(request));
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
            String useSSHD = RequestContextUtils.getBankParameterValue((String)"sftp_is_use_sshd");
            ChannelSftp channelSftp = null;
            if (!Boolean.parseBoolean(useSSHD)) {
                channelSftp = this.getSFTPConnect();
            }
            try {
                boolean upload = this.sendPayFileToBank(filePath, channelSftp, Boolean.parseBoolean(useSSHD));
                EBBankPayResponse response = this.parse(request, String.valueOf(upload));
                return response;
            }
            catch (Throwable t) {
                EBContext.getContext().setThrowableAfterSend(t);
                return null;
            }
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = "";
            if (EBContext.getContext().getProcessFlag() == PROCESS_CONNECTION) {
                errorMsg = ResManager.loadKDString((String)"\u521b\u5efa\u4ed8\u6b3e\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AbstractOverseaPayImpl_5", (String)"ebg-aqap-proxy", (Object[])new Object[0]);
            } else if (PROCESS_PACK == EBContext.getContext().getProcessFlag()) {
                errorMsg = ResManager.loadKDString((String)"\u6253\u5305\u94f6\u884c\u4ed8\u6b3e\u8bf7\u6c42\u62a5\u6587\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AbstractOverseaPayImpl_6", (String)"ebg-aqap-proxy", (Object[])new Object[0]);
            }
            throw EBExceiptionUtil.payFailException((String)errorMsg, (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String submitSuccess) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        if (Boolean.parseBoolean(submitSuccess)) {
            EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"AbstractOverseaPayImpl_1", (String)"ebg-aqap-proxy", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u81f3SFTP\u6210\u529f\u3002", (String)"AbstractOverseaPayImpl_3", (String)"ebg-aqap-proxy", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentStateWithoutBatchSizeCheck((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"AbstractOverseaPayImpl_2", (String)"ebg-aqap-proxy", (Object[])new Object[0]), (String)"", (String)ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u81f3SFTP\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4ed8\u6b3e\u7ed3\u679c\u3002", (String)"AbstractOverseaPayImpl_4", (String)"ebg-aqap-proxy", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private ChannelSftp getSFTPConnect() throws JSchException {
        return OverseaSFTPUtils.getInstance().connect();
    }

    private boolean sendPayFileToBank(String plainFilePath, ChannelSftp channelSftp, boolean isUseSSHD) {
        this.logger.info("\u5f00\u59cb\u4e0a\u4f20\u652f\u4ed8\u6587\u4ef6\uff1a" + plainFilePath);
        boolean uploadSuccess = isUseSSHD ? SSHDSftpUtil.getInstance().upload(plainFilePath) : OverseaSFTPUtils.getInstance().upload(plainFilePath, channelSftp);
        if (uploadSuccess) {
            this.logger.info("\u6210\u529f-\u4e0a\u4f20\u652f\u4ed8\u6587\u4ef6\u3002");
        }
        return uploadSuccess;
    }

    protected String writePayFile(String payMsg, String payFileName) throws Exception {
        this.saveFileContent(payMsg, payFileName);
        String needPgp = RequestContextUtils.getBankParameterValue((String)"is_need_pgp");
        if ("true".equalsIgnoreCase(needPgp)) {
            return this.encryPgpFile(payMsg, payFileName);
        }
        EBContext context = EBContext.getContext();
        String paymentFileDir = OverseaFileStorageUtil.getOverseaPayFilePath(context.getBankVersionID());
        String filePath = paymentFileDir + File.separator + payFileName;
        this.logger.info("\u5f00\u59cb\u751f\u6210\u539f\u59cb\u652f\u4ed8\u6587\u4ef6\uff1a" + filePath);
        FileContentWriterUtil.writeUTF8FileContent((String)filePath, (String)payMsg);
        this.logger.info("\u6210\u529f-\u751f\u6210\u539f\u59cb\u652f\u4ed8\u6587\u4ef6");
        return filePath;
    }

    private void saveFileContent(String payMsg, String payFileName) {
        try {
            BankFile bankFile = new BankFile();
            bankFile.setFileName(payFileName);
            bankFile.setFileType(BankFileTypeEnum.PAY.getName());
            bankFile.setTransDate(LocalDate.now());
            bankFile.setFileContent(payMsg);
            bankFile.setCustomID(EBContext.getContext().getCustomID());
            bankFile.setBankVersionId(EBContext.getContext().getBankVersionID());
            bankFile.setAccNo(EBContext.getContext().getBankAcnt().getAccNo());
            bankFile.setCreateTime(LocalDateTime.now());
            BankFileRepository bankFileRepository = (BankFileRepository)SpringContextUtil.getBean(BankFileRepository.class);
            bankFileRepository.save(bankFile);
        }
        catch (Throwable e) {
            this.logger.error("\u4ed8\u6b3e\u539f\u59cb\u6587\u4ef6\u5165\u5e93\u5f02\u5e38,\u5ffd\u7565", e);
        }
    }

    protected abstract String getPayFileName(BankPayRequest var1);

    protected String encryPgpFile(String payMsg, String payFileName) throws Exception {
        String originPath;
        File originFile;
        String paymentFileDir = this.getPayFilePath();
        String pgpPublicKey = GetKeyStoreHelper.getPgpPublicKey((String)"bank_pgp_public_key");
        String pgpPrivateKey = GetKeyStoreHelper.getPgpPrivateKey((String)"custom_pgp_private_key");
        char[] password = RequestContextUtils.getBankParameterValue((String)"custom_pgp_private_key_ciper").toCharArray();
        PgpHelper pgp = PgpHelper.getInstance();
        SDKSecretKey secretKey = pgp.readSecretKey(IOUtils.toInputStream((String)pgpPrivateKey, (String)RequestContextUtils.getCharset()));
        SDKPrivateKey prKey = pgp.findSecretKey(secretKey, password);
        SDKPublicKey puKey = pgp.readPublicKey(IOUtils.toInputStream((String)pgpPublicKey, (String)RequestContextUtils.getCharset()));
        EBContext context = EBContext.getContext();
        String dir = OverseaFileStorageUtil.getOverseaIgnoreFilePath(context.getBankVersionID());
        File file = FileCommonUtils.getFileByPath((String)dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(originFile = FileCommonUtils.getFileByPath((String)(originPath = dir + File.separator + "origin_" + payFileName))).exists()) {
            boolean newFile = originFile.createNewFile();
            this.logger.info("createNewFile:{}", (Object)newFile);
        }
        String filePath = paymentFileDir + File.separator + payFileName;
        this.logger.info("\u5f00\u59cb\u751f\u6210\u539f\u59cb\u652f\u4ed8\u6587\u4ef6\uff1a" + originPath);
        FileContentWriterUtil.writeUTF8FileContent((String)originPath, (String)payMsg);
        this.logger.info("\u751f\u6210\u539f\u59cb\u652f\u4ed8\u6587\u4ef6\u6210\u529f\u3002");
        this.logger.info("\u5f00\u59cb\u52a0\u5bc6\u539f\u59cb\u652f\u4ed8\u6587\u4ef6\uff1a" + filePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(FileCommonUtils.getFileByPath((String)filePath));
             FileInputStream fileInputStream = new FileInputStream(FileCommonUtils.getFileByPath((String)originPath));){
            pgp.encryptAndSign((OutputStream)fileOutputStream, (InputStream)fileInputStream, puKey, prKey);
        }
        this.logger.info("\u751f\u6210\u52a0\u5bc6\u652f\u4ed8\u6587\u4ef6\u6210\u529f\u3002");
        this.bakPayFile(originPath);
        return filePath;
    }

    private void bakPayFile(String plainFilePath) throws Exception {
        this.logger.info("\u5f00\u59cb\u5907\u4efd\u6587\u4ef6\uff1a" + plainFilePath);
        this.bakFile(FileCommonUtils.getFileByPath((String)plainFilePath));
        this.logger.info("\u6210\u529f-\u5907\u4efd\u6587\u4ef6");
    }

    private boolean bakFile(File file) {
        if (!file.exists()) {
            return true;
        }
        File dir = file.getParentFile();
        File destDir = FileCommonUtils.getFileByPath((String)(dir.getParentFile() + File.separator + dir.getName() + "_bak"));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File destFile = FileCommonUtils.getFileByPath((String)destDir.getAbsolutePath(), (String)file.getName());
        int index = 1;
        while (destFile.exists()) {
            destFile = FileCommonUtils.getFileByPath((String)destDir.getAbsolutePath(), (String)(file.getName() + "-" + index));
            ++index;
        }
        return file.renameTo(destFile);
    }

    private String getPayFilePath() {
        EBContext context = EBContext.getContext();
        String paymentFileDir = OverseaFileStorageUtil.getOverseaPayFilePath(context.getBankVersionID());
        String filePath = paymentFileDir + File.separator;
        return filePath;
    }

    private boolean bakFile(String bakDir, File file) {
        if (!file.exists()) {
            return true;
        }
        File destDir = FileCommonUtils.getFileByPath((String)(bakDir + "_bak"));
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File destFile = FileCommonUtils.getFileByPath((String)destDir.getAbsolutePath(), (String)file.getName());
        int index = 1;
        while (destFile.exists()) {
            destFile = FileCommonUtils.getFileByPath((String)destDir.getAbsolutePath(), (String)(file.getName() + "-" + index));
            ++index;
        }
        return file.renameTo(destFile);
    }

    public void preCheckInterface(BankPayRequest request) {
    }
}

