/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.ebg.aqap.proxy.swift.exception.SwiftException;
import kd.ebg.aqap.proxy.swift.model.SwiftBlock;
import kd.ebg.egf.common.log.EBGLogger;

public final class SwiftApplicationHeaderBlock
extends SwiftBlock {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SwiftApplicationHeaderBlock.class);
    private static final long serialVersionUID = 1L;
    public static final String BLOCKTYPE = "2:";
    private String ioType;
    private String messageType;
    private String inputTime;
    private String mir;
    private Date outputDateTime;
    private String messagePriority;
    private String senderDate = "";
    private String receiverBIC = "";
    private String uniqueReference = "";

    public void parserText() {
        if (this.unParserText == null) {
            return;
        }
        try {
            if (this.unParserText.trim().length() != 51) {
                String msg = "Parse Application Header Block error, the length of unParserText is not 51.";
                throw new SwiftException(msg);
            }
            String content = this.getUnParserText().trim();
            if (!content.startsWith("{2:")) {
                throw new SwiftException("The block start is not matched for SwiftApplicationHeaderBlock : " + content.substring(0, 3));
            }
            if (!content.endsWith("}")) {
                throw new SwiftException("The block end is not matched for SwiftApplicationHeaderBlock : " + content.substring(content.length() - 1));
            }
            content = this.unParserText.substring(3, content.length() - 1);
            this.ioType = content.substring(0, 1);
            this.messageType = content.substring(1, 4);
            this.inputTime = content.substring(4, 8);
            this.mir = this.unParserText.substring(11, 39);
            this.senderDate = content.substring(8, 14);
            this.receiverBIC = content.substring(14, 26);
            this.uniqueReference = content.substring(26, 46);
            this.messagePriority = this.unParserText.substring(46, 47);
            this.outputDateTime = new SimpleDateFormat("yyMMddHHmm").parse(this.senderDate + this.inputTime);
        }
        catch (ParseException e) {
            logger.info("\u5934\u90e8\u4fe1\u606f\u57572\u7684\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff1a{}\u3002", (Object)this.unParserText);
        }
        catch (Exception e) {
            logger.info("\u5934\u90e8\u4fe1\u606f\u57572\u7684\u683c\u5f0f\u6709\u8bef\uff1a{}\u3002", (Object)this.unParserText);
        }
    }

    public String getMessageType() {
        return this.messageType;
    }

    public Date getOutputDateTime() {
        return this.outputDateTime;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public String getIOType() {
        return this.ioType;
    }

    public String getMIR() {
        return this.mir;
    }

    public String getInputTime() {
        return this.inputTime;
    }

    public String getSenderDate() {
        return this.senderDate;
    }

    public String getReceiverBIC() {
        return this.receiverBIC;
    }

    public String getUniqueReference() {
        return this.uniqueReference;
    }

    public String toString() {
        return "Block2{messageType='" + this.messageType + '\'' + ", senderDate='" + this.senderDate + '\'' + ", receiverBIC='" + this.receiverBIC + '\'' + ", uniqueReference='" + this.uniqueReference + '\'' + '}';
    }
}

