/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.payment.salary;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.banks.pab.dc.services.payment.salary.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"4047", (String)"PayImpl_6", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"PayImpl_8", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isSalary(info);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        String busiType = BankBusinessConfig.getSalaryBusiType(paymentInfos[0].getAccNo());
        if (null == busiType || busiType.length() == 0) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"'\u4ee3\u6536\u4ed8\u7684\u8d39\u9879\u4ee3\u7801'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011\uff0c'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u8d26\u53f7[%s]\u7684'\u4ee3\u6536\u4ed8\u7684\u8d39\u9879\u4ee3\u7801'\u3002", (String)"PayImpl_13", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), paymentInfos[0].getAccNo()));
        }
        String agreeNo = BankBusinessConfig.getSalaryAgreeNo(paymentInfos[0].getAccNo());
        if (null == agreeNo || agreeNo.length() == 0) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"'\u59d4\u6258\u5355\u4f4d\u534f\u8bae\u53f7'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5230\u3010\u67e5\u8be2\u4e0e\u652f\u4ed8\u3011\uff0c'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u8d26\u53f7[%s]\u7684'\u59d4\u6258\u5355\u4f4d\u534f\u8bae\u53f7'\u3002", (String)"PayImpl_14", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), paymentInfos[0].getAccNo()));
        }
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"ThirdVoucher", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)Result, (String)"AGREE_NO", (String)agreeNo);
        JDomUtils.addChild((Element)Result, (String)"BusiType", (String)busiType);
        JDomUtils.addChild((Element)Result, (String)"PayType", (String)"1");
        JDomUtils.addChild((Element)Result, (String)"Currency", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)Result, (String)"OthBankFlag", (String)"");
        JDomUtils.addChild((Element)Result, (String)"SrcAccNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)Result, (String)"TotalNum", (String)String.valueOf(paymentInfos.length));
        Element totalAmountElement = JDomUtils.addChild((Element)Result, (String)"TotalAmount");
        JDomUtils.addChild((Element)Result, (String)"SettleType", (String)"1");
        if (paymentInfos[0].getMerge().booleanValue()) {
            JDomUtils.addChild((Element)Result, (String)"AccountType", (String)"0");
        } else {
            JDomUtils.addChild((Element)Result, (String)"AccountType", (String)"2");
        }
        BigDecimal totalAmont = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            totalAmont = totalAmont.add(paymentInfos[i].getAmount());
            Element HOResultSet4047R = JDomUtils.addChild((Element)Result, (String)"HOResultSet4047R");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"SThirdVoucher", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"CstInnerFlowNo", (String)"");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OthAreaFlag", (String)(paymentInfos[i].is2SameCity() ? "N" : "Y"));
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"IdType", (String)"");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"IdNo", (String)"");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppAccNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppAccName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OthBankFlag", (String)(paymentInfos[i].is2SameBank() ? "N" : "Y"));
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppBranchId", (String)paymentInfos[i].getIncomeCnaps());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"Province", (String)paymentInfos[i].getIncomeProvince());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"City", (String)paymentInfos[i].getIncomeCity());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfos[i].getAmount()));
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"PostScript", (String)paymentInfos[i].getExplanation());
        }
        totalAmountElement.setText(BigDecimalHelper.plain2((BigDecimal)totalAmont));
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead((String)Sequence.genSequence(), (String)"4047", (String)xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse((String)responseStr, (BankResponse)bankRsp);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

