/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.dc.service;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bjb.dc.service.BjbUtils;
import kd.ebg.aqap.banks.bjb.dc.service.sign.SignHelper;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.services.usekeyword.UseKeyWordService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class PackerUtil {
    private static final String USER_CODE = "-1";

    public static Element createRequestHead(String opName, String serialNo) {
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)opReq, (String)"opName", (String)opName);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)BjbUtils.formatDate((LocalDate)LocalDate.now()));
        return opReq;
    }

    public static String joinRequest(Element element, String opName) {
        return PackerUtil.joinRequest(element, opName, false);
    }

    public static String joinRequest(Element element, String opName, boolean sign) {
        String data = JDomUtils.root2String((Element)element, (String)"GB18030");
        if (sign) {
            data = SignHelper.sign((String)data);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("opName").append("=").append(opName).append("&").append("reqData").append("=").append(data);
        return builder.toString();
    }

    public static String packDetail(BankDetailRequest request, boolean isHis) {
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead(isHis ? "CebankqueryHisDetailNoSerialOp" : "CebankQryCurDetailAddWLOp", Sequence.genSequence());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        JDomUtils.addChild((Element)param, (String)"accountNo", (String)request.getAcnt().getAccNo());
        if (isHis) {
            JDomUtils.addChild((Element)param, (String)"beginDate", (String)BjbUtils.formatDate((LocalDate)request.getStartDate()));
            JDomUtils.addChild((Element)param, (String)"endDate", (String)BjbUtils.formatDate((LocalDate)request.getEndDate()));
        } else {
            JDomUtils.addChild((Element)param, (String)"dOcFlag", (String)"");
        }
        JDomUtils.addChild((Element)param, (String)"minAmount", (String)"0");
        JDomUtils.addChild((Element)param, (String)"maxAmount", (String)"9999999999999999");
        if (isHis) {
            JDomUtils.addChild((Element)param, (String)"checkNum", (String)"");
        }
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, isHis ? "CebankqueryHisDetailNoSerialOp" : "CebankQryCurDetailAddWLOp");
    }

    public static String convertUseCn(PaymentInfo paymentInfo) {
        String useCode = paymentInfo.getUseCode();
        String useCn = paymentInfo.getUseCn();
        if (USER_CODE.equalsIgnoreCase(useCode)) {
            String customId = EBContext.getContext().getCustomID();
            String interfaceName = "CebankPayWithNewPrecontractOp";
            String bankVersion = "BJB_DC";
            useCode = UseKeyWordService.getUseByKey((String)customId, (String)useCn, (String)interfaceName, (String)useCode, (String)bankVersion);
            return useCode;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5c1a\u672a\u5b9e\u73b0\u4ed8\u6b3e\u7528\u9014\u7edf\u4e00\u7f16\u7801%s\u3002", (String)"PackerUtil_3", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]), useCode));
    }

    public static String getExplanationForSalary(PaymentInfo info) {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            return BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation());
        }
        return info.getExplanation();
    }

    public static String getKDMarkForBatchPay(List<PaymentInfo> paymentInfos) {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankBatchSeqID(paymentInfos);
            return BizNoUtil.cont((String)paymentInfos.get(0).getBankBatchSeqId(), (String)"");
        }
        return "";
    }

    public static String packPay(BankPayRequest request, String opName, boolean appoint) {
        List paymentInfos = request.getPaymentInfos();
        Preconditions.checkState((paymentInfos != null && paymentInfos.size() > 0 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u95ee\u9898\uff0c\u672a\u89e3\u6790\u5230\u4ed8\u6b3e\u4fe1\u606f\u3002", (String)"PackerUtil_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        if (paymentInfos == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u95ee\u9898\uff0c\u672a\u89e3\u6790\u5230\u4ed8\u6b3e\u4fe1\u606f\u3002", (String)"PackerUtil_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        }
        if (paymentInfos.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u6570\u636e\u683c\u5f0f\u95ee\u9898\uff0c\u672a\u89e3\u6790\u5230\u4ed8\u6b3e\u4fe1\u606f\u3002", (String)"PackerUtil_1", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        }
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead(opName, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JDomUtils.addChild((Element)param, (String)"payEnpName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)param, (String)"payAcct", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)param, (String)"recAcct", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)param, (String)"recAcctName", (String)paymentInfo.getIncomeAccName());
        if (appoint) {
            JDomUtils.addChild((Element)param, (String)"recProvince", (String)paymentInfo.getIncomeProvince());
            JDomUtils.addChild((Element)param, (String)"recCity", (String)paymentInfo.getIncomeCity());
        }
        JDomUtils.addChild((Element)param, (String)"recBankName", (String)paymentInfo.getIncomeBankName());
        if (appoint) {
            JDomUtils.addChild((Element)param, (String)"recBankNo", (String)"");
        }
        JDomUtils.addChild((Element)param, (String)"amount", (String)BjbUtils.bigDecimal2Str((BigDecimal)paymentInfo.getAmount()));
        if (appoint) {
            JDomUtils.addChild((Element)param, (String)"payUse", (String)paymentInfo.getExplanation());
        } else if (BankBusinessConfig.isAddKDFlagToPay()) {
            String use = PackerUtil.getExplanationForSalary(paymentInfo);
            String TransUp = paymentInfo.getTransUp();
            if (!StringUtils.isEmpty((CharSequence)TransUp) && "TRUE".equalsIgnoreCase(TransUp)) {
                use = use + "TS@";
            }
            JDomUtils.addChild((Element)param, (String)"payUse", (String)use);
        } else {
            JDomUtils.addChild((Element)param, (String)"payUse", (String)(paymentInfo.is2Individual() ? PackerUtil.convertUseCn(paymentInfo) : paymentInfo.getExplanation()));
        }
        JDomUtils.addChild((Element)param, (String)"remark", (String)paymentInfo.getExplanation());
        String transFlag = "0";
        String transmitType = "0";
        if (!paymentInfo.is2SameBank()) {
            transFlag = paymentInfo.is2SameCity() ? "1" : "2";
            transmitType = "2";
        }
        JDomUtils.addChild((Element)param, (String)"transFlag", (String)transFlag);
        JDomUtils.addChild((Element)param, (String)"transmitType", (String)transmitType);
        JDomUtils.addChild((Element)param, (String)"recDepType", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)param, (String)"isAgreeFlag", (String)"1");
        if (appoint) {
            JDomUtils.addChild((Element)param, (String)"remark1", (String)"");
            JDomUtils.addChild((Element)param, (String)"remark2", (String)"");
            JDomUtils.addChild((Element)param, (String)"remark3", (String)"");
            JDomUtils.addChild((Element)param, (String)"remark4", (String)"");
        }
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, opName, true);
    }

    public static String packSalary(BankPayRequest request, String opName) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead(opName, paymentInfo.getBankBatchSeqId());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        String paySalaryNo = BankBusinessConfig.getPaySalaryNo(paymentInfo.getAccNo());
        if (StringUtils.isBlank((CharSequence)paySalaryNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"'\u4ee3\u53d1\u5de5\u8d44\u4ee3\u7406\u5355\u4f4d\u7f16\u53f7'\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91-\u94f6\u4f01\u57fa\u7840\u8d44\u6599-\u94f6\u4f01\u8d26\u6237-\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"PackerUtil_2", (String)"ebg-aqap-banks-bjb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)param, (String)"paySalaryNo", (String)paySalaryNo);
        JDomUtils.addChild((Element)param, (String)"payDepAcc", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)param, (String)"precontractTime", (String)"");
        JDomUtils.addChild((Element)param, (String)"totalNum", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)param, (String)"totalAmt", (String)BjbUtils.bigDecimal2Str((BigDecimal)paymentInfo.getTotalAmount()));
        JDomUtils.addChild((Element)param, (String)"currencyType", (String)"01");
        JDomUtils.addChild((Element)param, (String)"bankBookSummary", (String)BjbUtils.subStringByte((String)paymentInfo.getExplanation(), (int)4));
        JDomUtils.addChild((Element)param, (String)"tranMode", (String)"0");
        JDomUtils.addChild((Element)param, (String)"reqReserved1", (String)PackerUtil.getKDMarkForBatchPay(paymentInfos));
        JDomUtils.addChild((Element)param, (String)"reqReserved2", (String)"");
        Element opReqSet = JDomUtils.addChild((Element)param, (String)"opReqSet");
        int len = paymentInfos.size();
        for (int i = 0; i < len; ++i) {
            Element opRequest = JDomUtils.addChild((Element)opReqSet, (String)"opRequest");
            JDomUtils.addChild((Element)opRequest, (String)"orderNo", (String)((PaymentInfo)paymentInfos.get(i)).getBankSerialNo());
            JDomUtils.addChild((Element)opRequest, (String)"recPerAcc", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)opRequest, (String)"recPerName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)opRequest, (String)"certType", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"certNum", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"payAmt", (String)BjbUtils.bigDecimal2Str((BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount()));
            JDomUtils.addChild((Element)opRequest, (String)"userRem", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"reqReserved3", (String)"");
            JDomUtils.addChild((Element)opRequest, (String)"reqReserved4", (String)"");
        }
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, opName, true);
    }

    public static String packSalaryQuery(BankPayRequest request, String opName) {
        Element root = new Element("BCCBEBankData");
        Element head = PackerUtil.createRequestHead(opName, Sequence.genSequence());
        Element param = JDomUtils.addChild((Element)head, (String)"ReqParam");
        JDomUtils.addChild((Element)param, (String)"batchSerialNo", (String)((PaymentInfo)request.getPaymentInfos().get(0)).getPackageId());
        JDomUtils.addChild((Element)root, (Element)head);
        return PackerUtil.joinRequest(root, opName);
    }
}

