/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.entity.biz.status;

import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;

public enum EbStatus {
    EB_PROCESSING("EB_PROCESSING"),
    BANK_PROCESSING("BANK_PROCESSING"),
    BANK_SUCCESS("BANK_SUCCESS"),
    BANK_FAIL("BANK_FAIL"),
    BANK_UNKNOWN("BANK_UNKNOWN"),
    EB_ROLL_BACK("EB_ROLL_BACK"),
    INVALIDATED("EB_INVALIDATED");

    private String name;

    private EbStatus(String name) {
        this.setName(name);
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static EbStatus convertBankState2EBG(PaymentState bankState) {
        if (bankState == PaymentState.INITIAL) {
            return EB_PROCESSING;
        }
        if (bankState == PaymentState.SUBMITTING) {
            return EB_PROCESSING;
        }
        if (bankState == PaymentState.SUBMITED) {
            return BANK_PROCESSING;
        }
        if (bankState == PaymentState.FAIL) {
            return BANK_FAIL;
        }
        if (bankState == PaymentState.UNKNOWN) {
            return BANK_UNKNOWN;
        }
        if (bankState == PaymentState.SUCCESS) {
            return BANK_SUCCESS;
        }
        if (bankState == PaymentState.DETAIL_BIZ_NO_INVALIDATED) {
            return INVALIDATED;
        }
        if (bankState == PaymentState.ROLL_BACK) {
            return EB_ROLL_BACK;
        }
        return EB_PROCESSING;
    }

    public static EbStatus convertBankState2EBG(CurAndFixedState bankState) {
        if (bankState == CurAndFixedState.INITIAL) {
            return EB_PROCESSING;
        }
        if (bankState == CurAndFixedState.SUBMITTING) {
            return EB_PROCESSING;
        }
        if (bankState == CurAndFixedState.SUBMITED) {
            return BANK_PROCESSING;
        }
        if (bankState == CurAndFixedState.FAIL) {
            return BANK_FAIL;
        }
        if (bankState == CurAndFixedState.UNKNOWN) {
            return BANK_UNKNOWN;
        }
        if (bankState == CurAndFixedState.SUCCESS) {
            return BANK_SUCCESS;
        }
        if (bankState == CurAndFixedState.DETAIL_BIZ_NO_INVALIDATED) {
            return INVALIDATED;
        }
        return EB_PROCESSING;
    }

    public static EbStatus convertBankState2EBG(FinancingState bankState) {
        if (bankState == FinancingState.INITIAL) {
            return EB_PROCESSING;
        }
        if (bankState == FinancingState.SUBMITTING) {
            return EB_PROCESSING;
        }
        if (bankState == FinancingState.SUBMITED) {
            return BANK_PROCESSING;
        }
        if (bankState == FinancingState.FAIL) {
            return BANK_FAIL;
        }
        if (bankState == FinancingState.UNKNOWN) {
            return BANK_UNKNOWN;
        }
        if (bankState == FinancingState.SUCCESS) {
            return BANK_SUCCESS;
        }
        if (bankState == FinancingState.DETAIL_BIZ_NO_INVALIDATED) {
            return INVALIDATED;
        }
        return EB_PROCESSING;
    }
}

