/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.bank.meta.rule;

import java.io.UnsupportedEncodingException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankReqLenRule {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankReqLenRule.class);
    private int index;
    private int dataLen;
    private boolean padLeft;
    private char padding;
    private String charSetName;
    private boolean enable;

    public BankReqLenRule() {
        this.enable = true;
    }

    public BankReqLenRule(boolean enable) {
        this.enable = enable;
    }

    public String formatLen(String data) {
        if (!this.isEnable()) {
            return data;
        }
        if (StringUtils.isEmpty((String)data)) {
            this.logger.warn("\u5f85\u5904\u7406\u7684\u62a5\u6587\u6570\u636e\u4e3a\u7a7a\u3002");
            return "";
        }
        if (this.index > data.length()) {
            this.logger.warn("\u951a\u70b9\u4f4d\u7f6e\u914d\u7f6e\u6709\u8bef\uff1a\u8d85\u8fc7\u5f85\u5904\u7406\u62a5\u6587\u6570\u636e\u957f\u5ea6\u3002");
            return data;
        }
        if (this.dataLen == 0 || this.dataLen > data.length() || this.index + this.dataLen > data.length()) {
            this.logger.warn("\u951a\u70b9\u957f\u5ea6\u914d\u7f6e\u6709\u8bef\uff1a\u8d85\u8fc7\u5f85\u5904\u7406\u62a5\u6587\u6570\u636e\u957f\u5ea6\u3002");
            return data;
        }
        String content = data.substring(this.index + this.dataLen);
        int len = 0;
        try {
            len = content.getBytes(this.charSetName).length;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6", new Object[]{e});
            return data;
        }
        int size = Integer.toString(len).length();
        if (size > this.dataLen) {
            this.logger.warn("\u951a\u70b9\u6570\u636e\u957f\u5ea6{}\u8d85\u51fa\u9650\u503c{}\u3002", new Object[]{size, this.dataLen});
            return data;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(data, 0, this.index);
        if (!this.padLeft) {
            sb.append(len);
        }
        for (int i = 0; i < this.dataLen - size; ++i) {
            sb.append(this.padding);
        }
        if (this.padLeft) {
            sb.append(len);
        }
        sb.append(content);
        return sb.toString();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public void setDataLen(int dataLen) {
        this.dataLen = dataLen;
    }

    public boolean isPadLeft() {
        return this.padLeft;
    }

    public void setPadLeft(boolean padLeft) {
        this.padLeft = padLeft;
    }

    public char getPadding() {
        return this.padding;
    }

    public void setPadding(char padding) {
        this.padding = padding;
    }

    public String getCharSetName() {
        return this.charSetName;
    }

    public void setCharSetName(String charSetName) {
        this.charSetName = charSetName;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

