/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.bank.meta.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.aqap.common.framework.bank.meta.template.BaseMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.sdk.annotation.SdkDeprecated;

public abstract class FBEMetaDataTemplate
extends BaseMetaDataTemplate {
    public static final Map<String, Integer> sortMap = new HashMap<String, Integer>(8);
    public static final String URI_LOWER_CASE = "uri";

    @Override
    public BankVersionMetaInfo getBankVersionMetaInfo() {
        this.metaDataInit();
        String dLockNum = this.bankShortName + "_concurrentCount";
        int concurrentCount = 0;
        try {
            String dLockNumString = ConfigurationUtil.getString((String)dLockNum);
            if (!StringUtils.isEmpty((String)dLockNumString)) {
                concurrentCount = Integer.parseInt(dLockNumString);
            }
        }
        catch (Exception e) {
            concurrentCount = 1;
        }
        return BankVersionMetaInfo.builder().bankShortName(this.bankShortName).bankName(this.bankName).bankVersionID(this.bankVersionID).bankVersionName(this.bankVersionName).description(this.description).keyNames(this.keyNames).concurrentCount(concurrentCount).build();
    }

    @Override
    public List<BankVersionMetaInfo> getBankVersionExtMetaInfos() {
        this.metaDataInit();
        String fileName = this.bankVersionID + "_BankInfoExt.json";
        return this.initBankVersionMetaExtInfo(fileName);
    }

    @Override
    public List<BankLoginConfig> getBankLoginConfig() {
        this.baseConfigInit();
        ArrayList<BankLoginConfig> bankLoginConfig = new ArrayList<BankLoginConfig>(1);
        List<BankLoginConfig> configs = this.getBankFrontConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getConcurrencyConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBasicConfigSupplement();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BASE_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        bankLoginConfig.sort(Comparator.comparingInt(a -> sortMap.get(sortMap.containsKey(a.getKey().getBankConfigId()) ? a.getKey().getBankConfigId() : null)));
        configs = this.getBankLoginBanksConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.BANKS_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getPgpConfigSupplement();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PGP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getFrontProxyConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.PROXY_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getBankLoginExtraConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.EXTRA_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        configs = this.getAttachmentSFTPConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.ATTACHMENT_SFTP_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        if (this.isSupportExclusiveBankLogin()) {
            configs = this.getBankLoginExclusiveConfig();
            for (BankLoginConfig config : configs) {
                config.setType(MetaDataConfigType.EXCLUSIVE_CONFIG.getName());
            }
            bankLoginConfig.addAll(configs);
        }
        if (this.showAchieveWay()) {
            configs = this.getBankLoginReceiptAchieveWayConfig();
            for (BankLoginConfig config : configs) {
                config.setType(MetaDataConfigType.RECEIPT_ACHIEVEWAY_CONFIG.getName());
            }
            bankLoginConfig.addAll(configs);
        }
        configs = this.getBankLoginReceiptBaseConfig();
        for (BankLoginConfig config : configs) {
            config.setType(MetaDataConfigType.RECEIPT_CONFIG.getName());
        }
        bankLoginConfig.addAll(configs);
        return bankLoginConfig;
    }

    public List<BankLoginConfig> getAttachmentSFTPConfig() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankService>> getBizImplClasses() {
        return null;
    }

    @SdkDeprecated
    public List<BankLoginConfig> getBankFrontConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"ip", (MultiLangEnumBridge)this.getMlIpName(), (MultiLangEnumBridge)this.getMlIpDesc(), (String)this.host, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangePort", (MultiLangEnumBridge)this.getMlPortName(), (MultiLangEnumBridge)this.getMlPortDesc(), (String)this.port, (boolean)false, (boolean)false).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"exchangeProtocol", (MultiLangEnumBridge)this.getMlExProtocolName(), (String)this.protocol.toUpperCase(), (boolean)this.isProtocolReadonly, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"timeout", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d85\u65f6\u8bbe\u7f6e(\u5355\u4f4d\uff1a\u5206\u949f)", "FBEMetaDataTemplate_0", "ebg-aqap-common"), (String)String.valueOf(this.timeout), (boolean)false, (boolean)false).set2Integer(), BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "FBEMetaDataTemplate_1", "ebg-aqap-common"), (String)this.charset.toUpperCase(), (boolean)true, (boolean)false)});
    }

    @SdkDeprecated
    public List<BankLoginConfig> getFrontProxyConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBasicConfigSupplement() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getPgpConfigSupplement() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptAchieveWayConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"receipt_achieve_way", (MultiLangEnumBridge)new MultiLangEnumBridge("\u56de\u5355\u83b7\u53d6\u65b9\u5f0f", "FBEMetaDataTemplate_4", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("1.\u901a\u8fc7\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\uff0c\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u987b\u90e8\u7f72\u5728\u94f6\u884c\u63a8\u9001\u6587\u4ef6\u6240\u5728\u7684\u670d\u52a1\u5668\u4e0a\uff1b 2.\u5982\u679c\u94f6\u884c\u63d0\u4f9b\u516c\u7f51sftp\u670d\u52a1\uff0c\u53ef\u4ee5\u901a\u8fc7\u8fdc\u7a0bsftp\u83b7\u53d6", "FBEMetaDataTemplate_5", "ebg-aqap-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("bank_login", "", null), new MultiLangEnumBridge("sftp", "", null)}), (String)"bank_login", (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"bank_ftp_ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u670d\u52a1\u5668IP\u5730\u5740", "FBEMetaDataTemplate_6", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u670d\u52a1\u5668IP\u5730\u5740\u3002\u5982\u6d4b\u8bd5\u8fde\u63a5\u5931\u8d25\uff0c\u5728\u56de\u5355\u7a0b\u5e8f\u670d\u52a1\u5668\u4e0a\u5b89\u88c5winscp\uff0c\u518d\u6d4b\u8bd5\u8fde\u63a5\uff0c\u5177\u4f53\u53c2\u8003\u6587\u6863\u3002", "FBEMetaDataTemplate_7", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"bank_ftp_port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u7aef\u53e3\u53f7", "FBEMetaDataTemplate_8", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_path", (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884cSFTP\u6587\u4ef6\u4fdd\u5b58\u5b50\u8def\u5f84", "FBEMetaDataTemplate_9", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e00\u822c\u94f6\u884c\u4f7f\u7528SFTP\u4f20\u8f93\u6587\u4ef6\u65f6\u9ed8\u8ba4\u4e3a\u7a7a\u5373\u53ef\uff0c\u5982\u679c\u586b\u5165\u5219\u4f7f\u7528\u5206\u9694\u7b26\uff0c\u4f8b\u5982\uff1a/download\u3002", "FBEMetaDataTemplate_10", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_user_name", (MultiLangEnumBridge)new MultiLangEnumBridge("\u767b\u5f55SFTP\u670d\u52a1\u5668\u4f7f\u7528\u7684\u7528\u6237\u540d\u3002", "FBEMetaDataTemplate_11", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_password", (MultiLangEnumBridge)new MultiLangEnumBridge("\u767b\u5f55SFTP\u670d\u52a1\u5668\u4f7f\u7528\u7684\u5bc6\u7801\u3002", "FBEMetaDataTemplate_12", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"ftp_cert_path", (MultiLangEnumBridge)new MultiLangEnumBridge("SFTP\u672c\u673a\u8bc1\u4e66\u6587\u4ef6\u8def\u5f84\u3002", "FBEMetaDataTemplate_13", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8fIP", "FBEMetaDataTemplate_14", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8fIP", "FBEMetaDataTemplate_14", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u7aef\u53e3\u53f7", "FBEMetaDataTemplate_15", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u524d\u7f6e\u673a\u4ee3\u7406\u7a0b\u5e8f\u7aef\u53e3\u53f7", "FBEMetaDataTemplate_15", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true).set2Integer().set2MaxValueNum(65535), BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_path", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84", "FBEMetaDataTemplate_16", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u628a\u56de\u5355\u6587\u4ef6\u63a8\u9001\u5230\u7684\u76ee\u5f55\u3002", "FBEMetaDataTemplate_17", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true)});
    }

    public List<BankLoginConfig> getBankLoginExtraConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginReceiptBaseConfig() {
        return Lists.newArrayList();
    }

    public List<BankLoginConfig> getBankLoginExclusiveConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"exclusive", (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bbe\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a", "FBEMetaDataTemplate_25", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u540c\u4e00\u94f6\u884c\u8d26\u53f7\u5b58\u5728\u591a\u524d\u7f6e\u673a\u524d\u63d0\u4e0b\u53ef\u914d\u7f6e\uff0c\u5426\u5219\u65e0\u9700\u914d\u7f6e\u3002\u542f\u7528\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\u5219\u4e0d\u80fd\u76f4\u63a5\u5173\u8054\u94f6\u884c\u8d26\u53f7\uff0c\u94f6\u884c\u8d26\u53f7\u9700\u8981\u901a\u8fc7\u4e3b\u524d\u7f6e\u673a\u914d\u7f6e\u5373\u53ef\u3002", "FBEMetaDataTemplate_26", "ebg-aqap-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u5426", "FBEMetaDataTemplate_27", "ebg-aqap-common"), new MultiLangEnumBridge("\u662f", "FBEMetaDataTemplate_28", "ebg-aqap-common")}), (List)Lists.newArrayList((Object[])new String[]{"false", "true"}), (String)"false", (boolean)false, (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"business_type", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4e13\u5c5e\u524d\u7f6e\u673a\u4e1a\u52a1\u7c7b\u578b", "FBEMetaDataTemplate_29", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bbe\u7f6e\u4e13\u5c5e\u524d\u7f6e\u673a\u4e1a\u52a1\u7c7b\u578b\uff0c\u5219\u5f53\u524d\u4e13\u5c5e\u524d\u7f6e\u673a\u53ea\u80fd\u5904\u7406\u4e13\u5c5e\u524d\u7f6e\u673a\u4e1a\u52a1\u7c7b\u578b\u7684\u4e1a\u52a1\uff0c\u6bd4\u5982\u4ec5\u652f\u4ed8\u4e13\u5c5e\u4e1a\u52a1\u53ea\u80fd\u901a\u8fc7\u8be5\u524d\u7f6e\u673a\u5904\u7406\u652f\u4ed8\u7c7b\u4ea4\u6613\u4ee5\u53ca\u67e5\u8be2\u652f\u4ed8\u4ea4\u6613\u7ed3\u679c\u3002", "FBEMetaDataTemplate_20", "ebg-aqap-common"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ec5\u652f\u4ed8", "FBEMetaDataTemplate_30", "ebg-aqap-common"), new MultiLangEnumBridge("\u4ec5\u67e5\u8be2\u4f59\u989d", "FBEMetaDataTemplate_31", "ebg-aqap-common"), new MultiLangEnumBridge("\u4ec5\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", "FBEMetaDataTemplate_32", "ebg-aqap-common"), new MultiLangEnumBridge("\u4ec5\u7535\u7968", "FBEMetaDataTemplate_33", "ebg-aqap-common"), new MultiLangEnumBridge("\u4ec5\u4fe1\u7528\u8bc1", "FBEMetaDataTemplate_34", "ebg-aqap-common")}), (String)"", (boolean)false, (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"master_number", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6240\u5c5e\u4e3b\u524d\u7f6e\u673a\u7f16\u53f7", "FBEMetaDataTemplate_21", "ebg-aqap-common"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5fc5\u987b\u5b58\u5728\u4e3b\u524d\u7f6e\u673a\u524d\u63d0\u4e0b\u65b9\u53ef\u542f\u7528\u4e3a\u4e13\u5c5e\u524d\u7f6e\u673a\uff0c\u4e3b\u524d\u7f6e\u673a\u4e3a\u5f53\u524d\u94f6\u884c\u7248\u672c\u4e0b\u975e\u4e13\u5c5e\u524d\u7f6e\u673a\u3002", "FBEMetaDataTemplate_22", "ebg-aqap-common"), (String)"", (boolean)false, (boolean)true, (boolean)false).set2InputType(ConfigInputType.MUL_SELECT.getInputType())});
    }

    public boolean isSupportExclusiveBankLogin() {
        return false;
    }

    @SdkDeprecated
    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    @Override
    public BankPropertyConfig getPropertyConfig() {
        return null;
    }

    @Override
    public boolean showInJdy() {
        return false;
    }

    static {
        sortMap.put("ip", 1);
        sortMap.put("exchangePort", 2);
        sortMap.put("signPort", 3);
        sortMap.put("exchangeUri", 4);
        sortMap.put(URI_LOWER_CASE, 5);
        sortMap.put("exchangeProtocol", 6);
        sortMap.put("signProtocol", 7);
        sortMap.put("timeout", 8);
        sortMap.put("charset", 9);
        sortMap.put("leaseNum", 10);
        sortMap.put("receipt_leaseNum", 11);
        sortMap.put("note_leaseNum", 12);
        sortMap.put(null, 999);
    }
}

