/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.frame;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.PostConstruct;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.ConfigurationUpdateObserver;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.common.constant.SortNum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.aqap.common.framework.frame.AtomicBizMeta;
import kd.ebg.aqap.common.framework.frame.AtomicBizMetaCollector;
import kd.ebg.aqap.common.framework.frame.AtomicMetaType;
import kd.ebg.aqap.common.framework.frame.Bank;
import kd.ebg.aqap.common.framework.frame.BankVersion;
import kd.ebg.aqap.common.framework.handler.AbstractBizHandler;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.aqap.common.framework.route.RouteMatchType;
import kd.ebg.aqap.common.framework.route.RouteMeta;
import kd.ebg.aqap.common.framework.services.BankInterfaceRouteService;
import kd.ebg.aqap.common.model.BankInterfaceRoute;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.annotation.Value;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.api.IBankServiceDesc;
import kd.ebg.egf.common.license.old.Coder;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankConfig;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.utils.CheckUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.apache.commons.codec.binary.Base64OutputStream;

@Component
public class BankBundleManager {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankBundleManager.class);
    public static final List<String> ALLOW_NULL_IMPL_LIST = Lists.newArrayList((Object[])new String[]{"IPretreat", "ITodayBatchBalance", "IHisBatchBalance", "ICodelessCommon", "ICreditReceivedPretreat"});
    @Value(value="${ebservice.bank.concurrentCount}")
    private String conCountJson;
    private List<BankMetaDataCollector> bankMetaDataCollectorList;
    private List<AtomicBizMetaCollector> atomicBizMetaCollectorList;
    private Map<String, List<BankLoginConfig>> bankVersionMapConfig;
    private Map<String, List<BankConfig>> bankPwdCertMapConfig;
    private Map<String, BankMetaDataCollector> bankMetaDataCollectorMap;
    private List<AtomicBizMeta> bizMetas;
    private List<AtomicBizMeta> sysMetas;
    private List<Class<? extends IBankServiceDesc>> bizInterfaceList;
    private Map<String, BankVersion> bankVersionMap;
    private Map<String, List<String>> bankKeyWordsMap;
    private Map<String, Bank> bankMap;
    private Map<Class<? extends IBankService>, IBankService> bizImplClass2Impl;
    private final GlobalPropertyConfig globalPropertyConfig;
    private final BankInterfaceRouteService routeService;
    private Map<String, Map<String, Map<String, String>>> receiptMatchRuleMap;

    public List<String> getKeyWords(String bankVersion) {
        if (this.bankKeyWordsMap == null) {
            this.bankKeyWordsMap = new HashMap<String, List<String>>(16);
        }
        return this.bankKeyWordsMap.get(bankVersion);
    }

    public void setKeyWords(String bankVersion, List<String> list) {
        if (this.bankKeyWordsMap == null) {
            this.bankKeyWordsMap = new HashMap<String, List<String>>(16);
        }
        this.bankKeyWordsMap.put(bankVersion, list);
    }

    public BankVersion getBankVersionInfo(String bankVersionID) {
        return this.bankVersionMap.get(bankVersionID);
    }

    public BankBundleManager(GlobalPropertyConfig globalPropertyConfig, BankInterfaceRouteService routeService, List<BankMetaDataCollector> bankMetaDataCollectorList, List<AtomicBizMetaCollector> atomicBizMetaCollectorList) {
        this.globalPropertyConfig = globalPropertyConfig;
        this.routeService = routeService;
        this.bankMetaDataCollectorList = bankMetaDataCollectorList;
        this.atomicBizMetaCollectorList = atomicBizMetaCollectorList;
        this.bankMetaDataCollectorMap = new HashMap<String, BankMetaDataCollector>(16);
    }

    private void initEBContext(String bankVersionID) {
        EBContext ebContext = EBContext.getContext();
        if (ebContext == null) {
            ebContext = EBContext.builder().build();
            EBContext.setContext((EBContext)ebContext);
        }
        ebContext.setBankVersionID(bankVersionID);
    }

    @PostConstruct
    public void init() {
        logger.info("\u52a0\u8f7d\u94f6\u884c\u524d\u7f6e\u673a\u5e76\u53d1\u9501\u6570\u91cf...");
        if (!StringUtils.isEmpty((String)this.conCountJson)) {
            JSONObject jasonObject;
            JSONObject bankConCountMap = jasonObject = JSONObject.parseObject((String)this.conCountJson);
            String dLockNum = "";
            for (Map.Entry entry : bankConCountMap.entrySet()) {
                logger.info((String)entry.getKey() + "\u524d\u7f6e\u673a\u5e76\u53d1\u9501\u6570\u91cf\uff1a" + entry.getValue());
                dLockNum = (String)entry.getKey() + "_concurrentCount";
                ConfigurationUpdateObserver.registerInterest((String)dLockNum, (Object)String.valueOf(entry.getValue()));
                ConfigurationUpdateObserver.notify((String)dLockNum);
            }
        }
        EBContext ebContext = EBContext.builder().build();
        EBContext.setContext((EBContext)ebContext);
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u4e1a\u52a1\u7cfb\u7edf...");
        this.bizMetas = Lists.newArrayList();
        this.sysMetas = Lists.newArrayList();
        this.bizInterfaceList = Lists.newArrayList();
        this.bankVersionMap = Maps.newHashMap();
        this.bankMap = Maps.newHashMap();
        this.bizImplClass2Impl = Maps.newConcurrentMap();
        this.bankVersionMapConfig = Maps.newHashMap();
        this.bankPwdCertMapConfig = Maps.newHashMap();
        this.receiptMatchRuleMap = Maps.newHashMapWithExpectedSize((int)8);
        Preconditions.checkNotNull(this.atomicBizMetaCollectorList, (Object)ResManager.loadKDString((String)"\u652f\u6301\u7684\u4e1a\u52a1\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        this.atomicBizMetaCollectorList.forEach(this::dealAtomicBizMetaCollector);
        if (Objects.nonNull(this.bankMetaDataCollectorList)) {
            ListIterator<BankMetaDataCollector> infoIterator = this.bankMetaDataCollectorList.listIterator();
            while (infoIterator.hasNext()) {
                BankMetaDataCollector bankMetaDataCollector = (BankMetaDataCollector)infoIterator.next();
                boolean result = bankMetaDataCollector.isPublished();
                if (result) {
                    try {
                        BankPropertyConfig propertyConfig;
                        Preconditions.checkNotNull((Object)bankMetaDataCollector, (Object)ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\u5143\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
                        BankVersionMetaInfo bankVersionMetaInfo = bankMetaDataCollector.getBankVersionMetaInfo();
                        Preconditions.checkNotNull((Object)bankVersionMetaInfo, (Object)ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6\u5b9e\u73b0 \u94f6\u884c\u7248\u672c\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
                        String bankShortName = bankVersionMetaInfo.getBankShortName();
                        String bankVersionID = bankVersionMetaInfo.getBankVersionID();
                        String bankName = bankVersionMetaInfo.getBankName();
                        List<String> keyNames = bankVersionMetaInfo.getKeyNames();
                        ebContext.setBankVersionID(bankVersionID);
                        Preconditions.checkState((boolean)StrUtil.isNotBlank((CharSequence)bankShortName), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7b80\u7801 bankShortName \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_3", (String)"ebg-aqap-common", (Object[])new Object[0]));
                        Preconditions.checkState((boolean)StrUtil.isNotBlank((CharSequence)bankVersionID), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6:%s\u94f6\u884c\u7248\u672c\u7b80\u7801 bankVersionID \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_21", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
                        Preconditions.checkState((boolean)CheckUtil.checkNumberWord((String)bankVersionID), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\u7b80\u7801 bankVersionID \u5fc5\u987b\u4e3a\u5b57\u6bcd\u6216\u8005\u6570\u5b57\u3002", (String)"BankBundleManager_6", (String)"ebg-aqap-common", (Object[])new Object[0]));
                        Preconditions.checkState((boolean)CheckUtil.checkNumberWord((String)bankShortName), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6:%s\u94f6\u884c\u7b80\u7801 bankShortName \u5fc5\u987b\u4e3a\u5b57\u6bcd\u6216\u8005\u6570\u5b57\u3002", (String)"BankBundleManager_22", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
                        Preconditions.checkNotNull(keyNames, (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6:%s\u94f6\u884c\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_23", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
                        Preconditions.checkState((boolean)StrUtil.isNotBlank((CharSequence)bankName), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6:%s\u94f6\u884c\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_24", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
                        List<Class<? extends IBankService>> bizImplClasses = bankMetaDataCollector.getBizImplClasses();
                        Preconditions.checkNotNull(bizImplClasses, (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6:%s\u4e1a\u52a1\u5b9e\u73b0\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_25", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
                        Preconditions.checkState((!bizImplClasses.isEmpty() ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u63d2\u4ef6:%s\u4e1a\u52a1\u5b9e\u73b0\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_26", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
                        List<BankLoginConfig> bankLoginConfigs = bankMetaDataCollector.getBankLoginConfig();
                        if (Objects.isNull(bankLoginConfigs) || bankLoginConfigs.isEmpty()) {
                            logger.info("\u94f6\u884c\u63d2\u4ef6 : {} \u6ca1\u6709\u5b9a\u4e49\u8fde\u63a5\u94f6\u884c\u9700\u8981\u7684\u53c2\u6570", (Object)bankVersionID);
                        }
                        if (Objects.isNull(propertyConfig = bankMetaDataCollector.getPropertyConfig())) {
                            logger.info("\u94f6\u884c\u63d2\u4ef6 : {} \u8fd4\u56de\u7684\u63d2\u4ef6\u914d\u7f6e\u4e3a null", (Object)bankVersionID);
                        }
                        this.dealBankMetaDataCollector(bankMetaDataCollector);
                    }
                    catch (Throwable t) {
                        logger.error("\u94f6\u884c\u63d2\u4ef6" + bankMetaDataCollector.getClass().getName() + "\u52a0\u8f7d\u5931\u8d25", t);
                        infoIterator.remove();
                    }
                    continue;
                }
                infoIterator.remove();
            }
        }
        logger.info("\u4e1a\u52a1\u63a5\u53e3\u4e2a\u6570 : {}", (Object)this.bizMetas.size());
        this.bizMetas.forEach(meta -> logger.info(meta.getBizInterface().getName()));
        logger.info("\u7cfb\u7edf\u63a5\u53e3\u4e2a\u6570 : {}", (Object)this.sysMetas.size());
        this.sysMetas.forEach(meta -> logger.info(meta.toString()));
        logger.info("\u627e\u5230 {} \u4e2a\u94f6\u884c\u63d2\u4ef6\u5b9e\u73b0", (Object)(Objects.nonNull(this.bankMetaDataCollectorList) ? this.bankMetaDataCollectorList.size() : 0));
        this.bankVersionMap.keySet().forEach(arg_0 -> ((EBGLogger)logger).info(arg_0));
        logger.info("\u521d\u59cb\u5316\u5b8c\u6210...");
    }

    private void dealAtomicBizMetaCollector(AtomicBizMetaCollector atomicBizMetaCollector) {
        List<AtomicBizMeta> atomicBizMetas = atomicBizMetaCollector.getAtomicBizMeta();
        if (Objects.nonNull(atomicBizMetas)) {
            atomicBizMetas.forEach(meta -> {
                Preconditions.checkNotNull((Object)meta, (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u5143\u4fe1\u606f\u5bf9\u8c61 AtomicBizMeta \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_11", (String)"ebg-aqap-common", (Object[])new Object[0]));
                Preconditions.checkNotNull(meta.getBizInterface(), (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u5143\u4fe1\u606f\u4e2d\u201c\u4e1a\u52a1\u63a5\u53e3\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankBundleManager_12", (String)"ebg-aqap-common", (Object[])new Object[0]));
                this.bizInterfaceList.add(meta.getBizInterface());
            });
            if (AtomicMetaType.BIZ == atomicBizMetaCollector.type()) {
                this.bizMetas.addAll(atomicBizMetas);
            } else {
                this.sysMetas.addAll(atomicBizMetas);
            }
        }
    }

    private void dealBankMetaDataCollector(BankMetaDataCollector bankMetaDataCollector) {
        BankVersionMetaInfo bankVersionMetaInfo = bankMetaDataCollector.getBankVersionMetaInfo();
        this.dealBankMetaDataCollector(bankMetaDataCollector, bankVersionMetaInfo);
        List<BankVersionMetaInfo> bankVersionMetaInfos = bankMetaDataCollector.getBankVersionExtMetaInfos();
        if (bankVersionMetaInfos != null && bankVersionMetaInfos.size() > 0) {
            for (BankVersionMetaInfo info : bankVersionMetaInfos) {
                this.dealBankMetaDataCollector(bankMetaDataCollector, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealBankMetaDataCollector(BankMetaDataCollector bankMetaDataCollector, BankVersionMetaInfo bankVersionMetaInfo) {
        String bankShortName = bankVersionMetaInfo.getBankShortName();
        String bankVersionID = bankVersionMetaInfo.getBankVersionID();
        List<String> keyNames = bankVersionMetaInfo.getKeyNames();
        List<Class<? extends IBankService>> bizImplClasses = bankMetaDataCollector.getBizImplClasses();
        List<Class<? extends IBankBatchSeqIDCreator>> batchSeqIDClasses = bankMetaDataCollector.getBatchSeqIDClasses();
        List<Class<? extends IBankDetailSeqIDCreator>> detailSeqIDClasses = bankMetaDataCollector.getDetailSeqIDClasses();
        List<Class<? extends AbstractBizHandler>> overseaHandlerClasses = bankMetaDataCollector.getOverseaHandlerClasses();
        EBContext context = new EBContext();
        try {
            context.setBankVersionID(bankVersionID);
            EBContext.setContext((EBContext)context);
            this.receiptMatchRuleMap.put(bankVersionID, bankMetaDataCollector.getDetailNoRule());
            List<BankLoginConfig> bankLoginConfigs = bankMetaDataCollector.getBankLoginConfig();
            List<BankConfig> bankConfigs = bankMetaDataCollector.getBankConfig();
            BankPropertyConfig propertyConfig = bankMetaDataCollector.getPropertyConfig();
            propertyConfig.setBankVersionID(bankVersionID);
            ArrayList<BankLoginConfig> tempBankLoginConfigs = new ArrayList<BankLoginConfig>(16);
            if (this.bankVersionMapConfig.containsKey(bankVersionID)) {
                tempBankLoginConfigs.addAll((Collection)this.bankVersionMapConfig.get(bankVersionID));
                for (BankLoginConfig config : bankLoginConfigs) {
                    boolean isRepeat = false;
                    for (BankLoginConfig bankLoginConfig : tempBankLoginConfigs) {
                        if (!bankLoginConfig.getKey().getBankConfigId().equalsIgnoreCase(config.getKey().getBankConfigId())) continue;
                        isRepeat = true;
                        break;
                    }
                    if (isRepeat) continue;
                    tempBankLoginConfigs.add(config);
                }
            } else {
                tempBankLoginConfigs.addAll(bankLoginConfigs);
            }
            BankVersion bankVersion = new BankVersion();
            if (this.bankVersionMap.containsKey(bankVersionID)) {
                bankVersion = this.bankVersionMap.get(bankVersionID);
            }
            bankVersion.setBankLoginConfigs(tempBankLoginConfigs);
            bankVersion.setBankConfigs(bankConfigs);
            bankVersion.setBankVersionID(bankVersionID);
            bankVersion.setBankName(bankVersionMetaInfo.getBankName());
            bankVersion.setBankVersionMetaInfo(bankVersionMetaInfo);
            bankVersion.setConcurrentCount(bankVersionMetaInfo.getConcurrentCount());
            bankVersion.setBizImplClasses(bizImplClasses);
            bankVersion.setBatchSeqIDClasses(batchSeqIDClasses);
            bankVersion.setDetailSeqIDClasses(detailSeqIDClasses);
            bankVersion.setPropertyConfig(propertyConfig);
            bankVersion.setBankVersionName(bankVersionMetaInfo.getBankVersionName());
            bankVersion.setAvailable(true);
            bankVersion.setShowInJdy(bankMetaDataCollector.showInJdy());
            bankVersion.setBankPropertyFunItems(bankMetaDataCollector.getBankPropertyFunItems());
            bankVersion.setDetailSupportMultiCurrency(bankMetaDataCollector.isDetailSupportMultiCurrency());
            bankVersion.setOverseaHandlerClasses(overseaHandlerClasses);
            bankVersion.setNeedDeleteSftpFile(bankMetaDataCollector.isNeedDeleteSftpFile());
            Integer sortNum = SortNum.sortNumMap.get(bankVersionMetaInfo.getBankShortName());
            bankVersion.setSortNum(sortNum != null ? sortNum : 9999);
            bankVersion.setDetailUniqueVersion(BankBundleManager.buildDetailUniqueVersion(bankMetaDataCollector.getDetailUniqueRule()));
            Map<Object, Object> implMap = bankVersion.getImplMap() != null ? bankVersion.getImplMap() : Maps.newHashMap();
            this.bizInterfaceList.forEach(bizInterface -> bizImplClasses.forEach(implClass -> {
                if (bizInterface.isAssignableFrom((Class<?>)implClass)) {
                    if (implMap.containsKey(bizInterface)) {
                        List implList = (List)implMap.get(bizInterface);
                        implList.add(implClass);
                    } else {
                        ArrayList implList = Lists.newArrayList();
                        implList.add(implClass);
                        implMap.put(bizInterface, implList);
                    }
                }
            }));
            boolean isInstanceError = false;
            block9: for (List list : implMap.values()) {
                if (isInstanceError) break;
                for (Class implClass : list) {
                    if (isInstanceError) continue block9;
                    if (this.bizImplClass2Impl.containsKey(implClass)) continue;
                    try {
                        IBankService impl = (IBankService)implClass.newInstance();
                        this.bizImplClass2Impl.putIfAbsent(implClass, impl);
                    }
                    catch (Throwable e) {
                        isInstanceError = true;
                        logger.error("\u4e1a\u52a1\u5b9e\u73b0\u7c7b{}\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25\r\n {}", new Object[]{implClass.getName(), e.toString()});
                    }
                }
            }
            if (!isInstanceError) {
                if (Objects.nonNull(propertyConfig)) {
                    this.globalPropertyConfig.registryPropertyConfig(propertyConfig);
                }
                this.bankVersionMapConfig.put(bankVersionID, tempBankLoginConfigs);
                this.bankPwdCertMapConfig.put(bankVersionID, bankConfigs);
                bankVersion.setImplMap(implMap);
                this.bankVersionMap.put(bankVersionID, bankVersion);
                if (this.bankMap.containsKey(bankShortName)) {
                    Bank bank = this.bankMap.get(bankShortName);
                    bank.addBankNameKeyWord(keyNames);
                    bank.addBankVersion(bankVersion);
                } else {
                    Bank bank = new Bank();
                    bank.setBankName(bankVersionMetaInfo.getBankName());
                    bank.setBankShortName(bankShortName);
                    bank.setBankDescription(bankVersionMetaInfo.getDescription());
                    bank.setBankNameKeyWords(keyNames);
                    bank.addBankVersion(bankVersion);
                    this.bankMap.put(bankShortName, bank);
                }
            }
        }
        catch (Throwable e) {
            logger.error("dealBankMetaDataCollector", e);
        }
        finally {
            EBContext.destroy();
        }
    }

    public static String buildDetailUniqueVersion(Map<String, String> map) {
        if (map.isEmpty()) {
            return "";
        }
        return BankBundleManager.serialize(map);
    }

    public static String serialize(Object object) {
        ByteArrayOutputStream byteaOut = new ByteArrayOutputStream();
        DeflaterOutputStream gzipOut = null;
        try {
            gzipOut = new GZIPOutputStream((OutputStream)new Base64OutputStream((OutputStream)byteaOut));
            gzipOut.write(new Gson().toJson(object).getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u4e3b\u952e\u7248\u672c\u53f7\u751f\u6210\u5931\u8d25\u3002", (String)"BankBundleManager_13", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)ex);
        }
        finally {
            if (gzipOut != null) {
                try {
                    gzipOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            return Coder.bufferToHex((byte[])Coder.encryptMD5((byte[])byteaOut.toByteArray()));
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u4e3b\u952e\u7248\u672c\u53f7\u751f\u6210\u5931\u8d25\u3002", (String)"BankBundleManager_14", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)ex);
        }
    }

    public static BankBundleManager getInstance() {
        return SpringContextUtil.getBean(BankBundleManager.class);
    }

    public String getBankShortName(String bankVersionId) {
        for (Map.Entry<String, Bank> entry : this.bankMap.entrySet()) {
            Bank bank = entry.getValue();
            for (BankVersion version : bank.getBankVersions()) {
                if (!version.getBankVersionID().equalsIgnoreCase(bankVersionId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public <T extends IBankService> T getImpl(String bankVersionID, Class<T> bizInterface, Object request) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankService>> implClassList = bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                if (!ALLOW_NULL_IMPL_LIST.contains(bizInterface.getSimpleName())) {
                    throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"bankVersionID:%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_27", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bizInterface.getSimpleName()));
                }
                return null;
            }
            return (T)this.getImpl(bizInterface, implClassList, request);
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_28", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
    }

    public List<Class<? extends IBankService>> getImpl(String bankVersionID, Class<?> bizInterface) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankService>> implClassList = bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                if (!ALLOW_NULL_IMPL_LIST.contains(bizInterface.getSimpleName())) {
                    throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"bankVersionID:%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_27", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bizInterface.getSimpleName()));
                }
                return null;
            }
            return implClassList;
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_28", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
    }

    public <T extends BankMetaDataCollector> T getBankMetaDataCollectorImpl(String bankVersionID) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            this.initEBContext(bankVersionID);
            BankMetaDataCollector impl = null;
            ArrayList<BankVersionMetaInfo> bankVersionExtMetaInfos = new ArrayList<BankVersionMetaInfo>(16);
            for (BankMetaDataCollector metaDataCollector : this.bankMetaDataCollectorList) {
                bankVersionExtMetaInfos.clear();
                if (metaDataCollector.getBankVersionMetaInfo() != null) {
                    bankVersionExtMetaInfos.add(metaDataCollector.getBankVersionMetaInfo());
                }
                if (metaDataCollector.getBankVersionExtMetaInfos() != null) {
                    bankVersionExtMetaInfos.addAll(metaDataCollector.getBankVersionExtMetaInfos());
                }
                for (BankVersionMetaInfo bankVersionMetaInfo : bankVersionExtMetaInfos) {
                    if (!bankVersionID.equalsIgnoreCase(bankVersionMetaInfo.getBankVersionID())) continue;
                    impl = metaDataCollector;
                    return (T)impl;
                }
            }
        }
        return null;
    }

    public BankMetaDataCollector getBankMetaDataCollector(String bankVersionID) {
        if (this.bankMetaDataCollectorMap.containsKey(bankVersionID)) {
            return this.bankMetaDataCollectorMap.get(bankVersionID);
        }
        Object impl = this.getBankMetaDataCollectorImpl(bankVersionID);
        this.bankMetaDataCollectorMap.put(bankVersionID, (BankMetaDataCollector)impl);
        return impl;
    }

    public boolean isForeignBank(String bankVersionID) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            PropertyConfig impl = bankVersion.getPropertyConfig();
            return impl.isForeignBank();
        }
        return false;
    }

    public <T extends IBankService> T getSyncAccountImpl(String bankVersionID, Class<T> bizInterface) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankService>> implClassList = bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            return (T)this.getImpl(bizInterface, implClassList, null);
        }
        return null;
    }

    public <T extends IBankService> T getImplByClassName(String bankVersionID, Class<T> bizInterface, String implClassName) {
        if (implClassName == null) {
            throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"bankVersionID\uff1a%s\u7684\u63a5\u53e3\u5b9e\u73b0\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u901a\u8fc7\u65e5\u5fd7\u68c0\u67e5\u3002", (String)"BankBundleManager_29", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
        }
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankService>> implClassList = bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"bankVersionID:%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_27", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bizInterface.getSimpleName()));
            }
            Class implClass = null;
            implClass = implClassList.stream().filter(impl -> impl.getName().equalsIgnoreCase(implClassName)).findFirst().orElseThrow(() -> EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"bankVersionID:%1$s \u94f6\u884c\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u63a5\u53e3%2$s\u3002", (String)"BankBundleManager_27", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID, bizInterface.getSimpleName())));
            return (T)this.getImpl(implClass);
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_28", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
    }

    public <T extends IBankServiceDesc> T getImplOrNull(String bankVersionID, Class<T> bizInterface) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankService>> implClassList = bankVersion.getImplMap().get(bizInterface);
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            return (T)this.getImpl(implClassList.get(0));
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_28", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
    }

    public <T extends IBankServiceDesc> T getBatchSeqIdImplOrNull(String bankVersionID) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankBatchSeqIDCreator>> implClassList = bankVersion.getBatchSeqIDClasses();
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            IBankBatchSeqIDCreator impl = null;
            try {
                impl = implClassList.get(0).newInstance();
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", (Throwable)e);
            }
            return (T)impl;
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_28", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
    }

    public <T extends IBankServiceDesc> T getDetailSeqIdImplOrNull(String bankVersionID) {
        if (this.bankVersionMap.containsKey(bankVersionID)) {
            this.initEBContext(bankVersionID);
            BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
            List<Class<? extends IBankDetailSeqIDCreator>> implClassList = bankVersion.getDetailSeqIDClasses();
            if (Objects.isNull(implClassList) || implClassList.isEmpty()) {
                return null;
            }
            IBankDetailSeqIDCreator impl = null;
            try {
                impl = implClassList.get(0).newInstance();
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", (Throwable)e);
            }
            return (T)impl;
        }
        throw EBExceiptionUtil.preCheckException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684 bankVersionID\uff1a%s\u3002", (String)"BankBundleManager_28", (String)"ebg-aqap-common", (Object[])new Object[0]), bankVersionID));
    }

    public List<BankLoginConfig> getBankLoginConfig(String bankVersionID) {
        return this.bankVersionMapConfig.get(bankVersionID);
    }

    public List<BankConfig> getBankConfig(String bankVersionID) {
        return this.bankPwdCertMapConfig.get(bankVersionID);
    }

    public IBankService getImpl(Class<? extends IBankService> implClass) {
        if (this.bizImplClass2Impl.containsKey(implClass)) {
            return this.bizImplClass2Impl.get(implClass);
        }
        IBankService impl = null;
        try {
            impl = implClass.newInstance();
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5b9e\u4f8b\u5316\u5931\u8d25", (Throwable)e);
        }
        this.bizImplClass2Impl.putIfAbsent(implClass, impl);
        return impl;
    }

    private boolean routeMatch(Object request, BankInterfaceRoute route) {
        boolean result = true;
        if (Objects.nonNull(route.getSubBizMatchValue())) {
            result = result && RouteMatchType.getMatchType(route.getSubBizMatchType()).match(route.getSubBizMatchValue(), FieldUtils.getFieldValue((Object)request, (String)"subBizType"));
        } else if (Objects.nonNull(route.getUseMatchValue())) {
            result = result && RouteMatchType.getMatchType(route.getUseMatchType()).match(route.getUseMatchValue(), FieldUtils.getFieldValue((Object)request, (String)"use"));
        } else if (Objects.nonNull(route.getExplanationMatchValue())) {
            result = result && RouteMatchType.getMatchType(route.getExplanationMatchType()).match(route.getExplanationMatchValue(), FieldUtils.getFieldValue((Object)request, (String)"explanation"));
        } else if (Objects.nonNull(route.getExtData())) {
            List routeMetas = JsonUtil.json2Array((String)route.getExtData(), RouteMeta.class);
            for (RouteMeta meta : routeMetas) {
                result = result && RouteMatchType.getMatchType(meta.getMatchType()).match(meta.getMatchFieldValue(), FieldUtils.getFieldValue((Object)request, (String)meta.getMatchFieldName()));
            }
        }
        return result;
    }

    private IBankService getImpl(Class<?> interfaceClass, List<Class<? extends IBankService>> implClassList, Object request) {
        if (implClassList.size() == 1) {
            return this.getImpl(implClassList.get(0));
        }
        String customID = EBContext.getContext().getCustomID();
        String bankVersionID = EBContext.getContext().getBankVersionID();
        BankInterfaceRoute route = this.routeService.getRoute(customID, bankVersionID, interfaceClass.getName());
        IBankService impl = null;
        if (Objects.nonNull(route) && this.routeMatch(request, route)) {
            impl = implClassList.stream().filter(implClass -> implClass.getName().equalsIgnoreCase(route.getClassName())).findFirst().map(this::getImpl).orElse(null);
        }
        if (Objects.isNull(impl)) {
            this.checkMatchParameterType(interfaceClass, request);
            Optional<IBankService> customOptional = implClassList.stream().map(this::getImpl).filter(implClassObj -> implClassObj.isCustomed() && implClassObj.match(request)).findFirst();
            impl = customOptional.isPresent() ? customOptional.get() : implClassList.stream().map(this::getImpl).filter(implClassObj -> implClassObj.match(request)).findFirst().orElseThrow(() -> EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e1a\u52a1\u5b9e\u73b0\u7c7b\u3002", (String)"BankBundleManager_18", (String)"ebg-aqap-common", (Object[])new Object[0])));
        }
        return impl;
    }

    private void checkMatchParameterType(Class<?> interfaceClass, Object request) {
        Method[] methods = interfaceClass.getMethods();
        String methodName = "match";
        Method matchMethod = null;
        for (Method method : methods) {
            if (!"match".equalsIgnoreCase(method.getName())) continue;
            matchMethod = method;
            break;
        }
        if (matchMethod != null) {
            Class<?> parameterType = matchMethod.getParameterTypes()[0];
            Preconditions.checkArgument((boolean)parameterType.isInstance(request), (Object)String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u9884\u671f%1$s\uff0c\u5b9e\u9645%2$s", (String)"BankBundleManager_30", (String)"ebg-aqap-common", (Object[])new Object[0]), parameterType.getSimpleName(), request.getClass().getSimpleName()));
        }
    }

    public List<String> getBankKeyWords(String bankVersionID) {
        BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
        if (Objects.nonNull(bankVersion)) {
            return bankVersion.getBankVersionMetaInfo().getKeyNames();
        }
        return Lists.newArrayList();
    }

    public String getBankVersionName(String bankVersionID) {
        BankVersion bankVersion = this.bankVersionMap.get(bankVersionID);
        if (Objects.nonNull(bankVersion)) {
            return bankVersion.getBankVersionName();
        }
        return "";
    }

    public Collection<Bank> getBanks() {
        return this.bankMap.values();
    }

    public Collection<BankVersion> getBankVersions() {
        return this.bankVersionMap.values();
    }

    public List<AtomicBizMeta> getBizMetas() {
        return this.bizMetas;
    }

    public <T extends IBankService> T getImplWithoutException(String bankVersionID, Class<T> bizInterface, Object request) {
        try {
            return this.getImpl(bankVersionID, bizInterface, request);
        }
        catch (EBPreCheckException preCheckException) {
            return null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5b9e\u73b0\u7c7b\u5f02\u5e38==" + e.getMessage());
            return null;
        }
    }

    public Map<String, String> getReceiptRule(String bankVersion) {
        if (this.receiptMatchRuleMap.containsKey(bankVersion)) {
            HashMap ruleMap = this.receiptMatchRuleMap.get(bankVersion).get("default");
            return ruleMap == null ? Maps.newHashMapWithExpectedSize((int)1) : ruleMap;
        }
        return Maps.newHashMapWithExpectedSize((int)1);
    }
}

