/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.match;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.jdom2.Element;

public class MatchRule {
    private static final String entity = "receipt_bd_match_rule";
    private static final String properties = "id,number,name,match_rule,bank_version";
    private static final String match_param_entity = "receipt_bd_match_param";
    private static final String match_param_properties = "number,name,detail_param,receipt_param,ref_id";
    private static MatchRule instance;

    @SdkDeprecated
    public static synchronized MatchRule getInstance() {
        if (instance == null) {
            instance = new MatchRule();
        }
        return instance;
    }

    @SdkDeprecated
    public String getDetailJsonWithStructuredData(Element element) {
        HashMap<String, String> jsonMap = new HashMap<String, String>(16);
        if (element != null) {
            List children = element.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                Element node = (Element)children.get(i);
                jsonMap.put(node.getName(), element.getChildTextTrim(node.getName()));
            }
        }
        return JsonUtil.toJson(jsonMap);
    }

    public String getDetailJsonWithNonStructuredData(String base, String content, String spliter) {
        HashMap<String, String> jsonMap = new HashMap<String, String>(16);
        if (StringUtils.isNotEmpty((String)base) && StringUtils.isNotEmpty((String)content)) {
            String[] BaseAttr = StringUtils.split((String)base, (String)spliter);
            String[] items = StringUtils.split((String)content, (String)spliter);
            for (int i = 0; i < BaseAttr.length; ++i) {
                jsonMap.put(BaseAttr[i], items[i]);
            }
        }
        return JsonUtil.toJson(jsonMap);
    }

    @SdkDeprecated
    public String getReceiptNo(String accNo, String transDate, String jsonStr) {
        Map matchRuleMap;
        String bankVersionId = EBContext.getContext().getBankVersionID();
        try {
            String cacheRuleKey = String.format("%s_match_rule", bankVersionId);
            String matchRuleMapJsonStr = CosmicCache.get((String)cacheRuleKey);
            if (StringUtils.isNotEmpty((String)matchRuleMapJsonStr)) {
                matchRuleMap = (Map)JsonUtil.fromJson((String)matchRuleMapJsonStr, Map.class);
            } else {
                matchRuleMap = this.getMatchRule(bankVersionId);
                CosmicCache.putIfAbsentWithExpire((String)cacheRuleKey, (String)JsonUtil.toJson((Object)matchRuleMap), (int)5, (TimeUnit)TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            matchRuleMap = this.getMatchRule(bankVersionId);
        }
        Map jsonMap = (Map)JsonUtil.fromJson((String)jsonStr, Map.class);
        for (Map.Entry entry : matchRuleMap.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("accNo")) {
                matchRuleMap.put(entry.getKey(), accNo);
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("transDate")) {
                matchRuleMap.put(entry.getKey(), transDate);
                continue;
            }
            if (((String)entry.getKey()).equalsIgnoreCase("baseMatchRule")) continue;
            if (jsonMap.containsKey(entry.getValue())) {
                matchRuleMap.put(entry.getKey(), jsonMap.get(entry.getValue()).toString());
                continue;
            }
            matchRuleMap.put(entry.getKey(), "e");
        }
        String receiptNo = "";
        String string = (String)matchRuleMap.get("baseMatchRule");
        if (StringUtils.isNotEmpty((String)string)) {
            String[] baseMatchRules;
            StringBuilder sb = new StringBuilder();
            for (String item : baseMatchRules = string.split("-")) {
                String value = (String)matchRuleMap.get(item);
                if (StringUtils.isEmpty((String)value)) {
                    value = "e";
                }
                sb.append(value).append('-');
            }
            receiptNo = sb.toString();
            receiptNo = receiptNo.substring(0, receiptNo.length() - 1);
        }
        if (receiptNo.length() > 255) {
            receiptNo = receiptNo.substring(0, 255);
        }
        return receiptNo;
    }

    private Map<String, String> getMatchRule(String bankVersion) {
        Map<String, String> matchRuleMap = BankBundleManager.getInstance().getReceiptRule(bankVersion);
        String baseMatchRule = "accNo-oppAccNo-transDate-Amount-cdFlag-serialNo";
        QFilter filter = QFilter.of((String)"bank_version=? and number=? and trans_type=?", (Object[])new Object[]{bankVersion, "define", "0"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            filter = QFilter.of((String)"bank_version=? and number=?", (Object[])new Object[]{bankVersion, "define"});
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
        }
        if (dynamicObject != null) {
            String refId = dynamicObject.getString("id");
            baseMatchRule = dynamicObject.getString("match_rule");
            filter = QFilter.of((String)"ref_id = ?", (Object[])new Object[]{refId});
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)match_param_entity, (String)match_param_properties, (QFilter[])filter.toArray());
            if (dynamicObjects != null && !dynamicObjects.isEmpty()) {
                for (int i = 0; i < dynamicObjects.size(); ++i) {
                    String matchParam = ((DynamicObject)dynamicObjects.get(i)).getString("number");
                    String detailParam = ((DynamicObject)dynamicObjects.get(i)).getString("detail_param");
                    matchRuleMap.put(matchParam, detailParam);
                }
            }
        }
        matchRuleMap.put("baseMatchRule", baseMatchRule);
        return matchRuleMap;
    }
}

