/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.properties;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfigType;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.properties.ObjectPropertiesKey;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public final class GlobalPropertyConfig {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(GlobalPropertyConfig.class);
    private static Map<String, List<PropertyConfigItem>> PropertyConfigItemMap = new ConcurrentHashMap<String, List<PropertyConfigItem>>(16);
    private final List<PropertyConfig> propertyConfigList;
    private List<PropertyConfig> bankPropertyConfig = Lists.newArrayList();
    private final BankAcntService bankAcntService;
    private final ObjectPropertyService objectPropertyService;
    private boolean init = false;
    String[] keys = new String[]{ResManager.loadKDString((String)"\u652f\u4ed8\u901a\u9053", (String)"GlobalPropertyConfig_0", (String)"ebg-aqap-common", (Object[])new Object[0])};
    String[] keys2 = new String[]{ResManager.loadKDString((String)"\u660e\u7ec6", (String)"GlobalPropertyConfig_1", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f59\u989d", (String)"GlobalPropertyConfig_2", (String)"ebg-aqap-common", (Object[])new Object[0])};
    String[] keys3 = new String[]{ResManager.loadKDString((String)"\u5bf9\u79c1", (String)"GlobalPropertyConfig_3", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9\u516c", (String)"GlobalPropertyConfig_4", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"GlobalPropertyConfig_5", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u652f\u4ed8", (String)"GlobalPropertyConfig_6", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u8d44", (String)"GlobalPropertyConfig_7", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5212\u62e8", (String)"GlobalPropertyConfig_8", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f6c\u8d26", (String)"GlobalPropertyConfig_9", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u7b97", (String)"GlobalPropertyConfig_10", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d26\u6237", (String)"GlobalPropertyConfig_11", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5e76\u7b14", (String)"GlobalPropertyConfig_12", (String)"ebg-aqap-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u79ef\u91d1", (String)"GlobalPropertyConfig_13", (String)"ebg-aqap-common", (Object[])new Object[0])};

    public GlobalPropertyConfig(List<PropertyConfig> propertyConfigList, BankAcntService bankAcntService, ObjectPropertyService objectPropertyService) {
        this.propertyConfigList = propertyConfigList;
        this.bankAcntService = bankAcntService;
        this.objectPropertyService = objectPropertyService;
    }

    public static GlobalPropertyConfig getInstance() {
        return SpringContextUtil.getBean(GlobalPropertyConfig.class);
    }

    public List<PropertyConfig> getPropertyConfigList() {
        return this.propertyConfigList;
    }

    public List<PropertyConfig> getBankPropertyConfig() {
        return this.bankPropertyConfig;
    }

    public PropertyConfigItem getPropertyConfigItem(String bankVersionID, String configItemKey) {
        Optional<PropertyConfigItem> optional;
        PropertyConfigItem propertyConfigItem = null;
        if (PropertyConfigItemMap.containsKey(bankVersionID) && (optional = PropertyConfigItemMap.get(bankVersionID).stream().filter(configItem -> configItem.getKey().equalsIgnoreCase(configItemKey)).findFirst()).isPresent()) {
            propertyConfigItem = optional.get();
        }
        return propertyConfigItem;
    }

    private void configInit() {
        if (!this.init) {
            for (PropertyConfig propertyConfig : this.propertyConfigList) {
                if (BankPropertyConfig.class.isAssignableFrom(propertyConfig.getClass())) continue;
                this.dealPropertyConfig(propertyConfig);
            }
        }
        this.init = true;
    }

    private void dealPropertyConfig(PropertyConfig propertyConfig) {
        List<PropertyConfigItem> configItems = propertyConfig.getAllPropertyConfigItems();
        configItems.stream().filter(prop -> StringUtils.isEmpty((String)prop.getType())).forEach(c -> {
            String name = c.getMlName() == null ? c.getName() : c.getMlName().loadKDString();
            for (String item : this.keys2) {
                if (!name.contains(item) && (StringUtils.isEmpty((String)c.getDesc()) || !c.getDesc().contains(item))) continue;
                c.setType(BankPropertyConfigType.BAL_DETAIL_PARAM.getName());
                return;
            }
            for (String value : this.keys3) {
                if (!name.contains(value)) continue;
                c.setType(BankPropertyConfigType.PAY_BIZ_PARAM.getName());
                return;
            }
        });
        for (PropertyConfigItem item : configItems) {
            item.set_propertyConfig(propertyConfig);
        }
        if (propertyConfig instanceof BankPropertyConfig) {
            BankPropertyConfig bankPropertyConfig = (BankPropertyConfig)propertyConfig;
            String bankVersionID = bankPropertyConfig.getBankVersionID();
            if (StringUtils.isNotEmpty((String)bankVersionID)) {
                PropertyConfigItemMap.putIfAbsent(bankVersionID, configItems);
            } else {
                logger.info(bankPropertyConfig.getClass().getName() + "\uff0c\u6ca1\u6709\u7ef4\u62a4bankVersionID");
            }
        }
    }

    private void checkConfigItem(PropertyConfigItem configItem) {
        Preconditions.checkNotNull((Object)configItem, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GlobalPropertyConfig_14", (String)"ebg-aqap-common", (Object[])new Object[0]));
        String name = configItem.getMlName().getDescription();
        Preconditions.checkState((boolean)Objects.nonNull(configItem.get_propertyConfig()), (Object)String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u9879[%s]\uff0cpropertyConfig\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u914d\u7f6e\u9879\u7684\u503c\u3002", (String)"GlobalPropertyConfig_17", (String)"ebg-aqap-common", (Object[])new Object[0]), name));
    }

    private ObjectPropertiesKey getKey(PropertyConfigItem configItem) {
        this.checkConfigItem(configItem);
        String customID = RequestContext.get().getTenantId();
        String objectID = configItem.get_propertyConfig().getPropertyConfigID();
        Preconditions.checkArgument((!"NAN".equalsIgnoreCase(objectID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u9700\u8981\u4f20\u5165 objectID\u3002", (String)"GlobalPropertyConfig_16", (String)"ebg-aqap-common", (Object[])new Object[0]));
        String objectName = configItem.get_propertyConfig().getPropertyName().name();
        if ("common_business".equalsIgnoreCase(objectID)) {
            objectName = BusinessPropertyConfigType.RECEIPT_UPLOAD_PARAM.getType().equals(configItem.getType()) ? "receipt" : "ebg";
        }
        String attrKey = configItem.getKey();
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setAttrKey(attrKey);
        key.setCustomID(customID);
        key.setObjectID(objectID);
        key.setObjectName(objectName);
        return key;
    }

    private ObjectPropertiesKey getKey(PropertyConfigItem configItem, String objectID) {
        this.checkConfigItem(configItem);
        String customID = RequestContext.get().getTenantId();
        String objectName = configItem.get_propertyConfig().getPropertyName().name();
        String attrKey = configItem.getKey();
        ObjectPropertiesKey key = new ObjectPropertiesKey();
        key.setAttrKey(attrKey);
        key.setCustomID(customID);
        key.setObjectID(objectID);
        key.setObjectName(objectName);
        return key;
    }

    public List<String> getConfigValues(PropertyConfigItem configItem) {
        this.configInit();
        List result = null;
        try {
            result = this.objectPropertyService.getPropertyValues(this.getKey(configItem));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u914d\u7f6e\u9879[" + configItem.getName() + "]\u51fa\u9519\uff0c\u5c06\u4f7f\u7528\u9ed8\u8ba4\u503c", (Throwable)e);
        }
        if (Objects.isNull(result) || result.isEmpty()) {
            result = configItem.getDefaultValues();
        }
        if (Objects.isNull(result)) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public void setConfigValue(PropertyConfigItem configValue, String value) {
        this.objectPropertyService.setPropertyValue(this.getKey(configValue), value, configValue.getDesc());
    }

    public void setConfigValues(PropertyConfigItem configValues, List<String> values) {
        this.objectPropertyService.setPropertyValues(this.getKey(configValues), values, configValues.getDesc());
    }

    public String getConfigValue(PropertyConfigItem configItem) {
        List<String> result = this.getConfigValues(configItem);
        return result.isEmpty() ? "" : result.get(0);
    }

    public List<String> getConfigValues(PropertyConfigItem configItem, String objectID) {
        this.configInit();
        List<String> result = null;
        result = this.objectPropertyService.getPropertyValues(this.getKey(configItem, objectID));
        if (result.isEmpty()) {
            result = configItem.getDefaultValues();
        }
        return result;
    }

    public String getConfigValue(PropertyConfigItem configItem, String objectID) {
        List<String> result = this.getConfigValues(configItem, objectID);
        return result == null ? "" : (result.isEmpty() ? "" : result.get(0));
    }

    public boolean getConfigValueAsBoolean(PropertyConfigItem configItem) {
        return Boolean.parseBoolean(this.getConfigValue(configItem));
    }

    public synchronized void registryPropertyConfig(PropertyConfig propertyConfig) {
        this.bankPropertyConfig.add(propertyConfig);
        this.dealPropertyConfig(propertyConfig);
    }
}

