/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import kd.ebg.aqap.common.framework.properties.GlobalPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyChecker;
import kd.ebg.aqap.common.framework.properties.PropertyConfig;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.sdk.annotation.SdkDeprecated;

public class PropertyConfigItem {
    @JsonIgnore
    private transient PropertyConfig _propertyConfig;
    String originalOwner;
    private String key;
    private String name;
    private MultiLangEnumBridge mlName;
    private String desc;
    private List<MultiLangEnumBridge> mlDesc;
    private String type;
    private boolean mustInput;
    private boolean isHide;
    private int minValueNum = 1;
    private int maxValueNum = 1;
    private String inputType;
    private List<PropertyChecker> checkers;
    private List<String> sourceNames;
    private List<MultiLangEnumBridge> mlSourceNames;
    private List<String> sourceValues;
    private List<String> defaultValues;
    private boolean readonly;
    private boolean isAccNo;
    private boolean isHideForForeignBank;
    private ShowByFieldAndVal showByFieldAndVal;

    public ShowByFieldAndVal getShowByFieldAndVal() {
        return this.showByFieldAndVal;
    }

    public void setShowByFieldAndVal(ShowByFieldAndVal showByFieldAndVal) {
        this.showByFieldAndVal = showByFieldAndVal;
    }

    public MultiLangEnumBridge getMlName() {
        return this.mlName;
    }

    public List<MultiLangEnumBridge> getMlDesc() {
        return this.mlDesc;
    }

    public void setMlDesc(List<MultiLangEnumBridge> mlDesc) {
        this.mlDesc = mlDesc;
    }

    public List<MultiLangEnumBridge> getMlSourceNames() {
        return this.mlSourceNames;
    }

    public void setMlSourceNames(List<MultiLangEnumBridge> mlSourceNames) {
        if (Objects.nonNull(mlSourceNames)) {
            mlSourceNames.stream().filter(Objects::nonNull).forEach(v -> {
                if (v.getDescription().endsWith("\u3002")) {
                    v.setDescription(v.getDescription().substring(0, v.getDescription().length() - 1));
                }
            });
        }
        this.mlSourceNames = mlSourceNames;
    }

    public void setMlName(MultiLangEnumBridge mlName) {
        if (Objects.nonNull(mlName) && Objects.nonNull(mlName.getDescription()) && mlName.getDescription().endsWith("\u3002")) {
            mlName.setDescription(mlName.getDescription().substring(0, mlName.getDescription().length() - 1));
        }
        this.mlName = mlName;
    }

    public boolean isHide() {
        return this.isHide;
    }

    public void setHide(boolean hide) {
        this.isHide = hide;
    }

    @JsonIgnore
    @SdkDeprecated
    public String getCurrentValue() {
        return GlobalPropertyConfig.getInstance().getConfigValue(this);
    }

    public void setCurrentValues(List<String> values) {
        GlobalPropertyConfig.getInstance().setConfigValues(this, values);
    }

    @JsonIgnore
    public List<String> getCurrentValues() {
        return GlobalPropertyConfig.getInstance().getConfigValues(this);
    }

    @SdkDeprecated
    @JsonIgnore
    public String getCurrentValueWithObjectID(String objectID) {
        return GlobalPropertyConfig.getInstance().getConfigValue(this, objectID);
    }

    @SdkDeprecated
    @JsonIgnore
    public List<String> getCurrentValuesWithObjectID(String objectID) {
        return GlobalPropertyConfig.getInstance().getConfigValues(this, objectID);
    }

    @JsonIgnore
    @SdkDeprecated
    public boolean getCurrentValueAsBoolean() {
        String currentValue = this.getCurrentValue();
        return "on".equalsIgnoreCase(currentValue) || Boolean.parseBoolean(this.getCurrentValue());
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    @JsonIgnore
    public int getCurrentValueAsInt() {
        return Integer.parseInt(this.getCurrentValue());
    }

    public PropertyConfig get_propertyConfig() {
        return this._propertyConfig;
    }

    public void set_propertyConfig(PropertyConfig _propertyConfig) {
        this._propertyConfig = _propertyConfig;
    }

    public String getOriginalOwner() {
        return this.originalOwner;
    }

    public void setOriginalOwner(String originalOwner) {
        this.originalOwner = originalOwner;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean mustInput) {
        this.mustInput = mustInput;
    }

    public int getMinValueNum() {
        return this.minValueNum;
    }

    public void setMinValueNum(int minValueNum) {
        this.minValueNum = minValueNum;
    }

    public int getMaxValueNum() {
        return this.maxValueNum;
    }

    public void setMaxValueNum(int maxValueNum) {
        this.maxValueNum = maxValueNum;
    }

    public List<PropertyChecker> getCheckers() {
        return this.checkers;
    }

    public void setCheckers(List<PropertyChecker> checkers) {
        this.checkers = checkers;
    }

    public List<String> getSourceNames() {
        return this.sourceNames;
    }

    public void setSourceNames(List<String> sourceNames) {
        this.sourceNames = sourceNames;
    }

    public List<String> getSourceValues() {
        return this.sourceValues;
    }

    public void setSourceValues(List<String> sourceValues) {
        this.sourceValues = sourceValues;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(List<String> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isAccNo() {
        return this.isAccNo;
    }

    public void setAccNo(boolean accNo) {
        this.isAccNo = accNo;
    }

    public boolean isHideForForeignBank() {
        return this.isHideForForeignBank;
    }

    public void setHideForForeignBank(boolean hideForForeignBank) {
        this.isHideForForeignBank = hideForForeignBank;
    }

    @SdkDeprecated
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String key;
        String name;
        MultiLangEnumBridge mlName;
        String desc;
        List<MultiLangEnumBridge> mlDesc;
        List<String> sourceNames;
        List<MultiLangEnumBridge> mlSourceNames;
        List<String> sourceValues;
        List<String> defaultValues;
        int minValueNum;
        int maxValueNum;
        List<PropertyChecker> checkers;
        String type;
        boolean mustInput;
        boolean accNo;
        boolean readonly;
        boolean isHide;
        String inputType;
        boolean isHideForForeignBank;
        ShowByFieldAndVal showByFieldAndVal;

        @SdkDeprecated
        public Builder key(String value) {
            this.key = value;
            return this;
        }

        @SdkDeprecated
        public Builder name(String value) {
            this.name = value;
            return this;
        }

        @SdkDeprecated
        public Builder mlName(MultiLangEnumBridge value) {
            this.mlName = value;
            return this;
        }

        @SdkDeprecated
        public Builder desc(String value) {
            this.desc = value;
            return this;
        }

        @SdkDeprecated
        public Builder mlDesc(MultiLangEnumBridge mlDesc) {
            this.mlDesc = Lists.newArrayList((Object[])new MultiLangEnumBridge[]{mlDesc});
            return this;
        }

        @SdkDeprecated
        public Builder mlDesc(List<MultiLangEnumBridge> mlDesc) {
            this.mlDesc = mlDesc;
            return this;
        }

        @SdkDeprecated
        public Builder sourceNames(List<String> value) {
            this.sourceNames = value;
            return this;
        }

        @SdkDeprecated
        public Builder mlSourceNames(MultiLangEnumBridge value) {
            this.mlSourceNames = Lists.newArrayList((Object[])new MultiLangEnumBridge[]{value});
            return this;
        }

        @SdkDeprecated
        public Builder mlSourceNames(List<MultiLangEnumBridge> value) {
            this.mlSourceNames = value;
            return this;
        }

        @SdkDeprecated
        public Builder sourceValues(List<String> value) {
            this.sourceValues = value;
            return this;
        }

        @SdkDeprecated
        public Builder defaultValues(List<String> value) {
            this.defaultValues = value;
            return this;
        }

        @SdkDeprecated
        public Builder minValueNum(int value) {
            this.minValueNum = value;
            return this;
        }

        @SdkDeprecated
        public Builder maxValueNum(int value) {
            this.maxValueNum = value;
            return this;
        }

        @SdkDeprecated
        public Builder checkers(List<PropertyChecker> checkers) {
            this.checkers = checkers;
            return this;
        }

        @SdkDeprecated
        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @SdkDeprecated
        public Builder mustInput(boolean mustInput) {
            this.mustInput = mustInput;
            return this;
        }

        @SdkDeprecated
        public Builder isAccNo(boolean accNo) {
            this.accNo = accNo;
            return this;
        }

        @SdkDeprecated
        public Builder isHideForForeignBank(boolean isHideForForeignBank) {
            this.isHideForForeignBank = isHideForForeignBank;
            return this;
        }

        @SdkDeprecated
        public Builder isHide(boolean isHide) {
            this.isHide = isHide;
            return this;
        }

        @SdkDeprecated
        public Builder readonly(boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        @SdkDeprecated
        public Builder showByFieldAndVal(ShowByFieldAndVal showByFieldAndVal) {
            this.showByFieldAndVal = showByFieldAndVal;
            return this;
        }

        @SdkDeprecated
        public Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @SdkDeprecated
        public Builder set2Integer() {
            this.inputType = ConfigInputType.INTEGER.getInputType();
            this.minValueNum = 0;
            this.maxValueNum = 0x7FFFFFFE;
            return this;
        }

        @SdkDeprecated
        public Builder set2MaxValueNum(int maxValueNum) {
            this.maxValueNum = maxValueNum;
            return this;
        }

        @SdkDeprecated
        public Builder set2MinValueNum(Integer minValueNum) {
            this.minValueNum = minValueNum;
            return this;
        }

        @SdkDeprecated
        public PropertyConfigItem build() {
            PropertyConfigItem propertyConfigItem = new PropertyConfigItem();
            propertyConfigItem.setKey(this.key);
            propertyConfigItem.setName(this.name);
            propertyConfigItem.setMlName(this.mlName);
            propertyConfigItem.setDesc(this.desc);
            propertyConfigItem.setMlDesc(this.mlDesc);
            propertyConfigItem.setSourceNames(this.sourceNames);
            propertyConfigItem.setMlSourceNames(this.mlSourceNames);
            propertyConfigItem.setSourceValues(this.sourceValues);
            propertyConfigItem.setDefaultValues(this.defaultValues);
            propertyConfigItem.setMinValueNum(this.minValueNum);
            propertyConfigItem.setMaxValueNum(this.maxValueNum);
            propertyConfigItem.setCheckers(this.checkers);
            propertyConfigItem.setType(this.type);
            propertyConfigItem.setInputType(this.inputType);
            propertyConfigItem.setMustInput(this.mustInput);
            propertyConfigItem.setAccNo(this.accNo);
            propertyConfigItem.setReadonly(this.readonly);
            propertyConfigItem.setHideForForeignBank(this.isHideForForeignBank);
            propertyConfigItem.setHide(this.isHide);
            propertyConfigItem.setShowByFieldAndVal(this.showByFieldAndVal);
            return propertyConfigItem;
        }
    }
}

