/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation;

public class KDRule {
    private String bankVersion;
    private String interfaceCode;
    private String nodePath;
    private String codeRule;
    private String kdFlag;
    private int kdFlagIDLength;
    private boolean bankRefFlag;
    private boolean mergeFlag;
    private String contentType;
    private String bizType;
    private int explanationSize;
    private int recordNum;
    private boolean skipFirstLine;

    public KDRule() {
        this.nodePath = "";
        this.codeRule = "";
        this.kdFlag = "_KD";
        this.bankRefFlag = false;
        this.mergeFlag = false;
    }

    public KDRule(String nodePath, String codeRule, String kdFlag) {
        this.nodePath = nodePath;
        this.codeRule = codeRule;
        this.kdFlag = kdFlag;
    }

    public String getKDFlagID(String id) {
        return id + this.kdFlag;
    }

    public String parseKDFlagIDFromDetail(String value) {
        int index = value.indexOf(this.kdFlag);
        if (index >= 0) {
            return value.substring(0, index);
        }
        return "";
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public String getCodeRule() {
        return this.codeRule;
    }

    public void setCodeRule(String codeRule) {
        this.codeRule = codeRule;
    }

    public String getKdFlag() {
        return this.kdFlag;
    }

    public void setKdFlag(String kdFlag) {
        this.kdFlag = kdFlag;
    }

    public boolean isBankRefFlag() {
        return this.bankRefFlag;
    }

    public void setBankRefFlag(boolean bankRefFlag) {
        this.bankRefFlag = bankRefFlag;
    }

    public boolean isMergeFlag() {
        return this.mergeFlag;
    }

    public void setMergeFlag(boolean mergeFlag) {
        this.mergeFlag = mergeFlag;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getBizType() {
        return this.bizType;
    }

    public void setBizType(String bizTYpe) {
        this.bizType = bizTYpe;
    }

    public int getKdFlagIDLength() {
        return this.kdFlagIDLength;
    }

    public void setKdFlagIDLength(int kdFlagIDLength) {
        this.kdFlagIDLength = kdFlagIDLength;
    }

    public String getBankVersion() {
        return this.bankVersion;
    }

    public void setBankVersion(String bankVersion) {
        this.bankVersion = bankVersion;
    }

    public String getInterfaceCode() {
        return this.interfaceCode;
    }

    public void setInterfaceCode(String interfaceCode) {
        this.interfaceCode = interfaceCode;
    }

    public int getExplanationSize() {
        return this.explanationSize;
    }

    public void setExplanationSize(int explanationSize) {
        this.explanationSize = explanationSize;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof KDRule) {
            KDRule o = (KDRule)obj;
            boolean flag = this.getBankVersion().equals(o.getBankVersion());
            flag &= this.getInterfaceCode().equals(o.getInterfaceCode());
            flag &= this.getNodePath().equals(o.getNodePath());
            return flag &= this.getKdFlag().equals(o.getKdFlag());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("bankVersion=").append(this.getBankVersion()).append(',').append("interfaceCode=").append(this.getInterfaceCode()).append(',').append("param=").append(this.getNodePath());
        return sb.toString();
    }

    public int getRecordNum() {
        return this.recordNum;
    }

    public void setRecordNum(int recordNum) {
        this.recordNum = recordNum;
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }
}

