/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation.processor;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.common.framework.reconciliation.AbstractKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.find.FindNodeInfo;

public class FileKDProcessor
extends AbstractKDProcessor {
    @Override
    public List<FindNodeInfo> handle(String content, String nodePath) {
        ArrayList<FindNodeInfo> nodeInfoList = new ArrayList<FindNodeInfo>(16);
        if (nodePath.length() >= 2) {
            char split = nodePath.charAt(0);
            int pos = -1;
            try {
                pos = Integer.parseInt(nodePath.substring(1));
            }
            catch (NumberFormatException e) {
                return nodeInfoList;
            }
            int flag = pos == 0 ? -1 : 0;
            for (int i = 0; i < content.length(); ++i) {
                if (content.charAt(i) == '\r' || content.charAt(i) == '\n') {
                    flag = pos == 0 ? -1 : 0;
                    continue;
                }
                if (content.charAt(i) != split && (flag != -1 || i != 0 && content.charAt(i - 1) != '\n') || ++flag != pos) continue;
                FindNodeInfo nodeInfo = new FindNodeInfo();
                if (pos == 0) {
                    nodeInfo.setStartIndex(i);
                } else {
                    nodeInfo.setStartIndex(i + 1);
                }
                String subContent = content.substring(nodeInfo.getStartIndex());
                int offset = subContent.indexOf(split);
                if (offset != -1) {
                    nodeInfo.setEndIndex(nodeInfo.getStartIndex() + offset);
                } else {
                    nodeInfo.setEndIndex(nodeInfo.getStartIndex() + subContent.length() - 1);
                }
                nodeInfo.setNodeValue(content.substring(nodeInfo.getStartIndex(), nodeInfo.getEndIndex()));
                nodeInfoList.add(nodeInfo);
            }
        }
        return nodeInfoList;
    }
}

