/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kd.ebg.aqap.common.framework.reconciliation.AbstractKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.find.FindNodeInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class JsonKDProcessor
extends AbstractKDProcessor {
    public static final int FULL_MATCH = 2;
    public static final int SIMILAR_MATCH = 1;
    public static final int NOT_MATCH = 0;

    @Override
    public List<FindNodeInfo> handle(String content, String nodePath) {
        Stack<FindNodeInfo> nodeInfoStack = new Stack<FindNodeInfo>();
        ArrayList<FindNodeInfo> nodeInfoList = new ArrayList<FindNodeInfo>(16);
        if (StringUtils.isNotEmpty((String)nodePath)) {
            if (nodePath.startsWith("/")) {
                nodePath = nodePath.substring(1);
            }
            int j = -1;
            block0: for (int i = j + 1; i < content.length(); ++i) {
                if (content.charAt(i) != '\"' || i >= content.length() - 1 || content.charAt(i + 1) == ':') continue;
                for (j = i + 1; j < content.length(); ++j) {
                    if (content.charAt(j) != '\"' || j >= content.length() - 1 || content.charAt(j + 1) != ':') continue;
                    String tempNodeName = content.substring(i + 1, j);
                    if (!nodePath.contains(tempNodeName)) continue block0;
                    FindNodeInfo nodeInfo = new FindNodeInfo();
                    nodeInfo.setNodeName(tempNodeName);
                    nodeInfoStack.push(nodeInfo);
                    int matchResult = this.match(nodeInfoStack, nodePath);
                    if (matchResult == 2) {
                        nodeInfo = nodeInfoStack.pop();
                        int vi1 = content.substring(j + 1).indexOf("\"");
                        int vi2 = content.substring(j + 2 + vi1).indexOf("\"");
                        String value = content.substring(j + 2 + vi1, j + 2 + vi1 + vi2);
                        nodeInfo.setStartIndex(j + 2 + vi1);
                        nodeInfo.setEndIndex(j + 2 + vi1 + vi2);
                        nodeInfo.setNodeValue(value);
                        nodeInfoList.add(nodeInfo);
                        j = nodeInfo.getEndIndex();
                        continue block0;
                    }
                    if (matchResult != 0) continue block0;
                    nodeInfoStack.pop();
                    continue block0;
                }
            }
        }
        return nodeInfoList;
    }

    private int match(Stack<FindNodeInfo> stack, String pattern) {
        StringBuilder sb = new StringBuilder();
        Iterator infoIterator = stack.iterator();
        while (infoIterator.hasNext()) {
            sb.append(((FindNodeInfo)infoIterator.next()).getNodeName()).append('/');
        }
        String compareStr = sb.toString();
        if (compareStr.endsWith("/")) {
            compareStr = compareStr.substring(0, compareStr.length() - 1);
        }
        if (pattern.equals(compareStr)) {
            return 2;
        }
        if (pattern.startsWith(compareStr)) {
            return 1;
        }
        return 0;
    }
}

