/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.BalanceReconciliationRecord;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

@Service
public class BalanceReconciliationService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceReconciliationService.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository;
    private BalanceReconciliationRecordRepository balanceRecordRepository;

    /*
     * WARNING - void declaration
     */
    public void insertOrUpdate(String startMonthStr, String endMonthStr, List<BalanceReconciliationDetail> bankDetails) {
        this.balanceDetailRepository = SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);
        this.balanceRecordRepository = SpringContextUtil.getBean(BalanceReconciliationRecordRepository.class);
        if (CollectionUtil.isEmpty(bankDetails)) {
            return;
        }
        String accNo = bankDetails.get(0).getAccNo();
        String currency = bankDetails.get(0).getCurrency();
        LocalDate startMonth = LocalDateUtil.parserMonth((String)startMonthStr);
        LocalDate endMonth = LocalDateUtil.parserMonth((String)endMonthStr);
        TXHandle h = TX.requiresNew();
        try {
            void var14_24;
            List<BalanceReconciliationDetail> dbDetails = this.balanceDetailRepository.findByAccNoAndCurrencyAndMonthBetween(accNo, currency, startMonth, endMonth);
            if (CollectionUtil.isEmpty(dbDetails)) {
                logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u51c6\u5907\u63d2\u5165\u8bb0\u5f55{}\u6761", new Object[]{accNo, currency, startMonthStr, endMonthStr, bankDetails.size()});
                this.balanceDetailRepository.saveAll(bankDetails);
                logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u63d2\u5165\u6570\u636e\u5e93\u6210\u529f\uff0c\u5168\u90e8\u4e3a\u65b0\u589e\u8bb0\u5f55{}\u6761", new Object[]{accNo, currency, startMonthStr, endMonthStr, bankDetails.size()});
            } else {
                HashMap dbDetailMap = Maps.newHashMapWithExpectedSize((int)dbDetails.size());
                ArrayList<BalanceReconciliationDetail> saveDetails = new ArrayList<BalanceReconciliationDetail>(bankDetails.size());
                for (BalanceReconciliationDetail balanceReconciliationDetail : dbDetails) {
                    dbDetailMap.put(balanceReconciliationDetail.getMonth(), balanceReconciliationDetail);
                }
                int insertCount = 0;
                for (BalanceReconciliationDetail balanceReconciliationDetail : bankDetails) {
                    if (dbDetailMap.get(balanceReconciliationDetail.getMonth()) != null) {
                        logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}\u5df2\u5b58\u5728\u8bb0\u5f55\uff0c\u505a\u66f4\u65b0\u64cd\u4f5c", new Object[]{balanceReconciliationDetail.getAccNo(), balanceReconciliationDetail.getCurrency(), balanceReconciliationDetail.getMonth()});
                        BalanceReconciliationDetail dbDetail = (BalanceReconciliationDetail)dbDetailMap.get(balanceReconciliationDetail.getMonth());
                        dbDetail.setBalance(balanceReconciliationDetail.getBalance());
                        dbDetail.setStatementNo(balanceReconciliationDetail.getStatementNo());
                        dbDetail.setReserved1(balanceReconciliationDetail.getReserved1());
                        dbDetail.setReserved2(balanceReconciliationDetail.getReserved2());
                        dbDetail.setReserved3(balanceReconciliationDetail.getReserved3());
                        dbDetail.setReversedSysField(balanceReconciliationDetail.getReversedSysField());
                        dbDetail.setReversedBizField(balanceReconciliationDetail.getReversedBizField());
                        saveDetails.add(dbDetail);
                        continue;
                    }
                    ++insertCount;
                    saveDetails.add(balanceReconciliationDetail);
                }
                logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u51c6\u5907\u63d2\u5165\u8bb0\u5f55{}\u6761", new Object[]{accNo, currency, startMonthStr, endMonthStr, saveDetails.size()});
                this.balanceDetailRepository.updateAll(saveDetails);
                logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u63d2\u5165\u6570\u636e\u5e93\u6210\u529f\uff0c\u5176\u4e2d\u65b0\u589e\u8bb0\u5f55{}\u6761\uff0c\u66f4\u65b0\u8bb0\u5f55{}\u6761", new Object[]{accNo, currency, startMonthStr, endMonthStr, insertCount, dbDetails.size()});
            }
            ArrayList<BalanceReconciliationRecord> insertRecords = new ArrayList<BalanceReconciliationRecord>(1);
            ArrayList<BalanceReconciliationRecord> updateRecords = new ArrayList<BalanceReconciliationRecord>(1);
            List<BalanceReconciliationRecord> dbRecords = this.balanceRecordRepository.findByAccNoAndCurrencyAndMonthBetween(accNo, currency, startMonth, endMonth);
            HashMap<LocalDate, BalanceReconciliationRecord> hashMap = new HashMap<LocalDate, BalanceReconciliationRecord>();
            if (CollectionUtil.isNotEmpty(dbRecords)) {
                for (BalanceReconciliationRecord dbRecord : dbRecords) {
                    hashMap.put(dbRecord.getSyncDate(), dbRecord);
                }
            }
            LocalDate localDate = startMonth;
            while (var14_24.isBefore(endMonth) || var14_24.isEqual(endMonth)) {
                BalanceReconciliationRecord record;
                if (hashMap.get(var14_24) != null) {
                    record = (BalanceReconciliationRecord)hashMap.get(var14_24);
                    record.setSyncCount(record.getSyncCount() + 1);
                    updateRecords.add(record);
                } else {
                    record = new BalanceReconciliationRecord();
                    record.setSyncCount(1);
                    record.setAccNo(accNo);
                    record.setCurrency(currency);
                    record.setSyncDate((LocalDate)var14_24);
                    record.setEnable(1);
                    insertRecords.add(record);
                }
                LocalDate localDate2 = var14_24.plusMonths(1L);
            }
            int countSize = insertRecords.size() + updateRecords.size();
            logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u51c6\u5907\u63d2\u5165recode\u8868{}\u6761\u8bb0\u5f55", new Object[]{accNo, currency, startMonthStr, endMonthStr, countSize});
            this.balanceRecordRepository.saveOrUpdateAll(insertRecords, updateRecords);
            logger.info("\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u63d2\u5165recode\u8868\u6210\u529f\uff0c\u65b0\u589e{}\u6761\uff0c\u66f4\u65b0{}\u6761", new Object[]{accNo, currency, startMonthStr, endMonthStr, insertRecords.size(), updateRecords.size()});
        }
        catch (Exception ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u5f85\u7ecf\u529e\u8bb0\u5f55\u5199\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38", (String)"BalanceReconciliationService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)ex);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

