/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.acct.MappingTable;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.model.repository.MappingAcctRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.currency.BankCurrencyKey;
import kd.ebg.egf.common.model.currency.IsoCurrency;
import kd.ebg.egf.common.repository.currency.BankCurrencyRepository;
import kd.ebg.egf.common.repository.currency.IsoCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BankAcntOpService {
    static final String BANKACNT_ENTITY = "aqap_bank_acnt";
    static final String ENTITY_KEY_OBJECT_PROPERTIES = "aqap_object_properties";
    static final String ENTITY_KEY_BANK = "aqap_bank";
    static final String ENTITY_KEY_BANK_CURRENCY = "aqap_bank_currency";
    public static final List<String> EB_CURRENCIES = Lists.newArrayList((Object[])new String[]{"CNY", "USD", "HKD", "JPY", "EUR", "GBP", "CHF", "MOP", "TWD", "CAD", "AUD", "KRW", "NZD", "SGD"});
    private MappingAcctRepository maRepo = SpringContextUtil.getBean(MappingAcctRepository.class);
    private static BankAcntOpService instance = new BankAcntOpService();

    public static BankAcntOpService getInstance() {
        return instance;
    }

    public List<String> getEbCurrencies() {
        IsoCurrencyRepository isoCurrencyRepository = IsoCurrencyRepository.getInstance();
        List isoCurrencies = isoCurrencyRepository.findAll();
        if (isoCurrencies != null && isoCurrencies.size() > 0) {
            ArrayList<String> result = new ArrayList<String>(1);
            for (IsoCurrency currency : isoCurrencies) {
                result.add(currency.getIsoCode().toUpperCase(Locale.ENGLISH));
            }
            return result;
        }
        return EB_CURRENCIES;
    }

    public void save(BankAcnt acnt, boolean needInsertAttr) {
        List proxies = acnt.getProxy();
        MappingTable mappingTable = new MappingTable();
        mappingTable.setParentAcct(acnt.getAccNo());
        ArrayList<MappingTable.TableStruct> tsList = new ArrayList<MappingTable.TableStruct>(2);
        for (BankAcnt.Proxy proxy : proxies) {
            MappingTable.TableStruct table = new MappingTable.TableStruct();
            table.setAccNo(proxy.getInquiryaccount());
            table.setCurrency(proxy.getCurrency());
            table.setSwiftCode(proxy.getSwiftCode());
            table.setReserve(proxy.getPayaccount());
            tsList.add(table);
        }
        mappingTable.setChildAccts(tsList);
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{acnt.getAccNo()});
        boolean isExist = QueryServiceHelper.exists((String)BANKACNT_ENTITY, (QFilter[])filter.toArray());
        if (isExist) {
            this.update(acnt, mappingTable);
        } else {
            String accType;
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BANKACNT_ENTITY);
            QFilter qFilter = QFilter.of((String)"number=?", (Object[])new Object[]{acnt.getBankVersionId()});
            DynamicObject bankInfo = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_BANK, (String)"", (QFilter[])qFilter.toArray());
            this.checkNull(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u7248\u672c", (String)"BankAcntService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), bankInfo, acnt.getBankVersionId());
            qFilter = QFilter.of((String)"bank_version.number=? and number=?", (Object[])new Object[]{acnt.getBankVersionId(), acnt.getCurrency()});
            DynamicObject currencyInfo = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_BANK_CURRENCY, (String)"", (QFilter[])qFilter.toArray());
            this.checkNull(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u5e01\u79cd", (String)"BankAcntService_1", (String)"ebg-aqap-common", (Object[])new Object[0]), currencyInfo, acnt.getCurrency());
            qFilter = QFilter.of((String)"number=?", (Object[])new Object[]{acnt.getBankLoginId()});
            DynamicObject bankLoginInfo = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_login", (String)"", (QFilter[])qFilter.toArray());
            this.checkNull(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u524d\u7f6e\u673a", (String)"BankAcntService_2", (String)"ebg-aqap-common", (Object[])new Object[0]), bankLoginInfo, acnt.getBankLoginId());
            String pk = bankLoginInfo.getString("id");
            if (!StringUtils.isEmpty((String)acnt.getCity())) {
                dynamicObject.set("addr", (Object)this.match_admindivision(acnt));
            }
            dynamicObject.set("number", (Object)acnt.getAccNo());
            dynamicObject.set("name", (Object)acnt.getAccName());
            dynamicObject.set("group", (Object)bankInfo);
            dynamicObject.set("currency", (Object)currencyInfo);
            dynamicObject.set("bank_login", (Object)pk);
            dynamicObject.set("bank_address", (Object)acnt.getBankAddress());
            dynamicObject.set("bank_login_id", (Object)acnt.getBankLoginId());
            dynamicObject.set("bank_name", (Object)acnt.getBankName());
            dynamicObject.set("bank_short_name", (Object)acnt.getBankShortName());
            dynamicObject.set("bank_version_id", (Object)acnt.getBankVersionId());
            dynamicObject.set("country", (Object)acnt.getCountry());
            dynamicObject.set("city", (Object)acnt.getCity());
            dynamicObject.set("province", (Object)acnt.getProvince());
            dynamicObject.set("iso_currency", (Object)acnt.getCurrency());
            dynamicObject.set("custom_id", (Object)acnt.getCustomID());
            dynamicObject.set("status", (Object)"A");
            dynamicObject.set("enable", (Object)1);
            dynamicObject.set("has_receipt", (Object)(acnt.getHasReceipt() != false ? "1" : "0"));
            if (acnt.getHasNote() == null) {
                dynamicObject.set("has_note", (Object)"0");
            } else {
                dynamicObject.set("has_note", (Object)(acnt.getHasNote() != false ? "1" : "0"));
            }
            dynamicObject.set("branch_no", (Object)acnt.getBranchNo());
            dynamicObject.set("branch_name", (Object)acnt.getBranchName());
            dynamicObject.set("cnapname", (Object)acnt.getCnapname());
            if (StringUtils.isNotEmpty((String)acnt.getEnAccName())) {
                dynamicObject.set("en_accname", (Object)acnt.getEnAccName());
            }
            if (StringUtils.isNotEmpty((String)acnt.getSwiftCode())) {
                dynamicObject.set("swift_code", (Object)acnt.getSwiftCode());
            }
            if (StringUtils.isEmpty((String)(accType = acnt.getAccType())) || "1".equalsIgnoreCase(accType)) {
                accType = "normal";
            }
            boolean receipt = acnt.getHasReceipt();
            Boolean hasNote = acnt.getHasNote();
            String areaCode = acnt.getAreaCode();
            String cnaps = acnt.getCnaps();
            String switchCode = acnt.getSwiftCode();
            String accNo = acnt.getAccNo();
            DynamicObject[] dynamicObjects = null;
            if (needInsertAttr) {
                List<PropertyConfigItem> propertyConfigs = BankBundleManager.getInstance().getBankVersionInfo(acnt.getBankVersionId()).getPropertyConfig().getAllPropertyConfigItems();
                List configItemInfos = propertyConfigs.stream().filter(configItemInfo -> configItemInfo.isAccNo()).collect(Collectors.toList());
                int i = 0;
                if (CollectionUtil.isNotEmpty(configItemInfos)) {
                    dynamicObjects = new DynamicObject[configItemInfos.size()];
                    for (PropertyConfigItem c : configItemInfos) {
                        if (c.isMustInput() && CollectionUtil.isEmpty(c.getDefaultValues())) {
                            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%1$s\u5b57\u6bb5[%2$s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BankAcntService_10", (String)"ebg-aqap-common", (Object[])new Object[0]), c.getName(), c.getKey()));
                        }
                        String val = "";
                        if (c.getDefaultValues() != null && c.getDefaultValues().size() > 0) {
                            val = c.getDefaultValues().get(0);
                        }
                        if (c.getKey().equalsIgnoreCase("bank_accType")) {
                            val = accType;
                        } else if (c.getKey().equalsIgnoreCase("bank_isReceipt")) {
                            val = String.valueOf(receipt);
                        } else if (c.getKey().equalsIgnoreCase("bank_isNote")) {
                            val = String.valueOf(hasNote);
                        } else if (c.getKey().equalsIgnoreCase("bank_area_code")) {
                            val = areaCode;
                        } else if (c.getKey().equalsIgnoreCase("bank_cnap")) {
                            val = cnaps;
                        } else if (c.getKey().equalsIgnoreCase("bank_ecny_type") && acnt.getHasEcny().booleanValue()) {
                            val = acnt.getAccEcnyType();
                        } else if (c.getKey().equalsIgnoreCase("bank_ecny_level") && acnt.getHasEcny().booleanValue()) {
                            val = acnt.getAccEcnyLevel();
                        } else if (c.getKey().equalsIgnoreCase("bank_swift_code") || c.getKey().endsWith("_BICCODE") || c.getKey().endsWith("_BIC_CODE")) {
                            val = switchCode;
                        } else if (c.getKey().equalsIgnoreCase("accno_search_limit")) {
                            LocalDate detailSearchDate;
                            val = "false";
                            String detailSerachDateStr = BankPropertyConfig.getBankDetailSearchDate(acnt.getBankVersionId());
                            if (StringUtils.isNotEmpty((String)detailSerachDateStr) && (detailSearchDate = LocalDate.parse(detailSerachDateStr.replace("-", ""), DateTimeFormatter.BASIC_ISO_DATE)).isBefore(LocalDate.now())) {
                                val = "true";
                            }
                        }
                        dynamicObjects[i] = this.createDataEntity(c.getKey(), val, accNo);
                        ++i;
                    }
                }
            }
            try (TXHandle h = TX.required();){
                Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                if (objects == null) {
                    throw new Exception(ResManager.loadKDString((String)"\u8d26\u53f7\u4fdd\u5b58\u6570\u636e\u5e93\u5931\u8d25\u3002", (String)"BankAcntService_6", (String)"ebg-aqap-common", (Object[])new Object[0]));
                }
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    SaveServiceHelper.save(dynamicObjects);
                }
                this.maRepo.save(mappingTable);
            }
        }
    }

    private DynamicObject createDataEntity(String key, Object value, String accno) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KEY_OBJECT_PROPERTIES);
        dataEntity.set("attr_key", (Object)key);
        dataEntity.set("attr_value", value);
        dataEntity.set("object_id", (Object)accno);
        dataEntity.set("object_name", (Object)"BANK_BUSINESS");
        return dataEntity;
    }

    public void update(BankAcnt acnt) {
        this.update(acnt, null);
    }

    public void update(BankAcnt acnt, MappingTable mappingTable) {
        String selectProperties = "name,group,currency,bank_login,addr,bank_address,bank_login_id,bank_name,bank_short_name,bank_version_id,country,city,province,iso_currency,enable,has_receipt,has_note,branch_no,branch_name,custom_id,cnapname,en_accname,swift_code";
        QFilter filter = QFilter.of((String)"number=?", (Object[])new Object[]{acnt.getAccNo()});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BANKACNT_ENTITY, (String)selectProperties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            List<PropertyConfigItem> propertyConfigs;
            List configItemInfos;
            QFilter qFilter = QFilter.of((String)"number=?", (Object[])new Object[]{acnt.getBankVersionId()});
            DynamicObject bankInfo = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_BANK, (String)"", (QFilter[])qFilter.toArray());
            this.checkNull(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u7248\u672c", (String)"BankAcntService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), bankInfo, acnt.getBankVersionId());
            qFilter = QFilter.of((String)"bank_version.number=? and number=?", (Object[])new Object[]{acnt.getBankVersionId(), acnt.getCurrency()});
            DynamicObject currencyInfo = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_BANK_CURRENCY, (String)"", (QFilter[])qFilter.toArray());
            this.checkNull(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u5e01\u79cd", (String)"BankAcntService_1", (String)"ebg-aqap-common", (Object[])new Object[0]), currencyInfo, acnt.getCurrency());
            qFilter = QFilter.of((String)"number=?", (Object[])new Object[]{acnt.getBankLoginId()});
            DynamicObject bankLoginInfo = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_login", (String)"", (QFilter[])qFilter.toArray());
            this.checkNull(ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u524d\u7f6e\u673a", (String)"BankAcntService_2", (String)"ebg-aqap-common", (Object[])new Object[0]), bankLoginInfo, acnt.getBankLoginId());
            String pk = bankLoginInfo.getString("id");
            if (!StringUtils.isEmpty((String)acnt.getCity())) {
                dynamicObject.set("addr", (Object)this.match_admindivision(acnt));
            }
            dynamicObject.set("name", (Object)acnt.getAccName());
            dynamicObject.set("group", (Object)bankInfo);
            dynamicObject.set("currency", (Object)currencyInfo);
            dynamicObject.set("bank_login", (Object)pk);
            dynamicObject.set("bank_address", (Object)acnt.getBankAddress());
            dynamicObject.set("bank_login_id", (Object)acnt.getBankLoginId());
            dynamicObject.set("bank_name", (Object)acnt.getBankName());
            dynamicObject.set("bank_short_name", (Object)acnt.getBankShortName());
            dynamicObject.set("bank_version_id", (Object)acnt.getBankVersionId());
            dynamicObject.set("country", (Object)acnt.getCountry());
            dynamicObject.set("city", (Object)acnt.getCity());
            dynamicObject.set("province", (Object)acnt.getProvince());
            dynamicObject.set("iso_currency", (Object)acnt.getCurrency());
            dynamicObject.set("has_receipt", (Object)(acnt.getHasReceipt() != false ? "1" : "0"));
            if (acnt.getHasNote() == null) {
                dynamicObject.set("has_note", (Object)"0");
            } else {
                dynamicObject.set("has_note", (Object)(acnt.getHasNote() != false ? "1" : "0"));
            }
            dynamicObject.set("enable", (Object)1);
            dynamicObject.set("branch_no", (Object)acnt.getBranchNo());
            dynamicObject.set("branch_name", (Object)acnt.getBranchName());
            dynamicObject.set("custom_id", (Object)acnt.getCustomID());
            dynamicObject.set("cnapname", (Object)acnt.getCnapname());
            dynamicObject.set("en_accname", (Object)acnt.getEnAccName());
            dynamicObject.set("swift_code", (Object)acnt.getSwiftCode());
            String accType = acnt.getAccType();
            if (StringUtils.isEmpty((String)accType) || "1".equalsIgnoreCase(accType)) {
                accType = "normal";
            }
            boolean receipt = acnt.getHasReceipt();
            String cnaps = acnt.getCnaps();
            String accNo = acnt.getAccNo();
            Boolean hasNote = acnt.getHasNote();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("bank_accType", accType);
            params.put("bank_isReceipt", receipt);
            params.put("bank_cnap", cnaps);
            params.put("bank_ecny_type", acnt.getAccEcnyType());
            params.put("bank_ecny_level", acnt.getAccEcnyLevel());
            params.put("bank_isNote", hasNote);
            if (StringUtils.isNotEmpty((String)acnt.getSwiftCode()) && !(configItemInfos = (propertyConfigs = BankBundleManager.getInstance().getBankVersionInfo(acnt.getBankVersionId()).getPropertyConfig().getAllPropertyConfigItems()).stream().filter(c -> c.isAccNo() && (c.getKey().equalsIgnoreCase("bank_swift_code") || c.getKey().endsWith("_BICCODE") || c.getKey().endsWith("_BIC_CODE"))).collect(Collectors.toList())).isEmpty()) {
                PropertyConfigItem swiftConfig = (PropertyConfigItem)configItemInfos.get(0);
                params.put(swiftConfig.getKey(), acnt.getSwiftCode());
            }
            List<DynamicObject> dynamicObjectList = this.getDynamicObjList(params, accNo);
            try (TXHandle h = TX.required();){
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]));
                this.maRepo.save(mappingTable);
            }
            filter = QFilter.of((String)"number=? and custom_id=?", (Object[])new Object[]{acnt.getAccNo(), acnt.getCustomID()});
            DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((String)BANKACNT_ENTITY, (String)selectProperties, (QFilter[])filter.toArray());
            if (dynamicObject1.getDynamicObject("bank_login") == null) {
                dynamicObject1.set("bank_login", (Object)pk);
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject1});
            }
        }
    }

    private void checkNull(String tip, DynamicObject obj, String info) {
        if (obj == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%1$s,[%2$s]\u4e0d\u5b58\u5728\u3002", (String)"BankAcntService_11", (String)"ebg-aqap-common", (Object[])new Object[0]), tip, info));
        }
    }

    private void checkArrayNull(String tip, DynamicObject[] obj, String info) {
        if (obj == null || obj.length == 0) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%1$s,[%2$s]\u4e0d\u5b58\u5728\u3002", (String)"BankAcntService_11", (String)"ebg-aqap-common", (Object[])new Object[0]), tip, info));
        }
    }

    private String dealAcntCity(String city) {
        int index = city.indexOf(ResManager.loadKDString((String)"\u5e02", (String)"BankAcntService_9", (String)"ebg-aqap-common", (Object[])new Object[0]));
        if (index > 0) {
            return city.substring(0, index);
        }
        return city;
    }

    private String dealAcntProvince(String city) {
        int index = city.indexOf(ResManager.loadKDString((String)"\u7701", (String)"BankAcntService_12", (String)"ebg-aqap-common", (Object[])new Object[0]));
        if (index > 0) {
            return city.substring(0, index);
        }
        return city;
    }

    private List<DynamicObject> getDynamicObjList(Map<String, Object> params, String accNo) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            DynamicObject dynamicObject = this.getObjectEntity(entry.getKey(), entry.getValue(), accNo);
            if (dynamicObject == null) continue;
            dynamicObjectList.add(dynamicObject);
        }
        return dynamicObjectList;
    }

    private DynamicObject getObjectEntity(String key, Object value, String accNo) {
        QFilter filter = QFilter.of((String)"attr_key=? and object_id=? and object_name=?", (Object[])new Object[]{key, accNo, "BANK_BUSINESS"});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_KEY_OBJECT_PROPERTIES, (String)"attr_value", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            dynamicObject.set("attr_value", value);
        }
        return dynamicObject;
    }

    public boolean currencySupportedByBankVersionID(String isoCurrency, String bankVersionId, String customerNo) {
        BankCurrencyRepository bankCurrencyRepository = BankCurrencyRepository.getInstance();
        BankCurrencyKey key = new BankCurrencyKey();
        key.setBankVersionId(bankVersionId);
        key.setCustomID("admin");
        key.setIsoCode(isoCurrency);
        if (!bankCurrencyRepository.existsById(key)) {
            key.setCustomID(customerNo);
            return bankCurrencyRepository.existsById(key);
        }
        return true;
    }

    private String getAddrWithProvince(String province, DynamicObject[] addrInfoArray) {
        if (StringUtils.isEmpty((String)province)) {
            return addrInfoArray[0].getString("masterid");
        }
        for (int i = 0; i < addrInfoArray.length; ++i) {
            String fullName = addrInfoArray[i].getString("fullname");
            if (!StringUtils.isNotEmpty((String)fullName) || !fullName.contains(this.dealAcntProvince(province))) continue;
            return addrInfoArray[i].getString("masterid");
        }
        return addrInfoArray[0].getString("masterid");
    }

    public boolean isForeignAccNo(String accNo) {
        BankAcntService bankAcntService = SpringContextUtil.getBean(BankAcntService.class);
        BankAcnt bankAcnt = bankAcntService.selectByAccNo(accNo);
        if (bankAcnt == null) {
            return false;
        }
        return this.isForeign(bankAcnt);
    }

    public boolean isForeign(BankAcnt bankAcnt) {
        String country = "";
        QFilter filter = QFilter.of((String)"name=?", (Object[])new Object[]{bankAcnt.getCountry()});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_country", (String)"simplespell", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            country = dynamicObject.getString("simplespell");
        }
        return StringUtils.isNotEmpty((String)country) && !"CHN".equalsIgnoreCase(country);
    }

    public String match_admindivision(BankAcnt bankAcnt) {
        String dealCity = this.dealAcntCity(bankAcnt.getCity());
        QFilter qFilter = !this.isForeign(bankAcnt) ? QFilter.like((String)"name", (String)dealCity) : QFilter.of((String)"name=?", (Object[])new Object[]{dealCity});
        DynamicObject[] addrInfoArray = BusinessDataServiceHelper.load((String)"bd_admindivision", (String)"fullname,masterid", (QFilter[])qFilter.toArray());
        this.checkArrayNull(ResManager.loadKDString((String)"\u67e5\u8be2\u82cd\u7a79\u5e73\u53f0\u884c\u653f\u533a\u5212", (String)"BankAcntService_3", (String)"ebg-aqap-common", (Object[])new Object[0]), addrInfoArray, bankAcnt.getCity());
        String addr = addrInfoArray[0].getString("masterid");
        if (addrInfoArray.length == 1) {
            return addr;
        }
        String addrWithProvince = this.getAddrWithProvince(bankAcnt.getProvince(), addrInfoArray);
        return addrWithProvince;
    }
}

