/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.model.BankAreaInfo;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

@Service
public class BankAreaCodeService {
    public static List<String> getSupportBankList() {
        return Lists.newArrayList((Object[])new String[]{"ABC_DC", "BOC_NET"});
    }

    public List<BankAreaInfo> getBankAreaInfoByBankVersionId(String bankVersion) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"aqap_bank_area_code", (String)"group,bank_version,country_area,country_area_code,aqap_area_keyword.area_key_word", (QFilter[])QFilter.of((String)"group.number = ?", (Object[])new Object[]{bankVersion}).toArray());
        if (CollectionUtil.isEmpty((Collection)collection)) {
            return Lists.newArrayList();
        }
        Map<String, List<DynamicObject>> maps = collection.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("country_area_code")));
        ArrayList<BankAreaInfo> lists = new ArrayList<BankAreaInfo>(maps.size());
        for (Map.Entry<String, List<DynamicObject>> entry : maps.entrySet()) {
            BankAreaInfo bankAreaInfo = new BankAreaInfo();
            ArrayList<String> keywords = new ArrayList<String>(16);
            String countryAreaCode = entry.getKey();
            List<DynamicObject> list = entry.getValue();
            bankAreaInfo.setCountryAreaCode(countryAreaCode);
            DynamicObject dynamicObject2 = list.get(0);
            String bank_version = dynamicObject2.getString("bank_version");
            String country_area = dynamicObject2.getString("country_area");
            bankAreaInfo.setBankVersionId(bank_version);
            bankAreaInfo.setCountryArea(country_area);
            list.forEach(s -> {
                String keyword = s.getString("aqap_area_keyword.area_key_word");
                keywords.add(keyword);
            });
            bankAreaInfo.setKeywords(keywords);
            lists.add(bankAreaInfo);
        }
        return lists;
    }
}

