/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import com.google.common.base.Preconditions;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.model.bank.login.BankLoginConfigKey;
import kd.ebg.egf.common.model.properties.ObjectProperties;
import kd.ebg.egf.common.repository.properties.ObjectPropertiesRepository;

@Service
public class BankConfigService {
    private ObjectPropertiesRepository objectPropertiesRepository = SpringContextUtil.getBean(ObjectPropertiesRepository.class);

    public static BankConfigService getInstance() {
        return SpringContextUtil.getBean(BankConfigService.class);
    }

    public String getBankConfigValue(BankLoginConfigKey key) {
        Preconditions.checkNotNull((Object)key, (Object)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BankConfigService_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        return null;
    }

    public boolean isCmbOpaCloudSaas() {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("CLOUD_TYPE", "BANK_BUSINESS", "CMB_OPA");
        boolean isSaas = objectProperties == null ? !"private".equals(System.getProperty("ebg.server.type")) : "SAAS".equalsIgnoreCase(objectProperties.getAttrValue());
        return isSaas;
    }

    public String getCmbOpaCloudTypeName() {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("CLOUD_TYPE", "BANK_BUSINESS", "CMB_OPA");
        if (objectProperties == null) {
            return !"private".equals(System.getProperty("ebg.server.type")) ? BankPropertyConfig.CLOUD_TYPE_KEY_S.loadKDString() : BankPropertyConfig.CLOUD_TYPE_KEY_N.loadKDString();
        }
        switch (objectProperties.getAttrValue()) {
            case "SAAS": {
                return BankPropertyConfig.CLOUD_TYPE_KEY_S.loadKDString();
            }
            case "PRE": {
                return BankPropertyConfig.CLOUD_TYPE_KEY_Y.loadKDString();
            }
        }
        return BankPropertyConfig.CLOUD_TYPE_KEY_N.loadKDString();
    }

    public String getCmbEcnyCloudTypeName() {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("CLOUD_TYPE", "BANK_BUSINESS", "CMB_ECNY");
        if (objectProperties == null) {
            return !"private".equals(System.getProperty("ebg.server.type")) ? BankPropertyConfig.CLOUD_TYPE_KEY_S.loadKDString() : BankPropertyConfig.CLOUD_TYPE_KEY_N.loadKDString();
        }
        switch (objectProperties.getAttrValue()) {
            case "SAAS": {
                return BankPropertyConfig.CLOUD_TYPE_KEY_S.loadKDString();
            }
            case "PRE": {
                return BankPropertyConfig.CLOUD_TYPE_KEY_Y.loadKDString();
            }
        }
        return BankPropertyConfig.CLOUD_TYPE_KEY_N.loadKDString();
    }

    public String getCloudTypeName(String bankVersionId) {
        ObjectProperties objectProperties = this.objectPropertiesRepository.findByAttrKeyAndObjectNameAndObjectID("CLOUD_TYPE", "BANK_BUSINESS", bankVersionId);
        if (objectProperties == null) {
            return !"private".equals(System.getProperty("ebg.server.type")) ? BankPropertyConfig.CLOUD_TYPE_KEY_A.loadKDString() : BankPropertyConfig.CLOUD_TYPE_KEY_F.loadKDString();
        }
        switch (objectProperties.getAttrValue()) {
            case "SAAS": {
                return BankPropertyConfig.CLOUD_TYPE_KEY_A.loadKDString();
            }
            case "PRE": {
                return BankPropertyConfig.CLOUD_TYPE_KEY_F.loadKDString();
            }
        }
        return BankPropertyConfig.CLOUD_TYPE_KEY_F.loadKDString();
    }
}

