/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.aqap.common.model.repository.CurAndFixedRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.log.EBGLogger;

@Service
public class CurAndFixedService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CurAndFixedService.class);
    private CurAndFixedRepository curAndFixedRepository;

    public CurAndFixedService(CurAndFixedRepository curAndFixedRepository) {
        this.curAndFixedRepository = curAndFixedRepository;
    }

    public static CurAndFixedService getInstance() {
        return SpringContextUtil.getBean(CurAndFixedService.class);
    }

    public void save(CurAndFixedInfo info) {
        this.curAndFixedRepository.save(info);
    }

    public List<CurAndFixedInfo> save(List<CurAndFixedInfo> infos) {
        return this.save(infos, false);
    }

    public List<CurAndFixedInfo> save(List<CurAndFixedInfo> infos, boolean insertAction) {
        infos.forEach(info -> {
            if (insertAction) {
                info.setInsertTime(LocalDateTime.now());
            }
            info.setUpdateTime(LocalDateTime.now());
        });
        return this.curAndFixedRepository.save(infos);
    }

    public void update(CurAndFixedInfo info) {
        this.curAndFixedRepository.update(info);
    }

    public List<CurAndFixedInfo> selectInfoByID(String id) {
        return this.curAndFixedRepository.selectInfoByID(id);
    }

    public List<CurAndFixedInfo> findByStatusBetweenUpdateTimeLowerSyncCount(int start, int end, LocalDateTime time, int limit) {
        return this.curAndFixedRepository.selectByStatusBetweenUpdateTimeLowerSyncCount(start, end, time, limit);
    }

    public List<CurAndFixedInfo> compareAndStateState(List<CurAndFixedInfo> curAndFixedInfos, CurAndFixedState expect, CurAndFixedState state) {
        for (CurAndFixedInfo info : curAndFixedInfos) {
            if (info.getStatus().intValue() != expect.getId()) {
                logger.info("\u5b9a\u6d3b\u4e92\u8f6c :{} \u7684\u72b6\u6001:{} \u4e0e\u9884\u671f\u7684\u72b6\u6001: {}\u4e0d\u4e00\u81f4", new Object[]{info.getId(), info.getStatus(), expect.getId()});
                return null;
            }
            info.setStatus(state.getId());
            info.setStatusMsg(state.getCnName());
            info.setStatusName(state.getEnName());
            info.setSubmitSuccessTime(LocalDateTime.now());
        }
        try {
            return this.save(curAndFixedInfos);
        }
        catch (Exception e) {
            String batchSeqId = curAndFixedInfos.get(0).getBatchSeqId();
            logger.info("\u94f6\u884c\u6279\u6b21\u53f7\u4e3a:{}", (Object)batchSeqId);
            logger.info("\u5c1d\u8bd5\u4fee\u6539\u72b6\u6001\u5931\u8d25", (Object)e);
            return null;
        }
    }

    public List<CurAndFixedInfo> selectByBatchSeqID(String batchSeqid) {
        return this.curAndFixedRepository.selectByBatchSeqID(batchSeqid);
    }

    public boolean batchSeqIDExist(String batchSeqID) {
        return this.curAndFixedRepository.countByBatchSeqID(batchSeqID) > 0L;
    }

    public List<CurAndFixedInfo> selectByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        return this.curAndFixedRepository.findByBatchSeqIDAndDetailSeqID(batchSeqID, detailSeqID);
    }

    public List<CurAndFixedInfo> selectByNotifyIdAndFixedAccNo(String id, String no) {
        return this.curAndFixedRepository.selectByNotifyIdAndFixedAcc(id, no);
    }

    public List<CurAndFixedInfo> findByTimeAndStatus(LocalDateTime localDateTime, int id) {
        return this.curAndFixedRepository.selectByStatusANdTime(localDateTime, id);
    }

    public List<CurAndFixedInfo> findByReqNbr(String no, String biz) {
        List<CurAndFixedInfo> curAndFixedInfos = this.curAndFixedRepository.selectByReqNbr(no);
        curAndFixedInfos = curAndFixedInfos.stream().filter(curAndFixedInfo -> biz.equalsIgnoreCase(curAndFixedInfo.getSubBizType())).collect(Collectors.toList());
        return curAndFixedInfos;
    }

    public List<CurAndFixedInfo> findByFixedAndCurAccNo(String fixed, String cur) {
        return this.curAndFixedRepository.selectByFixedAccNoAndCurAccNo(fixed, cur);
    }
}

