/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.ebg.aqap.common.model.InstanceReg;
import kd.ebg.aqap.common.model.repository.InstanceRegRepository;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

@Service
public class EBGNodeService {
    EBGLogger logger = EBGLogger.getInstance().getLogger(EBGNodeService.class);
    private Map<String, InstanceReg> instanceRegsCache = new ConcurrentHashMap<String, InstanceReg>(16);
    @Autowired
    private InstanceRegRepository instanceRegRepository;

    public EBGNodeService() {
        if (this.instanceRegRepository == null) {
            this.instanceRegRepository = new InstanceRegRepository();
        }
    }

    private List<String> getServerNodes() {
        ArrayList<String> nodeList = new ArrayList<String>(1);
        String appName = System.getProperty("appName");
        List serviceInfoList = ServiceInfoFactory.get().getServiceList();
        for (ServiceInfo serviceInfo : serviceInfoList) {
            if (!appName.equalsIgnoreCase(serviceInfo.getAppName())) continue;
            InstanceReg instanceReg = new InstanceReg();
            instanceReg.setAppName(serviceInfo.getAppName());
            instanceReg.setClusterName(serviceInfo.getClusterName());
            instanceReg.setHostIp(serviceInfo.getHostIp());
            instanceReg.setConfigAppName(serviceInfo.getConfigAppName());
            instanceReg.setHostName(serviceInfo.getHostName());
            instanceReg.setInstanceId(serviceInfo.getInstanceId());
            instanceReg.setMonitorPort(this.parseInt(serviceInfo.getMonitorPort()));
            instanceReg.setNodePath(serviceInfo.getNodePath());
            instanceReg.setIp(serviceInfo.getIp());
            instanceReg.setWebPort(this.parseInt(serviceInfo.getWebPort()));
            instanceReg.setStartTime(this.parseTime(serviceInfo.getStartTime()));
            instanceReg.setValid(true);
            instanceReg.setType("ebg");
            String nodeId = instanceReg.getNodeInfo();
            this.instanceRegsCache.put(nodeId, instanceReg);
            nodeList.add(nodeId);
        }
        return nodeList;
    }

    private int parseInt(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (Throwable e) {
                return 0;
            }
        }
        return 0;
    }

    private LocalDateTime parseTime(String value) {
        LocalDateTime time = LocalDateTime.now();
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                time = LocalDateTime.parse(value, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            catch (Throwable e) {
                this.logger.monitorError("string transfer to time error", e);
            }
        }
        return time;
    }

    public List<String> getInValidNodes() {
        this.instanceRegRepository.clearHistory();
        ArrayList<String> nonExistences = new ArrayList<String>(1);
        List<String> runningInstances = this.getServerNodes();
        List<InstanceReg> instanceRegs = this.instanceRegRepository.findAll();
        ArrayList<InstanceReg> updateInstanceRegs = new ArrayList<InstanceReg>(1);
        for (InstanceReg instanceReg : instanceRegs) {
            String node = instanceReg.getNodeInfo();
            boolean isValid = instanceReg.isValid();
            instanceReg.setValid(runningInstances.contains(node));
            if (!instanceReg.isValid()) {
                if (isValid) {
                    updateInstanceRegs.add(instanceReg);
                }
                nonExistences.add(node);
                continue;
            }
            if (!instanceReg.equals(this.instanceRegsCache.get(node))) {
                instanceReg.setClusterName(this.instanceRegsCache.get(node).getClusterName());
                instanceReg.setAppName(this.instanceRegsCache.get(node).getAppName());
                instanceReg.setNodePath(this.instanceRegsCache.get(node).getAppName());
                instanceReg.setMonitorPort(this.instanceRegsCache.get(node).getMonitorPort());
                instanceReg.setStartTime(this.instanceRegsCache.get(node).getStartTime());
                instanceReg.setInstanceId(this.instanceRegsCache.get(node).getInstanceId());
                instanceReg.setHostName(this.instanceRegsCache.get(node).getHostName());
                updateInstanceRegs.add(instanceReg);
            }
            runningInstances.remove(node);
        }
        for (String node : runningInstances) {
            updateInstanceRegs.add(this.instanceRegsCache.get(node));
        }
        this.instanceRegRepository.save(updateInstanceRegs);
        return nonExistences;
    }

    public boolean isRestart(String node, LocalDateTime recTime) {
        if (this.instanceRegsCache.isEmpty()) {
            this.getInValidNodes();
        }
        if (this.instanceRegsCache.containsKey(node)) {
            InstanceReg instanceReg = this.instanceRegsCache.get(node);
            return recTime != null && recTime.isBefore(instanceReg.getStartTime());
        }
        return true;
    }
}

