/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services.usekeyword;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.constant.UseMappingType;
import kd.ebg.aqap.common.model.entity.userwordkey.BankInterfaceEntity;
import kd.ebg.aqap.common.model.entity.userwordkey.UseKeyWordMappingEntity;
import kd.ebg.aqap.common.model.repository.userwordkey.BankInterfaceRepository;
import kd.ebg.aqap.common.model.repository.userwordkey.UseKeyWordMappingRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseKeyWordService {
    private static Logger logger = LoggerFactory.getLogger(UseKeyWordService.class);

    public static List<String> getSupportBankList() {
        return Arrays.asList("ICBC_CMP", "BOC_NET", "CCB_DC", "CEB_DC", "CMBC_DC", "HSB_DC", "OCBC_DC", "SPDB_DC", "ZSB_DC", "BJB_DC", "BOCOM_DC", "CIB_DC", "CMB_DC", "GXNX_CMP", "UOBSG_DC", "CMB_OPA", "CMB_WLBL");
    }

    public static String getUseByKey(String customId, String word, String interfaceName, String defaultValue, String bankVersion) {
        logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-start", new Object[]{word, interfaceName, defaultValue, bankVersion});
        if (StringUtils.isEmpty((String)word)) {
            throw new EBBaseException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7aef\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UseKeyWordService_0", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        if (!UseKeyWordService.getSupportBankList().contains(bankVersion)) {
            logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u65e0\u9700\u5339\u914d", new Object[]{word, interfaceName, defaultValue, bankVersion});
            return defaultValue;
        }
        String matchValue = "";
        BankInterfaceRepository bankInterfaceRepository = SpringContextUtil.getBean(BankInterfaceRepository.class);
        UseKeyWordMappingRepository useKeyWordMappingRepository = SpringContextUtil.getBean(UseKeyWordMappingRepository.class);
        BankInterfaceEntity bankInterfaceEntity = bankInterfaceRepository.selectByInterfaceNameAndBankVersion(interfaceName, bankVersion);
        if (bankInterfaceEntity == null) {
            logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u672a\u914d\u7f6e\u94f6\u884c\u63a5\u53e3\u6570\u636e", new Object[]{word, interfaceName, defaultValue, bankVersion});
            return defaultValue;
        }
        List<UseKeyWordMappingEntity> useKeyWordMappingList = useKeyWordMappingRepository.getKeyWordListByBankVersionAndInterfaceAndCustomId(bankVersion, interfaceName, customId);
        if (useKeyWordMappingList.isEmpty()) {
            logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u8fd4\u56de\u6570\u636e\uff1a{}-\u8be5\u94f6\u884c\u63a5\u53e3\u672a\u914d\u7f6e\u57fa\u7840\u7528\u9014\u6570\u636e-end", new Object[]{word, interfaceName, defaultValue, bankVersion, defaultValue});
            return defaultValue;
        }
        List fixList = useKeyWordMappingList.stream().filter(useKeyWord -> useKeyWord.getType() == UseMappingType.FIX.getValue()).collect(Collectors.toList());
        if (!fixList.isEmpty()) {
            matchValue = ((UseKeyWordMappingEntity)fixList.get(0)).getBankKeyWord();
            logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u8fd4\u56de\u6570\u636e\uff1a{}-\u5339\u914d\u5230\u56fa\u5b9a\u7528\u9014-end", new Object[]{word, interfaceName, defaultValue, bankVersion, matchValue});
            return matchValue;
        }
        List baseList = useKeyWordMappingList.stream().filter(useKeyWord -> useKeyWord.getType() == UseMappingType.BASE.getValue()).collect(Collectors.toList());
        for (UseKeyWordMappingEntity entity : baseList) {
            if (!word.contains(entity.getUseKeyword())) continue;
            matchValue = entity.getBankKeyWord();
            logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u8fd4\u56de\u6570\u636e\uff1a{}-\u5339\u914d\u5230\u57fa\u7840\u7528\u9014-end", new Object[]{word, interfaceName, defaultValue, bankVersion, matchValue});
            return matchValue;
        }
        List defaultList = useKeyWordMappingList.stream().filter(useKeyWord -> useKeyWord.getType() == UseMappingType.DEFAULT.getValue()).collect(Collectors.toList());
        if (!defaultList.isEmpty()) {
            matchValue = ((UseKeyWordMappingEntity)defaultList.get(0)).getBankKeyWord();
            logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u8fd4\u56de\u6570\u636e\uff1a{}-\u5339\u914d\u5230\u9ed8\u8ba4\u7528\u9014-end", new Object[]{word, interfaceName, defaultValue, bankVersion, matchValue});
            return matchValue;
        }
        if (StringUtils.isEmpty((String)defaultValue)) {
            throw new EBBaseException(ResManager.loadKDString((String)"\u7528\u9014\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"UseKeyWordService_1", (String)"ebg-aqap-common", (Object[])new Object[0]));
        }
        logger.info("\u901a\u8fc7\u5173\u952e\u5b57\u83b7\u53d6\u94f6\u884c\u7528\u9014-\u53c2\u6570\uff1a{}-{}-{}-{}-\u8fd4\u56de\u6570\u636e\uff1a{}-end", new Object[]{word, interfaceName, defaultValue, bankVersion, defaultValue});
        return defaultValue;
    }
}

