/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class BalanceReconciliationDetailRepository {
    private String ENTITY_NAME = "aqap_balance_rec_detail";
    private static String SELECT_PROPERTIES = "id,bank_version_ids,bank_login_ids,acc_no,currency,balance,statement_no,handle_num,query_num,version,sync_date,month,custom_id,submit_success_time,check_status,handle_status,status_id,status,status_name,bank_status,bank_status_msg,flag,file_path,reversed_biz_field,reversed_sys_field,operator,reason,back_status,createtime,modifytime,reserved1,reserved2,reserved3";

    public boolean updateStatus(String id, Integer statusId, String status, String statusName) {
        QFilter filter = QFilter.of((String)"id=?", (Object[])new Object[]{id});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.ENTITY_NAME, (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            return false;
        }
        dynamicObject.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        dynamicObject.set("status_id", (Object)statusId);
        dynamicObject.set("status", (Object)status);
        dynamicObject.set("status_name", (Object)statusName);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return true;
    }

    public void saveAll(List<BalanceReconciliationDetail> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            DynamicObject[] dynamicObjects = new DynamicObject[details.size()];
            for (int i = 0; i < details.size(); ++i) {
                dynamicObjects[i] = this.transDynamicObject(null, details.get(i));
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void updateAll(List<BalanceReconciliationDetail> details) {
        if (CollectionUtils.isNotEmpty(details)) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1);
            ArrayList<DynamicObject[]> ids = new ArrayList<DynamicObject[]>(1);
            HashMap<DynamicObject[], BalanceReconciliationDetail> idDetailMap = new HashMap<DynamicObject[], BalanceReconciliationDetail>(1);
            for (int i = 0; i < details.size(); ++i) {
                if (StringUtils.isNotEmpty((String)details.get(i).getId())) {
                    DynamicObject[] id = Long.valueOf(Long.parseLong(details.get(i).getId()));
                    ids.add(id);
                    idDetailMap.put(id, details.get(i));
                    continue;
                }
                dynamicObjects.add(this.transDynamicObject(null, details.get(i)));
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                DynamicObject[] dynamicObjects1;
                for (DynamicObject dynamicObject : dynamicObjects1 = BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                    BalanceReconciliationDetail detail = (BalanceReconciliationDetail)idDetailMap.get(dynamicObject.getLong("id"));
                    if (detail == null) continue;
                    dynamicObjects.add(this.transDynamicObject(dynamicObject, detail));
                    idDetailMap.remove(dynamicObject.getLong("id"));
                }
                if (idDetailMap.size() > 0) {
                    for (Map.Entry entry : idDetailMap.entrySet()) {
                        BalanceReconciliationDetail detail = (BalanceReconciliationDetail)entry.getValue();
                        dynamicObjects.add(this.transDynamicObject(null, detail));
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[dynamicObjects.size()]));
        }
    }

    public List<BalanceReconciliationDetail> findByAccNoAndCurrencyAndMonthBetween(String accNo, String currency, LocalDate startDate, LocalDate endDate) {
        ArrayList<BalanceReconciliationDetail> records = new ArrayList<BalanceReconciliationDetail>(1);
        QFilter filter = QFilter.of((String)"acc_no=? and currency=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{accNo, currency, startDate, endDate});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                records.add(this.transBalanceReconciliationDetail((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return records;
    }

    public List<BalanceReconciliationDetail> findByCurrencyAndMonthAndAccNos(String currency, LocalDate month, List<String> accNos) {
        ArrayList<BalanceReconciliationDetail> records = new ArrayList<BalanceReconciliationDetail>(1);
        QFilter[] filters = new QFilter[]{QFilter.of((String)"currency=? and sync_date=?", (Object[])new Object[]{currency, month}), new QFilter("acc_no", "in", accNos)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filters);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                records.add(this.transBalanceReconciliationDetail((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return records;
    }

    public List<BalanceReconciliationDetail> findByCurrencyAndMonthBetweenAndAccNosIn(String currency, LocalDate startMonth, LocalDate endMonth, List<String> accNos) {
        ArrayList<BalanceReconciliationDetail> records = new ArrayList<BalanceReconciliationDetail>(1);
        QFilter[] filters = new QFilter[]{QFilter.of((String)"currency=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{currency, startMonth, endMonth}), new QFilter("acc_no", "in", accNos)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filters);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                records.add(this.transBalanceReconciliationDetail((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return records;
    }

    public List<BalanceReconciliationDetail> findByAccNoAndCurrencyAndMonth(String accNo, String currency, LocalDate month) {
        ArrayList<BalanceReconciliationDetail> records = new ArrayList<BalanceReconciliationDetail>(1);
        QFilter filter = QFilter.of((String)"acc_no=? and currency=? and sync_date=? and sync_date<=?", (Object[])new Object[]{accNo, currency, month});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                records.add(this.transBalanceReconciliationDetail((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return records;
    }

    public List<BalanceReconciliationDetail> findByAccNoAndCurrencyAndAndHandleStatusMonthBetween(String accNo, String currency, String handleStatus, LocalDate startDate, LocalDate endDate) {
        ArrayList<BalanceReconciliationDetail> records = new ArrayList<BalanceReconciliationDetail>(1);
        QFilter filter = QFilter.of((String)"acc_no=? and currency=? and handle_status=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{accNo, currency, startDate, endDate});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                records.add(this.transBalanceReconciliationDetail((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return records;
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    private DynamicObject transDynamicObject(DynamicObject dynamicObject, BalanceReconciliationDetail detail) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        }
        if (StringUtils.isNotEmpty((String)detail.getId())) {
            this.setDynamicParamater(dynamicObject, "id", detail.getId());
        }
        this.setDynamicParamater(dynamicObject, "acc_no", detail.getAccNo());
        this.setDynamicParamater(dynamicObject, "bank_version_ids", detail.getBankVersionID());
        this.setDynamicParamater(dynamicObject, "bank_login_ids", detail.getBankLoginID());
        this.setDynamicParamater(dynamicObject, "custom_id", detail.getCustomID());
        if (detail.getInsertTime() == null) {
            Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            this.setDynamicParamater(dynamicObject, "createtime", insertTime);
        } else {
            this.setDynamicParamater(dynamicObject, "createtime", LocalDateUtil.localDateTime2Date((LocalDateTime)detail.getInsertTime()));
        }
        this.setDynamicParamater(dynamicObject, "modifytime", Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        this.setDynamicParamater(dynamicObject, "month", detail.getMonth());
        if (StringUtils.isNotEmpty((String)detail.getMonth())) {
            this.setDynamicParamater(dynamicObject, "sync_date", LocalDateUtil.localDate2Date((LocalDate)LocalDateUtil.parserMonth((String)detail.getMonth())));
        }
        this.setDynamicParamater(dynamicObject, "currency", detail.getCurrency());
        this.setDynamicParamater(dynamicObject, "balance", detail.getBalance());
        this.setDynamicParamater(dynamicObject, "statement_no", detail.getStatementNo());
        if (detail.getSubmitSuccessTime() != null) {
            this.setDynamicParamater(dynamicObject, "submit_success_time", Date.from(detail.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant()));
        }
        this.setDynamicParamater(dynamicObject, "check_status", detail.getCheckStatus());
        this.setDynamicParamater(dynamicObject, "handle_status", detail.getHandleStatus());
        this.setDynamicParamater(dynamicObject, "status_id", detail.getStatusId());
        this.setDynamicParamater(dynamicObject, "status", detail.getStatus());
        this.setDynamicParamater(dynamicObject, "status_name", detail.getStatusName());
        this.setDynamicParamater(dynamicObject, "bank_status", detail.getBankStatus());
        this.setDynamicParamater(dynamicObject, "bank_status_msg", detail.getBankStatusMsg());
        this.setDynamicParamater(dynamicObject, "flag", detail.getFlag());
        this.setDynamicParamater(dynamicObject, "file_path", detail.getFilePath());
        this.setDynamicParamater(dynamicObject, "reserved1", detail.getReserved1());
        this.setDynamicParamater(dynamicObject, "reserved2", detail.getReserved2());
        this.setDynamicParamater(dynamicObject, "reserved3", detail.getReserved3());
        this.setDynamicParamater(dynamicObject, "reversed_biz_field", detail.getReversedBizField());
        this.setDynamicParamater(dynamicObject, "reversed_sys_field", detail.getReversedSysField());
        this.setDynamicParamater(dynamicObject, "version", detail.getVersion());
        this.setDynamicParamater(dynamicObject, "handle_num", detail.getHandleNum());
        this.setDynamicParamater(dynamicObject, "query_num", detail.getQueryNum());
        this.setDynamicParamater(dynamicObject, "operator", detail.getOperator());
        this.setDynamicParamater(dynamicObject, "reason", detail.getReason());
        this.setDynamicParamater(dynamicObject, "back_status", detail.getBackStatus());
        return dynamicObject;
    }

    private BalanceReconciliationDetail transBalanceReconciliationDetail(DynamicObject dynamicObject) {
        BalanceReconciliationDetail result = new BalanceReconciliationDetail();
        result.setId(dynamicObject.getString("id"));
        result.setAccNo(dynamicObject.getString("acc_no"));
        result.setBankVersionID(dynamicObject.getString("bank_version_ids"));
        result.setBankLoginID(dynamicObject.getString("bank_login_ids"));
        result.setCustomID(dynamicObject.getString("custom_id"));
        LocalDateTime insertTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("createtime"));
        result.setInsertTime(insertTime);
        LocalDateTime updateTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("modifytime"));
        result.setUpdateTime(updateTime);
        LocalDate syncDate = LocalDateUtil.date2LocalDate((Date)dynamicObject.getDate("sync_date"));
        result.setSyncDate(syncDate);
        result.setMonth(dynamicObject.getString("month"));
        result.setCurrency(dynamicObject.getString("currency"));
        result.setBalance(dynamicObject.getString("balance"));
        result.setStatementNo(dynamicObject.getString("statement_no"));
        String submitSuccessTimeStr = dynamicObject.getString("submit_success_time");
        if (StringUtils.isNotEmpty((String)submitSuccessTimeStr)) {
            result.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)submitSuccessTimeStr));
        } else {
            result.setSubmitSuccessTime(null);
        }
        result.setCheckStatus(dynamicObject.getString("check_status"));
        result.setHandleStatus(dynamicObject.getString("handle_status"));
        result.setStatusId(dynamicObject.getInt("status_id"));
        result.setStatus(dynamicObject.getString("status"));
        result.setStatusName(dynamicObject.getString("status_name"));
        result.setBankStatus(dynamicObject.getString("bank_status"));
        result.setBankStatusMsg(dynamicObject.getString("bank_status_msg"));
        result.setFlag(dynamicObject.getString("flag"));
        result.setFilePath(dynamicObject.getString("file_path"));
        result.setReserved1(dynamicObject.getString("reserved1"));
        result.setReserved2(dynamicObject.getString("reserved2"));
        result.setReserved3(dynamicObject.getString("reserved3"));
        result.setReversedBizField(dynamicObject.getString("reversed_biz_field"));
        result.setReversedSysField(dynamicObject.getString("reversed_sys_field"));
        result.setVersion(dynamicObject.getInt("version"));
        result.setHandleNum(dynamicObject.getInt("handle_num"));
        result.setQueryNum(dynamicObject.getInt("query_num"));
        result.setOperator(dynamicObject.getString("operator"));
        result.setReason(dynamicObject.getString("reason"));
        result.setBackStatus(dynamicObject.getString("back_status"));
        return result;
    }
}

