/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.Transactional;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageImpl;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

@Component
public class DetailSyncRecordRepository {
    private String DETAIL_SYNC_RECORD_ENTITY = "aqap_detail_sync_record";
    private String SELECT_PROPERTIES = "id,createtime,modifytime,acc_no,bank_name,custom_id,detail_count,sync_date,enable,sync_count,currency,compensation_count,is_completed,compensation_detail";

    public Page<DynamicObject> findByQFilters(List<QFilter> rowQFilters, Pageable pageRequest) {
        PageImpl result = new PageImpl();
        ArrayList<DynamicObject> infos = new ArrayList<DynamicObject>(1);
        int page = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        Sort sort = pageRequest.getSort();
        String orderBy = ((Sort.Order)sort.toList().get(0)).getProperty().replace(",id desc", "");
        if ("id".equals(orderBy)) {
            orderBy = "sync_date desc";
        }
        Iterator<QFilter> iterator = rowQFilters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = iterator.next();
            String property = qFilter.getProperty();
            if (!property.startsWith("bank_version.") && !property.startsWith("bank_acnt.")) continue;
            iterator.remove();
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])rowQFilters.toArray(new QFilter[16]), (String)orderBy, (int)page, (int)pageSize);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.DETAIL_SYNC_RECORD_ENTITY, (String)"id", (QFilter[])rowQFilters.toArray(new QFilter[16]), (String)"");){
            if (dynamicObjects != null) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    infos.add(dynamicObjects[i]);
                }
                long total = ds.count("id", Boolean.FALSE.booleanValue());
                result = new PageImpl(infos, pageRequest, total);
            }
        }
        return result;
    }

    public List<DetailSyncRecord> findByCustomIDAndAccNoAndSyncDateBetween(String customID, String accNo, LocalDate syncDateStart, LocalDate syncDateEnd) {
        ArrayList<DetailSyncRecord> detailSyncRecordList = new ArrayList<DetailSyncRecord>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{customID, accNo, syncDateStart, syncDateEnd});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                detailSyncRecordList.add(this.transDetailSyncRecord((DynamicObject)dynamicObjects.get(i)));
            }
        }
        return detailSyncRecordList;
    }

    public List<DetailSyncRecord> findByIdIn(List<Long> ids) {
        ArrayList<DetailSyncRecord> detailSyncRecordList = new ArrayList<DetailSyncRecord>(16);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])new QFilter("id", "in", ids).toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailSyncRecordList.add(this.transDetailSyncRecord(dynamicObjects[i]));
            }
        }
        return detailSyncRecordList;
    }

    public List<DetailSyncRecord> findByCustomIDAndAccNoAndCurrencyAndSyncDateBetween(String customID, String accNo, String currency, LocalDate syncDateStart, LocalDate syncDateEnd) {
        ArrayList<DetailSyncRecord> detailSyncRecordList = new ArrayList<DetailSyncRecord>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and currency = ? and sync_date>=? and sync_date<=?", (Object[])new Object[]{customID, accNo, currency, syncDateStart, syncDateEnd});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                detailSyncRecordList.add(this.transDetailSyncRecord(dynamicObjects[i]));
            }
        }
        return detailSyncRecordList;
    }

    public DynamicObject[] loadByCustomIDAndAccNoAndSyncDateBetween(String customID, String accNo, String currency, LocalDate syncDateStart, LocalDate syncDateEnd) {
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and currency=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{customID, accNo, currency, syncDateStart, syncDateEnd});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public DynamicObject[] loadByCustomIDAndAccNoAndCurrencyAndSyncDateBetween(String customID, String accNo, String currency, LocalDate syncDateStart, LocalDate syncDateEnd) {
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and currency = ? and sync_date>=? and sync_date<=?", (Object[])new Object[]{customID, accNo, currency, syncDateStart, syncDateEnd});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public int countByCustomIDAndAccNoAndSyncDateBetweenAndSyncCountLessThan(String customID, String accNo, String currency, LocalDate syncDateStart, LocalDate syncDateEnd, int syncCount) {
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and currency = ? and sync_date>=? and sync_date<=? and sync_count<?", (Object[])new Object[]{customID, accNo, currency, syncDateStart, syncDateEnd, syncCount});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)"count(1) as my_count", (QFilter[])filter.toArray());
        return dynamicObject.getInt("my_count");
    }

    public int countByCustomIDAndAccNoAndSyncDateBetween(String customID, String accNo, String currency, LocalDate syncDateStart, LocalDate syncDateEnd) {
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and currency=? and sync_date>=? and sync_date<=?", (Object[])new Object[]{customID, accNo, currency, syncDateStart, syncDateEnd});
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)"count(1) as my_count", (QFilter[])filter.toArray());
        return dynamicObject.getInt("my_count");
    }

    public void deleteByCustomIDAndAccNoAndSyncDateBetween(String customID, String accNo, String currency, LocalDate syncDateStart, LocalDate syncDateEnd) {
        DynamicObject[] detailSyncRecords = this.loadByCustomIDAndAccNoAndSyncDateBetween(customID, accNo, currency, syncDateStart, syncDateEnd);
        if (detailSyncRecords != null && detailSyncRecords.length > 0) {
            for (DynamicObject dynamicObject : detailSyncRecords) {
                dynamicObject.set("enable", (Object)0);
            }
            SaveServiceHelper.save((DynamicObject[])detailSyncRecords);
        }
    }

    public List<DetailSyncRecord> findByCustomIDAndAccNoAndSyncDate(String customID, String accNo, LocalDate date) {
        ArrayList<DetailSyncRecord> detailSyncRecordList = new ArrayList<DetailSyncRecord>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and sync_date=?", (Object[])new Object[]{customID, accNo, date});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                detailSyncRecordList.add(this.transDetailSyncRecord(dynamicObject));
            }
        }
        return detailSyncRecordList;
    }

    public List<DetailSyncRecord> findByCustomIDAndAccNoAndCurrencyAndSyncDate(String customID, String accNo, String currency, LocalDate date) {
        ArrayList<DetailSyncRecord> detailSyncRecordList = new ArrayList<DetailSyncRecord>(1);
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and currency = ? and sync_date=?", (Object[])new Object[]{customID, accNo, currency, date});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                detailSyncRecordList.add(this.transDetailSyncRecord(dynamicObject));
            }
        }
        return detailSyncRecordList;
    }

    @Transactional
    public void save(DetailSyncRecord syncRecord) {
        String customID = syncRecord.getCustomID();
        String accNo = syncRecord.getAccNo();
        LocalDate date = syncRecord.getSyncDate();
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and sync_date=?", (Object[])new Object[]{customID, accNo, date});
        boolean isExist = QueryServiceHelper.exists((String)this.DETAIL_SYNC_RECORD_ENTITY, (QFilter[])filter.toArray());
        if (isExist) {
            this.update(syncRecord);
        } else {
            DynamicObject dynamicObject = this.packDetailSyncRecord(syncRecord, null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public void saveAll(List<DetailSyncRecord> syncRecords) {
        if (!CollectionUtil.isEmpty(syncRecords)) {
            DynamicObject[] dynamicObjects = new DynamicObject[syncRecords.size()];
            for (int i = 0; i < syncRecords.size(); ++i) {
                dynamicObjects[i] = this.packDetailSyncRecord(syncRecords.get(i), null);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    public void update(DetailSyncRecord syncRecord) {
        String customID = syncRecord.getCustomID();
        String accNo = syncRecord.getAccNo();
        LocalDate date = syncRecord.getSyncDate();
        QFilter filter = QFilter.of((String)"custom_id=? and acc_no=? and sync_date=?", (Object[])new Object[]{customID, accNo, date});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        dynamicObject = this.packDetailSyncRecord(syncRecord, dynamicObject);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private DetailSyncRecord transDetailSyncRecord(DynamicObject dynamicObject) {
        DetailSyncRecord detailSyncRecord = new DetailSyncRecord();
        detailSyncRecord.setId(dynamicObject.getString("id"));
        detailSyncRecord.setAccNo(dynamicObject.getString("acc_no"));
        detailSyncRecord.setCustomID(dynamicObject.getString("custom_id"));
        LocalDateTime insertTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("createtime"));
        detailSyncRecord.setInsertTime(insertTime);
        LocalDateTime updateTime = DTFactoryUtil.parseDateTime((String)dynamicObject.getString("modifytime"));
        detailSyncRecord.setUpdateTime(updateTime);
        LocalDate syncDate = DTFactoryUtil.parseDate((String)dynamicObject.getString("sync_date"));
        detailSyncRecord.setSyncDate(syncDate);
        detailSyncRecord.setEnable(dynamicObject.getInt("enable"));
        detailSyncRecord.setSyncCount(dynamicObject.getInt("sync_count"));
        detailSyncRecord.setDetailCount(dynamicObject.getInt("detail_count"));
        detailSyncRecord.setCurrency(dynamicObject.getString("currency"));
        detailSyncRecord.setBankName(dynamicObject.getString("bank_name"));
        detailSyncRecord.setIsCompleted(dynamicObject.getInt("is_completed"));
        detailSyncRecord.setCompensationCount(dynamicObject.getInt("compensation_count"));
        detailSyncRecord.setCompensationDetail(dynamicObject.getString("compensation_detail"));
        return detailSyncRecord;
    }

    private DynamicObject packDetailSyncRecord(DetailSyncRecord syncRecord, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.DETAIL_SYNC_RECORD_ENTITY);
        }
        dynamicObject.set("id", (Object)syncRecord.getId());
        dynamicObject.set("acc_no", (Object)syncRecord.getAccNo());
        Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("createtime", (Object)insertTime);
        dynamicObject.set("modifytime", (Object)insertTime);
        dynamicObject.set("custom_id", (Object)syncRecord.getCustomID());
        dynamicObject.set("detail_count", (Object)syncRecord.getDetailCount());
        Date syncDate = Date.from(syncRecord.getSyncDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        dynamicObject.set("sync_date", (Object)syncDate);
        dynamicObject.set("enable", (Object)syncRecord.getEnable());
        dynamicObject.set("sync_count", (Object)syncRecord.getSyncCount());
        dynamicObject.set("currency", (Object)syncRecord.getCurrency());
        dynamicObject.set("is_completed", (Object)syncRecord.getIsCompleted());
        dynamicObject.set("bank_name", (Object)syncRecord.getBankName());
        dynamicObject.set("compensation_detail", (Object)syncRecord.getCompensationDetail());
        return dynamicObject;
    }

    public DynamicObject[] loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.DETAIL_SYNC_RECORD_ENTITY, (String)"id, custom_id", (QFilter[])filter.toArray());
        return dynamicObjects;
    }
}

