/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.aqap.common.model.transform.BatchUpdateCollector;
import kd.ebg.aqap.common.model.transform.PaymentTransFormer;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class FinancingRepository {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(FinancingRepository.class);
    private static final String DUPLICATE_ENTRY_INFO = "Duplicate entry";
    private static final String DUPLICATE_KEY_DETAIL_BIZ_NO = "FDETAIL_BIZ_NO";
    private String ENTITY_KEY = "aqap_bd_financing";
    public static final String SELECT_ALL_PROPERTIES = "id,ebg_id,createtime,modifytime,submit_success_time,custom_id,version,bank_version_id,bank_login_id,acc_no,financing_type,acc_name,area_code,currency,batch_seq_id,detail_biz_no,detail_seq_id,buy_biz_no,product_code,product_name,amount,back_amount,number,price,value_date,expire_date,profit_amt,profit_rate,redeem_rate,back_bank_status,back_error_msg,error_msg,status,status_msg,bank_status,bank_status_msg,csh_dra_flag,bank_financing_seq_id,bank_batch_seq_id,response_serial_no,redeem_flag,securities_accno,roll_date,redeem_way,foll_flag,reserved1,reserved2,reserved3,reserved4,reserved5,reversed_biz_field,reversed_sys_field,sync_count,last_sync_time";

    public boolean existsByBatchSeqID(String batchSeqID) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        return QueryServiceHelper.exists((String)this.ENTITY_KEY, (QFilter[])filter.toArray());
    }

    public boolean existsByDetailBizNoAndBackBankStatus(String detailBizNo, String backBankStatus) {
        QFilter filter = QFilter.of((String)"detail_biz_no = ? and back_bank_status = ?", (Object[])new Object[]{detailBizNo, backBankStatus});
        return QueryServiceHelper.exists((String)this.ENTITY_KEY, (QFilter[])filter.toArray());
    }

    public List<FinancingInfo> findByBatchSeqID(String batchSeqID) {
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(16);
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> findByCreateTimeBeforeAndStatusAndEbgId(LocalDateTime time, int statusId, String ebgId) {
        DynamicObject[] dynamicObjects;
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(16);
        QFilter filter = QFilter.of((String)"createtime > ? and status = ? and ebg_id = ?", (Object[])new Object[]{time, String.valueOf(statusId), ebgId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> findByStatusAndEbgId(int statusId, String ebgId) {
        DynamicObject[] dynamicObjects;
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(16);
        QFilter filter = QFilter.of((String)"status = ? and ebg_id = ?", (Object[])new Object[]{String.valueOf(statusId), ebgId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> findByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and detail_seq_id = ?", (Object[])new Object[]{batchSeqID, detailSeqID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIdNot(int status, LocalDateTime dateTime, LocalDateTime insertTimeLimit, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(1);
        QFilter filter = QFilter.of((String)"status = ? and modifytime < ? and createtime > ? and ebg_id <> ?", (Object[])new Object[]{String.valueOf(status), dateTime, insertTimeLimit, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> findByStatusBetweenAndUpdateTimeLessThanAndEbgIDAndSyncCountLessThanOrderByUpdateTimeAsc(int start, int end, LocalDateTime time, String ebgID, int limitNum) {
        DynamicObject[] dynamicObjects;
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(1);
        QFilter filter = QFilter.of((String)"status >= ? and status <= ? and modifytime < ? and ebg_id = ? and sync_count < ?", (Object[])new Object[]{String.valueOf(start), String.valueOf(end), time, ebgID, limitNum});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)"modifytime asc")) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> findByStatusBetweenAndUpdateTimeLessThanAndEbgIDNotAndSyncCountLessThan(int start, int end, LocalDateTime date, String ebgID, int limitNum) {
        DynamicObject[] dynamicObjects;
        ArrayList<FinancingInfo> infos = new ArrayList<FinancingInfo>(1);
        QFilter filter = QFilter.of((String)"status >= ? and status <= ? and ebg_id <> ? and modifytime < ? and sync_count < ?", (Object[])new Object[]{String.valueOf(start), String.valueOf(end), ebgID, date, limitNum});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_KEY, (String)SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            infos.add(this.transFinancingInfo(dynamicObject));
        }
        return infos;
    }

    public List<FinancingInfo> save(List<FinancingInfo> infos) {
        ArrayList<FinancingInfo> insertList = new ArrayList<FinancingInfo>(1);
        ArrayList<FinancingInfo> updateList = new ArrayList<FinancingInfo>(1);
        for (FinancingInfo info : infos) {
            String id = info.getId();
            if (QueryServiceHelper.exists((String)this.ENTITY_KEY, (Object)id)) {
                updateList.add(info);
                continue;
            }
            insertList.add(info);
        }
        this.insertAll(insertList);
        this.updateAll(updateList);
        return infos;
    }

    public void insertAll(List<FinancingInfo> infos) {
        if (infos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            for (FinancingInfo info : infos) {
                dynamicObjectList.add(this.packDynamicObject(null, info));
            }
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[infos.size()]);
            this.logger.info("\u5f85\u63d2\u5165\u7406\u8d22\u8bb0\u5f55\uff1a{}\u6761", (Object)infos.size());
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)objs[i];
                    infos.get(i).setId(dynamicObject.getString("id"));
                }
                this.logger.info("\u7406\u8d22\u8bb0\u5f55\u63d2\u5165\u5b8c\u6210");
            }
            catch (Exception e) {
                this.logger.error("\u7406\u8d22\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                if (e.getMessage().contains(DUPLICATE_ENTRY_INFO) && e.getMessage().contains(DUPLICATE_KEY_DETAIL_BIZ_NO)) {
                    throw EBExceiptionUtil.duplicateException((String)this.getDuplicateKeyDetailBizNo(e.getMessage(), ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u7406\u8d22\u6307\u4ee4\u4e2d\uff0c\u68c0\u67e5\u5230\u5728\u9014\u6216\u4ea4\u6613\u6210\u529f\u7684\u4e1a\u52a1\u53f7\u3002", (String)"FinancingRepository_0", (String)"ebg-aqap-common", (Object[])new Object[0])), (Throwable)e);
                }
                throw EBExceiptionUtil.dbSaveException((String)ResManager.loadKDString((String)"\u7406\u8d22\u8bb0\u5f55\u5165\u5e93\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\u3002", (String)"FinancingRepository_1", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public synchronized void updateAll(List<FinancingInfo> infos) {
        if (infos.size() > 0) {
            try {
                this.logger.info("\u5f85\u66f4\u65b0\u7406\u8d22\u8bb0\u5f55\uff1a{}\u6761", (Object)infos.size());
                for (FinancingInfo info : infos) {
                    ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_KEY);
                    dynamicObjectList.add(this.packDynamicObject(dynamicObject, info));
                    ArrayList<FinancingInfo> financingInfoList = new ArrayList<FinancingInfo>(1);
                    financingInfoList.add(info);
                    DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
                    this.updateWithVersion(dynamicObjects, financingInfoList);
                }
                this.logger.info("\u7406\u8d22\u8bb0\u5f55\u66f4\u65b0\u5b8c\u6210");
            }
            catch (Exception e) {
                this.logger.error("\u7406\u8d22\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                if (e.getMessage().contains(DUPLICATE_ENTRY_INFO) && e.getMessage().contains(DUPLICATE_KEY_DETAIL_BIZ_NO)) {
                    throw EBExceiptionUtil.duplicateException((String)this.getDuplicateKeyDetailBizNo(e.getMessage(), ResManager.loadKDString((String)"\u66f4\u65b0\u7406\u8d22\u8bb0\u5f55\u65f6\uff0c\u68c0\u67e5\u5230\u5728\u9014\u6216\u4ea4\u6613\u6210\u529f\u7684\u4e1a\u52a1\u53f7\u3002", (String)"FinancingRepository_2", (String)"ebg-aqap-common", (Object[])new Object[0])), (Throwable)e);
                }
                throw EBExceiptionUtil.dbSaveException((String)ResManager.loadKDString((String)"\u7406\u8d22\u8bb0\u5f55\u5165\u5e93\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\u3002", (String)"FinancingRepository_3", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private DynamicObject packDynamicObject(DynamicObject dynamicObject, FinancingInfo info) {
        Date time;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_KEY);
        } else {
            this.setDynamicParamater(dynamicObject, "id", Long.parseLong(info.getId()));
        }
        if (info.getCreateTime() != null) {
            dynamicObject.set("createtime", (Object)Date.from(info.getCreateTime().atZone(ZoneId.systemDefault()).toInstant()));
        } else {
            dynamicObject.set("createtime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (info.getModifyTime() != null) {
            dynamicObject.set("modifytime", (Object)Date.from(info.getModifyTime().atZone(ZoneId.systemDefault()).toInstant()));
        } else {
            dynamicObject.set("modifytime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (info.getSubmitSuccessTime() != null) {
            time = Date.from(info.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submit_success_time", (Object)time);
        }
        if (info.getLastSyncTime() != null) {
            time = Date.from(info.getLastSyncTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("last_sync_time", (Object)time);
        }
        dynamicObject.set("custom_id", (Object)info.getCustomId());
        if (info.getVersion() == null) {
            info.setVersion(1);
        }
        dynamicObject.set("version", (Object)info.getVersion());
        if (info.getSyncCount() == null) {
            info.setSyncCount(0);
        }
        dynamicObject.set("sync_count", (Object)info.getSyncCount());
        dynamicObject.set("ebg_id", (Object)info.getEbgId());
        dynamicObject.set("bank_version_id", (Object)info.getBankVersionID());
        dynamicObject.set("bank_login_id", (Object)info.getBankLoginID());
        dynamicObject.set("acc_no", (Object)info.getAccNo());
        dynamicObject.set("acc_name", (Object)info.getAccName());
        dynamicObject.set("financing_type", (Object)info.getFinancingType());
        dynamicObject.set("area_code", (Object)info.getAreaCode());
        dynamicObject.set("currency", (Object)info.getCurrency());
        dynamicObject.set("batch_seq_id", (Object)info.getBatchSeqId());
        if (StringUtils.isEmpty((String)info.getDetailBizNo())) {
            info.setDetailBizNo(info.getDetailSeqID());
        }
        dynamicObject.set("detail_biz_no", (Object)info.getDetailBizNo());
        dynamicObject.set("detail_seq_id", (Object)info.getDetailSeqID());
        dynamicObject.set("buy_biz_no", (Object)info.getBuyBizNo());
        dynamicObject.set("product_code", (Object)info.getProductCode());
        dynamicObject.set("product_name", (Object)info.getProductName());
        this.setDynamicParamater(dynamicObject, "amount", info.getAmount());
        this.setDynamicParamater(dynamicObject, "back_amount", info.getBackAmount());
        dynamicObject.set("number", (Object)info.getNumber());
        dynamicObject.set("price", (Object)info.getPrice());
        if (info.getValueDate() != null) {
            dynamicObject.set("value_date", (Object)Date.from(info.getValueDate().atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (info.getExpireDate() != null) {
            dynamicObject.set("expire_date", (Object)Date.from(info.getExpireDate().atZone(ZoneId.systemDefault()).toInstant()));
        }
        dynamicObject.set("profit_amt", (Object)info.getProfitAmt());
        dynamicObject.set("profit_rate", (Object)info.getProfitRate());
        dynamicObject.set("redeem_rate", (Object)info.getRedeemRate());
        if (info.getStatus().intValue() == FinancingState.FAIL.getId()) {
            info.setBackBankStatus(info.getDetailSeqID());
        } else {
            info.setBackBankStatus("1");
        }
        dynamicObject.set("back_bank_status", (Object)info.getBackBankStatus());
        dynamicObject.set("back_error_msg", (Object)info.getBackErrorMsg());
        dynamicObject.set("error_msg", (Object)info.getErrorMsg());
        dynamicObject.set("status", (Object)info.getStatus());
        dynamicObject.set("status_msg", (Object)info.getStatusMsg());
        dynamicObject.set("bank_status", (Object)info.getBankStatus());
        dynamicObject.set("bank_status_msg", (Object)info.getBankStatusMsg());
        dynamicObject.set("csh_dra_flag", (Object)info.getCshDraFlag());
        dynamicObject.set("bank_financing_seq_id", (Object)info.getBankFinancingSeqId());
        dynamicObject.set("bank_batch_seq_id", (Object)info.getBankBatchSeqId());
        dynamicObject.set("response_serial_no", (Object)info.getEbSeqId());
        dynamicObject.set("redeem_flag", (Object)info.getRedeemFlag());
        dynamicObject.set("securities_accno", (Object)info.getSecuritiesAccNo());
        dynamicObject.set("roll_date", (Object)info.getRollDate());
        dynamicObject.set("redeem_way", (Object)info.getRedeemWay());
        dynamicObject.set("foll_flag", (Object)info.getFollFlag());
        dynamicObject.set("reserved1", (Object)info.getReserved1());
        dynamicObject.set("reserved2", (Object)info.getReserved2());
        dynamicObject.set("reserved3", (Object)info.getReserved3());
        dynamicObject.set("reserved4", (Object)info.getReserved4());
        dynamicObject.set("reserved5", (Object)info.getReserved5());
        dynamicObject.set("reversed_sys_field", (Object)info.getReversedSysField());
        dynamicObject.set("reversed_biz_field", (Object)info.getReversedBizField());
        return dynamicObject;
    }

    private FinancingInfo transFinancingInfo(DynamicObject dynamicObject) {
        FinancingInfo info = new FinancingInfo();
        info.setId(dynamicObject.getString("id"));
        String time = dynamicObject.getString("createtime");
        if (StringUtils.isNotEmpty((String)time)) {
            info.setCreateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (StringUtils.isNotEmpty((String)(time = dynamicObject.getString("modifytime")))) {
            info.setModifyTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (StringUtils.isNotEmpty((String)(time = dynamicObject.getString("submit_success_time")))) {
            info.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (StringUtils.isNotEmpty((String)(time = dynamicObject.getString("last_sync_time")))) {
            info.setLastSyncTime(DTFactoryUtil.parseDateTime((String)time));
        }
        info.setCustomId(dynamicObject.getString("custom_id"));
        info.setSyncCount(dynamicObject.getInt("sync_count"));
        info.setEbSeqId(dynamicObject.getString("ebg_id"));
        info.setVersion(dynamicObject.getInt("version"));
        info.setBankVersionID(dynamicObject.getString("bank_version_id"));
        info.setBankLoginID(dynamicObject.getString("bank_login_id"));
        info.setAccNo(dynamicObject.getString("acc_no"));
        info.setAccName(dynamicObject.getString("acc_name"));
        info.setFinancingType(dynamicObject.getString("financing_type"));
        info.setAreaCode(dynamicObject.getString("area_code"));
        info.setCurrency(dynamicObject.getString("currency"));
        info.setBatchSeqId(dynamicObject.getString("batch_seq_id"));
        info.setDetailBizNo(dynamicObject.getString("detail_biz_no"));
        info.setDetailSeqID(dynamicObject.getString("detail_seq_id"));
        info.setBuyBizNo(dynamicObject.getString("buy_biz_no"));
        info.setProductCode(dynamicObject.getString("product_code"));
        info.setProductName(dynamicObject.getString("product_name"));
        info.setAmount(dynamicObject.getString("amount"));
        info.setBackAmount(dynamicObject.getString("back_amount"));
        info.setNumber(dynamicObject.getString("number"));
        info.setPrice(dynamicObject.getString("price"));
        time = dynamicObject.getString("value_date");
        if (StringUtils.isNotEmpty((String)time)) {
            info.setValueDate(DTFactoryUtil.parseDateTime((String)time));
        }
        if (StringUtils.isNotEmpty((String)(time = dynamicObject.getString("expire_date")))) {
            info.setExpireDate(DTFactoryUtil.parseDateTime((String)time));
        }
        info.setProfitAmt(dynamicObject.getString("profit_amt"));
        info.setProfitRate(dynamicObject.getString("profit_rate"));
        info.setRedeemRate(dynamicObject.getString("redeem_rate"));
        info.setBackBankStatus(dynamicObject.getString("back_bank_status"));
        info.setBackErrorMsg(dynamicObject.getString("back_error_msg"));
        info.setErrorMsg(dynamicObject.getString("error_msg"));
        info.setStatus(dynamicObject.getInt("status"));
        info.setStatusMsg(dynamicObject.getString("status_msg"));
        info.setBankStatus(dynamicObject.getString("bank_status"));
        info.setBankStatusMsg(dynamicObject.getString("bank_status_msg"));
        info.setCshDraFlag(dynamicObject.getString("csh_dra_flag"));
        info.setBankFinancingSeqId(dynamicObject.getString("bank_financing_seq_id"));
        info.setBankBatchSeqId(dynamicObject.getString("bank_batch_seq_id"));
        info.setEbSeqId(dynamicObject.getString("response_serial_no"));
        info.setRedeemFlag(dynamicObject.getString("redeem_flag"));
        info.setSecuritiesAccNo(dynamicObject.getString("securities_accno"));
        info.setRollDate(dynamicObject.getString("roll_date"));
        info.setRedeemWay(dynamicObject.getString("redeem_way"));
        info.setFollFlag(dynamicObject.getString("foll_flag"));
        info.setReserved1(dynamicObject.getString("reserved1"));
        info.setReserved2(dynamicObject.getString("reserved2"));
        info.setReserved3(dynamicObject.getString("reserved3"));
        info.setReserved4(dynamicObject.getString("reserved4"));
        info.setReserved5(dynamicObject.getString("reserved5"));
        info.setReversedBizField(dynamicObject.getString("reversed_biz_field"));
        info.setReversedSysField(dynamicObject.getString("reversed_sys_field"));
        return info;
    }

    public void updateWithVersion(DynamicObject[] dynamicObjects, List<FinancingInfo> infos) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet((Object[])dynamicObjects, true);
        BatchUpdateCollector batchUpdateCollector = PaymentTransFormer.getInstance().getBatchUpdateCollector(saveDataSet);
        TXHandle h = TX.required();
        try {
            int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), batchUpdateCollector.getListParas());
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != 0) continue;
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u7406\u8d22\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u5f85\u66f4\u65b0\u6570\u636e\u4e0e\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u4e0d\u5339\u914d\u3002", (String)"FinancingRepository_4", (String)"ebg-aqap-common", (Object[])new Object[0]));
            }
            for (FinancingInfo info : infos) {
                info.setVersion(info.getVersion() + 1);
            }
        }
        catch (Throwable ex) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable result) {}
            }
        }
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    private String getDuplicateKeyDetailBizNo(String errorMsg, String tips) {
        String result = tips;
        int startIndex = errorMsg.indexOf(DUPLICATE_ENTRY_INFO) + DUPLICATE_ENTRY_INFO.length();
        int endIndex = errorMsg.indexOf(DUPLICATE_KEY_DETAIL_BIZ_NO);
        if (startIndex > 0 && endIndex > 0 && endIndex > startIndex) {
            String msg = errorMsg.substring(startIndex, endIndex);
            String[] items = msg.split(" ");
            StringBuilder sb = new StringBuilder();
            for (String item : items) {
                int index = item.lastIndexOf(45);
                if (index <= 0) continue;
                item = item.substring(0, index);
                sb.append(tips).append('[').append(item.replaceAll("'", "")).append(']');
                break;
            }
            result = sb.toString();
        }
        return result;
    }
}

