/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.aqap.common.model.transform.LinkpaymentTransFormer;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

@Component
public class LinkPaymentInfoRepository {
    private String ENTITY = "aqap_bd_linkpaymentinfo";
    private String SELECT_ALL_PROPERTIES = "id,version,amount,bank_batch_seq_id,bank_status,bank_status_msg,batch_biz_no,batch_seq_id,biz_type,booking_date,child_acnt1,child_acnt2,child_acnt3,child_acnt4,child_acnt5,create_time,currency,custom_id,desc_msg,detail_biz_no,detail_seq_id,eb_seq_id,eb_status,eb_status_msg,ebg_id,email,fee_type,force_manual,insert_batch_seq,mobile,parent_acnt,payee_acc_name,payee_acc_no,payee_area_code,payee_bank_addr,payee_bank_name,payee_city,payee_cnaps_code,payee_country,payee_province,payee_swift_code,payee_type,sub_biz_type,total_amount,total_count,update_time,urgent,use_code,use_msg,verify_field,linkpay_type,reserved1,reserved2,reserved3,reserved4,reversed_biz_field,reversed_sys_field,back_bank_status,abstract";

    public List<LinkPaymentInfo> findByBatchSeqId(String batchSeqId) {
        DynamicObject[] dynamicObjects;
        ArrayList<LinkPaymentInfo> linkPaymentInfos = new ArrayList<LinkPaymentInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            linkPaymentInfos.add(LinkpaymentTransFormer.getInstance().transLinkPaymentInfo(dynamicObject));
        }
        return linkPaymentInfos;
    }

    public List<LinkPaymentInfo> findByBatchSeqIdAndDetailSeqId(String batchSeqId, String detailSeqId) {
        DynamicObject[] dynamicObjects;
        ArrayList<LinkPaymentInfo> linkPaymentInfos = new ArrayList<LinkPaymentInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and detail_seq_id = ?", (Object[])new Object[]{batchSeqId, detailSeqId});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            linkPaymentInfos.add(LinkpaymentTransFormer.getInstance().transLinkPaymentInfo(dynamicObject));
        }
        return linkPaymentInfos;
    }

    public void save(List<LinkPaymentInfo> linkPaymentInfos) {
        ArrayList<LinkPaymentInfo> insertList = new ArrayList<LinkPaymentInfo>(1);
        ArrayList<LinkPaymentInfo> updateList = new ArrayList<LinkPaymentInfo>(1);
        for (LinkPaymentInfo info : linkPaymentInfos) {
            String id = info.getId();
            if (QueryServiceHelper.exists((String)this.ENTITY, (Object)id)) {
                updateList.add(info);
                continue;
            }
            insertList.add(info);
        }
        this.insertAll(insertList);
        this.updateAll(updateList);
    }

    public void insertAll(List<LinkPaymentInfo> linkPaymentInfos) {
        if (linkPaymentInfos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            for (LinkPaymentInfo linkPaymentInfo : linkPaymentInfos) {
                dynamicObjectList.add(LinkpaymentTransFormer.getInstance().packLinkPaymentInfo(linkPaymentInfo));
            }
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[linkPaymentInfos.size()]);
            Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            for (int i = 0; i < objs.length; ++i) {
                DynamicObject dynamicObject = (DynamicObject)objs[i];
                linkPaymentInfos.get(i).setId(dynamicObject.getString("id"));
            }
        }
    }

    public void updateAll(List<LinkPaymentInfo> linkPaymentInfos) {
        if (linkPaymentInfos.size() > 0) {
            try {
                ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
                for (LinkPaymentInfo paymentInfo : linkPaymentInfos) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY);
                    dynamicObjectList.add(LinkpaymentTransFormer.getInstance().packLinkPaymentInfo(dynamicObject, paymentInfo));
                }
                DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[linkPaymentInfos.size()]);
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            }
            catch (Throwable e) {
                throw EBExceiptionUtil.serviceException((String)"update linkPayment error", (Throwable)e);
            }
        }
    }

    public void save(LinkPaymentInfo linkPaymentInfo) {
        ArrayList<LinkPaymentInfo> linkPaymentInfos = new ArrayList<LinkPaymentInfo>(1);
        linkPaymentInfos.add(linkPaymentInfo);
        this.save(linkPaymentInfos);
    }
}

