/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.model.entity.settleBankAccNo.SettleBankAccNoEntity;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class SettBankKeyWordsRepository {
    private String BANK_KEYWORDS_ENTITY = "aqap_sett_bank_keywords";
    private String SELECT_PROPERTIES = "id,modifytime,createtime,creator,modifier,enable,status,bank_key,settle_accno";

    public List<SettleBankAccNoEntity> findListBykey(String word) {
        ArrayList<SettleBankAccNoEntity> result = new ArrayList<SettleBankAccNoEntity>(16);
        QFilter filter = QFilter.like((String)"bank_key", (String)word);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.BANK_KEYWORDS_ENTITY, (String)this.SELECT_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                SettleBankAccNoEntity settleBankAccNoEntity = this.toEntityInfo(dynamicObject);
                result.add(settleBankAccNoEntity);
            }
        }
        return result;
    }

    public List<SettleBankAccNoEntity> findListBykey() {
        ArrayList<SettleBankAccNoEntity> result = new ArrayList<SettleBankAccNoEntity>(16);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)this.BANK_KEYWORDS_ENTITY, (String)this.SELECT_PROPERTIES, null);
        if (objectDynamicObjectMap != null) {
            for (Map.Entry entry : objectDynamicObjectMap.entrySet()) {
                SettleBankAccNoEntity settleBankAccNoEntity = this.toEntityInfo((DynamicObject)entry.getValue());
                result.add(settleBankAccNoEntity);
            }
        }
        return result;
    }

    public String matchBankNoByKey(String bankName) {
        ArrayList<String> fuzzyMatchList = new ArrayList<String>(16);
        List<SettleBankAccNoEntity> listBykey = this.findListBykey();
        for (SettleBankAccNoEntity settleBankAccNoEntity : listBykey) {
            if (settleBankAccNoEntity.getBankKey().equals(bankName)) {
                return settleBankAccNoEntity.getSettleAccno();
            }
            if (bankName == null || !bankName.contains(settleBankAccNoEntity.getBankKey())) continue;
            fuzzyMatchList.add(settleBankAccNoEntity.getSettleAccno());
        }
        if (fuzzyMatchList.size() == 0) {
            return "";
        }
        return (String)fuzzyMatchList.get(0);
    }

    public SettleBankAccNoEntity matchSettleBankByKey(String bankName) {
        List<SettleBankAccNoEntity> listBykey = this.findListBykey();
        for (SettleBankAccNoEntity settleBankAccNoEntity : listBykey) {
            if (settleBankAccNoEntity.getBankKey().equals(bankName)) {
                return settleBankAccNoEntity;
            }
            if (bankName == null || !bankName.contains(settleBankAccNoEntity.getBankKey())) continue;
            return settleBankAccNoEntity;
        }
        return null;
    }

    public SettleBankAccNoEntity matchByKey(String bankName) {
        ArrayList<SettleBankAccNoEntity> fuzzyMatchList = new ArrayList<SettleBankAccNoEntity>(16);
        List<SettleBankAccNoEntity> listBykey = this.findListBykey();
        for (SettleBankAccNoEntity settleBankAccNoEntity : listBykey) {
            if (settleBankAccNoEntity.getBankKey().equals(bankName)) {
                return settleBankAccNoEntity;
            }
            if (bankName == null || !bankName.contains(settleBankAccNoEntity.getBankKey())) continue;
            fuzzyMatchList.add(settleBankAccNoEntity);
        }
        if (fuzzyMatchList.size() == 0) {
            return null;
        }
        return (SettleBankAccNoEntity)fuzzyMatchList.get(0);
    }

    private SettleBankAccNoEntity toEntityInfo(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        SettleBankAccNoEntity entity = new SettleBankAccNoEntity();
        entity.setId(dynamicObject.getLong("id"));
        entity.setModifytime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("modifytime")));
        entity.setCreatetime(LocalDateUtil.date2LocalDateTime((Date)dynamicObject.getDate("createtime")));
        String enable = dynamicObject.getString("enable");
        if (!StringUtils.isEmpty((String)enable)) {
            entity.setEnable(Integer.parseInt(enable));
        }
        String creatorid = dynamicObject.getString("creator");
        entity.setCreatorid(creatorid);
        String modifierid = dynamicObject.getString("modifier");
        entity.setCreatorid(modifierid);
        String status = dynamicObject.getString("status");
        entity.setStatus(status);
        entity.setBankKey(dynamicObject.getString("bank_key"));
        entity.setSettleAccno(dynamicObject.getString("settle_accno"));
        return entity;
    }
}

