/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.transform;

import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.EbStatus;
import kd.ebg.aqap.common.model.LinkPaymentInfo;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class LinkpaymentTransFormer {
    private static LinkpaymentTransFormer instance;
    public static final String ENTITY = "aqap_bd_linkpaymentinfo";
    public static final String SELECT_ALL_PROPERTIES = "id,version,amount,bank_batch_seq_id,bank_status,bank_status_msg,batch_biz_no,batch_seq_id,biz_type,booking_date,child_acnt1,child_acnt2,child_acnt3,child_acnt4,child_acnt5,create_time,currency,custom_id,desc_msg,detail_biz_no,detail_seq_id,eb_seq_id,eb_status,eb_status_msg,ebg_id,email,fee_type,force_manual,insert_batch_seq,mobile,parent_acnt,payee_acc_name,payee_acc_no,payee_area_code,payee_bank_addr,payee_bank_name,payee_city,payee_cnaps_code,payee_country,payee_province,payee_swift_code,payee_type,sub_biz_type,total_amount,total_count,update_time,urgent,use_code,use_msg,verify_field,linkpay_type,reserved1,reserved2,reserved3,reserved4,reversed_biz_field,reversed_sys_field,back_bank_status,abstract";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkpaymentTransFormer getInstance() {
        Class<LinkpaymentTransFormer> clazz = LinkpaymentTransFormer.class;
        synchronized (LinkpaymentTransFormer.class) {
            if (instance == null) {
                instance = new LinkpaymentTransFormer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DynamicObject packLinkPaymentInfo(LinkPaymentInfo linkPaymentInfo) {
        return this.packLinkPaymentInfo(null, linkPaymentInfo);
    }

    public DynamicObject packLinkPaymentInfo(DynamicObject dynamicObject, LinkPaymentInfo linkPaymentInfo) {
        Date time;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
        } else {
            dynamicObject.set("id", (Object)Long.parseLong(linkPaymentInfo.getId()));
        }
        this.setIdempotency(linkPaymentInfo);
        dynamicObject.set("version", (Object)linkPaymentInfo.getVersion());
        dynamicObject.set("amount", (Object)linkPaymentInfo.getAmount());
        dynamicObject.set("bank_batch_seq_id", (Object)linkPaymentInfo.getBankBatchSeqId());
        dynamicObject.set("bank_status", (Object)linkPaymentInfo.getBankStatus());
        dynamicObject.set("bank_status_msg", (Object)linkPaymentInfo.getBankStatusMsg());
        dynamicObject.set("batch_biz_no", (Object)linkPaymentInfo.getBatchBizNo());
        dynamicObject.set("batch_seq_id", (Object)linkPaymentInfo.getBatchSeqId());
        dynamicObject.set("biz_type", (Object)linkPaymentInfo.getBizType());
        if (linkPaymentInfo.getBookingDate() != null) {
            Date bookTime = Date.from(linkPaymentInfo.getBookingDate().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("booking_date", (Object)bookTime);
        }
        dynamicObject.set("child_acnt1", (Object)linkPaymentInfo.getChildAcnt1());
        dynamicObject.set("child_acnt2", (Object)linkPaymentInfo.getChildAcnt2());
        dynamicObject.set("child_acnt3", (Object)linkPaymentInfo.getChildAcnt3());
        dynamicObject.set("child_acnt4", (Object)linkPaymentInfo.getChildAcnt4());
        dynamicObject.set("child_acnt5", (Object)linkPaymentInfo.getChildAcnt5());
        if (linkPaymentInfo.getCreateTime() != null) {
            time = Date.from(linkPaymentInfo.getCreateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("create_time", (Object)time);
        }
        dynamicObject.set("currency", (Object)linkPaymentInfo.getCurrency());
        dynamicObject.set("custom_id", (Object)linkPaymentInfo.getCustomId());
        dynamicObject.set("desc_msg", (Object)linkPaymentInfo.getDescMsg());
        dynamicObject.set("detail_biz_no", (Object)linkPaymentInfo.getDetailBizNo());
        dynamicObject.set("detail_seq_id", (Object)linkPaymentInfo.getDetailSeqId());
        dynamicObject.set("eb_seq_id", (Object)linkPaymentInfo.getEbSeqId());
        dynamicObject.set("eb_status", (Object)linkPaymentInfo.getEbStatus());
        dynamicObject.set("eb_status_msg", (Object)linkPaymentInfo.getEbStatusMsg());
        dynamicObject.set("ebg_id", (Object)linkPaymentInfo.getEbgId());
        dynamicObject.set("email", (Object)linkPaymentInfo.getEmail());
        dynamicObject.set("fee_type", (Object)linkPaymentInfo.getFeeType());
        dynamicObject.set("force_manual", (Object)linkPaymentInfo.getForceManual());
        dynamicObject.set("insert_batch_seq", (Object)linkPaymentInfo.getInsertBatchSeq());
        dynamicObject.set("mobile", (Object)linkPaymentInfo.getMobile());
        dynamicObject.set("parent_acnt", (Object)linkPaymentInfo.getParentAcnt());
        dynamicObject.set("payee_acc_name", (Object)linkPaymentInfo.getPayeeAccName());
        dynamicObject.set("payee_acc_no", (Object)linkPaymentInfo.getPayeeAccNo());
        dynamicObject.set("payee_area_code", (Object)linkPaymentInfo.getPayeeAreaCode());
        dynamicObject.set("payee_bank_addr", (Object)linkPaymentInfo.getPayeeBankAddr());
        dynamicObject.set("payee_bank_name", (Object)linkPaymentInfo.getPayeeBankName());
        dynamicObject.set("payee_city", (Object)linkPaymentInfo.getPayeeCity());
        dynamicObject.set("payee_cnaps_code", (Object)linkPaymentInfo.getPayeeCnapsCode());
        dynamicObject.set("payee_country", (Object)linkPaymentInfo.getPayeeCountry());
        dynamicObject.set("payee_province", (Object)linkPaymentInfo.getPayeeProvince());
        dynamicObject.set("payee_swift_code", (Object)linkPaymentInfo.getPayeeSwiftCode());
        dynamicObject.set("payee_type", (Object)linkPaymentInfo.getPayeeType());
        dynamicObject.set("sub_biz_type", (Object)linkPaymentInfo.getSubBizType());
        dynamicObject.set("total_amount", (Object)linkPaymentInfo.getTotalAmount());
        dynamicObject.set("total_count", (Object)linkPaymentInfo.getTotalCount());
        if (linkPaymentInfo.getUpdateTime() != null) {
            time = Date.from(linkPaymentInfo.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("update_time", (Object)time);
        }
        dynamicObject.set("urgent", (Object)linkPaymentInfo.getUrgent());
        dynamicObject.set("use_code", (Object)linkPaymentInfo.getUseCode());
        dynamicObject.set("use_msg", (Object)linkPaymentInfo.getUseMsg());
        dynamicObject.set("verify_field", (Object)linkPaymentInfo.getVerifyField());
        dynamicObject.set("linkpay_type", (Object)linkPaymentInfo.getLinkpayType());
        dynamicObject.set("reserved1", (Object)linkPaymentInfo.getReserved1());
        dynamicObject.set("reserved2", (Object)linkPaymentInfo.getReserved2());
        dynamicObject.set("reserved3", (Object)linkPaymentInfo.getReserved3());
        dynamicObject.set("reserved4", (Object)linkPaymentInfo.getReserved4());
        dynamicObject.set("back_bank_status", (Object)linkPaymentInfo.getBackBankStatus());
        dynamicObject.set("abstract", (Object)linkPaymentInfo.getAbstractMsg());
        dynamicObject.set("reversed_sys_field", (Object)linkPaymentInfo.getReversedSysField());
        dynamicObject.set("reversed_sys_field", (Object)linkPaymentInfo.getReversedSysField());
        dynamicObject.set("status", (Object)"A");
        return dynamicObject;
    }

    public LinkPaymentInfo transLinkPaymentInfo(DynamicObject dynamicObject) {
        LinkPaymentInfo linkPaymentInfo = new LinkPaymentInfo();
        String time = "";
        linkPaymentInfo.setId(dynamicObject.getString("id"));
        linkPaymentInfo.setVersion(dynamicObject.getInt("version"));
        linkPaymentInfo.setAmount(dynamicObject.getBigDecimal("amount").setScale(2));
        linkPaymentInfo.setBankBatchSeqId(dynamicObject.getString("bank_batch_seq_id"));
        linkPaymentInfo.setBankStatus(dynamicObject.getString("bank_status"));
        linkPaymentInfo.setBankStatusMsg(dynamicObject.getString("bank_status_msg"));
        linkPaymentInfo.setBatchBizNo(dynamicObject.getString("batch_biz_no"));
        linkPaymentInfo.setBatchSeqId(dynamicObject.getString("batch_seq_id"));
        linkPaymentInfo.setBizType(dynamicObject.getString("biz_type"));
        time = dynamicObject.getString("booking_date");
        if (!this.isEmpty(time)) {
            linkPaymentInfo.setBookingDate(DTFactoryUtil.parseDateTime((String)time));
        }
        linkPaymentInfo.setChildAcnt1(dynamicObject.getString("child_acnt1"));
        linkPaymentInfo.setChildAcnt2(dynamicObject.getString("child_acnt2"));
        linkPaymentInfo.setChildAcnt3(dynamicObject.getString("child_acnt3"));
        linkPaymentInfo.setChildAcnt4(dynamicObject.getString("child_acnt4"));
        linkPaymentInfo.setChildAcnt5(dynamicObject.getString("child_acnt5"));
        time = dynamicObject.getString("create_time");
        if (!this.isEmpty(time)) {
            linkPaymentInfo.setCreateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        linkPaymentInfo.setCurrency(dynamicObject.getString("currency"));
        linkPaymentInfo.setCustomId(dynamicObject.getString("custom_id"));
        linkPaymentInfo.setDescMsg(dynamicObject.getString("desc_msg"));
        linkPaymentInfo.setDetailBizNo(dynamicObject.getString("detail_biz_no"));
        linkPaymentInfo.setDetailSeqId(dynamicObject.getString("detail_seq_id"));
        linkPaymentInfo.setEbSeqId(dynamicObject.getString("eb_seq_id"));
        linkPaymentInfo.setEbStatus(dynamicObject.getString("eb_status"));
        linkPaymentInfo.setEbStatusMsg(dynamicObject.getString("eb_status_msg"));
        linkPaymentInfo.setEbgId(dynamicObject.getString("ebg_id"));
        linkPaymentInfo.setEmail(dynamicObject.getString("email"));
        linkPaymentInfo.setFeeType(dynamicObject.getString("fee_type"));
        linkPaymentInfo.setForceManual(dynamicObject.getBoolean("force_manual"));
        linkPaymentInfo.setInsertBatchSeq(dynamicObject.getString("insert_batch_seq"));
        linkPaymentInfo.setMobile(dynamicObject.getString("mobile"));
        linkPaymentInfo.setParentAcnt(dynamicObject.getString("parent_acnt"));
        linkPaymentInfo.setPayeeAccName(dynamicObject.getString("payee_acc_name"));
        linkPaymentInfo.setPayeeAccNo(dynamicObject.getString("payee_acc_no"));
        linkPaymentInfo.setPayeeAreaCode(dynamicObject.getString("payee_area_code"));
        linkPaymentInfo.setPayeeBankAddr(dynamicObject.getString("payee_bank_addr"));
        linkPaymentInfo.setPayeeBankName(dynamicObject.getString("payee_bank_name"));
        linkPaymentInfo.setPayeeCity(dynamicObject.getString("payee_city"));
        linkPaymentInfo.setPayeeCnapsCode(dynamicObject.getString("payee_cnaps_code"));
        linkPaymentInfo.setPayeeCountry(dynamicObject.getString("payee_country"));
        linkPaymentInfo.setPayeeProvince(dynamicObject.getString("payee_province"));
        linkPaymentInfo.setPayeeSwiftCode(dynamicObject.getString("payee_swift_code"));
        linkPaymentInfo.setPayeeType(dynamicObject.getString("payee_type"));
        linkPaymentInfo.setSubBizType(dynamicObject.getString("sub_biz_type"));
        linkPaymentInfo.setTotalAmount(dynamicObject.getBigDecimal("total_amount").setScale(2));
        linkPaymentInfo.setTotalCount(dynamicObject.getInt("total_count"));
        time = dynamicObject.getString("update_time");
        if (!this.isEmpty(time)) {
            linkPaymentInfo.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        linkPaymentInfo.setUrgent(dynamicObject.getBoolean("urgent"));
        linkPaymentInfo.setUseCode(dynamicObject.getString("use_code"));
        linkPaymentInfo.setUseMsg(dynamicObject.getString("use_msg"));
        linkPaymentInfo.setVerifyField(dynamicObject.getString("verify_field"));
        linkPaymentInfo.setLinkpayType(dynamicObject.getString("linkpay_type"));
        linkPaymentInfo.setReserved1(dynamicObject.getString("reserved1"));
        linkPaymentInfo.setReserved2(dynamicObject.getString("reserved2"));
        linkPaymentInfo.setReserved3(dynamicObject.getString("reserved3"));
        linkPaymentInfo.setReserved4(dynamicObject.getString("reserved4"));
        linkPaymentInfo.setReversedBizField(dynamicObject.getString("reversed_biz_field"));
        linkPaymentInfo.setReversedSysField(dynamicObject.getString("reversed_sys_field"));
        linkPaymentInfo.setAbstractMsg(dynamicObject.getString("abstract"));
        this.setIdempotency(linkPaymentInfo);
        return linkPaymentInfo;
    }

    private void setIdempotency(LinkPaymentInfo linkPaymentInfo) {
        if (linkPaymentInfo.isIdempotency()) {
            if (StringUtils.isEmpty((String)linkPaymentInfo.getDetailBizNo())) {
                linkPaymentInfo.setDetailBizNo(linkPaymentInfo.getDetailSeqId());
            }
            if (linkPaymentInfo.getEbStatus().equalsIgnoreCase(EbStatus.BANK_FAIL.getName())) {
                linkPaymentInfo.setBackBankStatus(linkPaymentInfo.getDetailSeqId());
            } else {
                linkPaymentInfo.setBackBankStatus("1");
            }
        } else {
            linkPaymentInfo.setBackBankStatus(linkPaymentInfo.getDetailSeqId());
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

