/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.transform;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IColumnValuePair;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISaveDataTable;
import kd.bos.dataentity.metadata.ISaveMetaRow;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.SaveDataSet;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.aqap.common.model.transform.BatchUpdateCollector;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class OpenCreditTransFormer {
    EBGLogger log = EBGLogger.getInstance().getLogger(OpenCreditTransFormer.class);
    private static OpenCreditTransFormer instance;
    private final String PAYABLE_ENTITY = "aqap_open_credit";
    public static final String SELECT_ALL_PROPERTIES = "detailseqid,detailbizno,applicantcreditnum,creditno,currency,amount,contractno,contractamount,credittype,creditmode,creditform,opendate,moreproportion,lessproportion,duedate,dueaddress,applicantaddressen,counteraddress,mrgnproportion,mrgnacctype,mrgnaccno,mrgncurrency,characcno,charcurrency,costbear,oprnm,oprtel,advicnapscode,adviaddress,forwardcnapscode,forwardaddress,avwtbank,avwtbankbic,avwtbanknmadd,draftcustflg,paytype,paydays,acceptorcnapscode,acceptoraddress,cashway,draftproportion,draftamt,mixdraftinvproportion,mixdraftinvamt,mixtenortype,mixtenordays,explain,draweecnapscode,draweeaddress,ispartship,istranship,shipdate,presentperiod,presentday,deliveryport,startair,terminiair,termini,gasdescription,docclause,addclause,remark,bankrefdate,bankrefkey,fileurl,filename,reserved1,reserved2,creditstatus,id,ebgid,version,customid,bankversionid,bankloginid,biztype,subbiztype,implclassname,queryimplclassname,packagekey,updatetime,inserttime,status,statusname,statusmsg,bankstatus,bankmsg,packagetime,bankbatchseqid,bankdetailseqid,bankserialno,submitsuccesstime,lastsynctime,synccount,payfinishtime,flowserialno,rqstserialno,requesttime,batchseqid,accno,errormsg,coninstructions,addclause_tag,docclause_tag,acptdate,receivedno,busamt,costbearparty,feemode,docpcsmode,buscurrency,payaccno,payacccurrency,payamt,payeecountry,paynature,ibpisref,ibppaytype,trancode,corramt,txnpscpt,ibpregno,returndesc_tag,refusepoint,charfeeinfo_tag,,payaccno2,payacccurrency2,payamt2,applicantname,countername,countercountry,transflag,contractcurrency,afterfrom,docs,reject,drawon,lastshipdate,mixtenor,receiptplace,charges,addamt,reduceamt,modfrequency,lastmoddate";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenCreditTransFormer getInstance() {
        Class<OpenCreditTransFormer> clazz = OpenCreditTransFormer.class;
        synchronized (OpenCreditTransFormer.class) {
            if (instance == null) {
                instance = new OpenCreditTransFormer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setDynamicParamater(DynamicObject dynamicObject, String key, Object value) {
        if (value instanceof String) {
            if (StringUtils.isEmpty((String)((String)value))) {
                value = " ";
            }
        } else if (value instanceof Integer && value == null) {
            value = 0;
        }
        dynamicObject.set(key, value);
    }

    public DynamicObject transNotePayable(DynamicObject dynamicObject, OpenCreditDetail info) {
        Date lastSubmitTime;
        Date due;
        LocalDate nowLocal;
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_open_credit");
        } else {
            this.setDynamicParamater(dynamicObject, "id", info.getId());
        }
        if (info.getVersion() == null) {
            info.setVersion(1);
        }
        this.setDynamicParamater(dynamicObject, "detailseqid", info.getDetailSeqID());
        this.setDynamicParamater(dynamicObject, "detailbizno", info.getDetailBizNo());
        this.setDynamicParamater(dynamicObject, "applicantcreditnum", info.getApplicantCreditNum());
        this.setDynamicParamater(dynamicObject, "creditno", info.getCreditNo());
        this.setDynamicParamater(dynamicObject, "currency", info.getCurrency());
        this.setDynamicParamater(dynamicObject, "amount", info.getAmount());
        this.setDynamicParamater(dynamicObject, "contractno", info.getContractNo());
        this.setDynamicParamater(dynamicObject, "contractamount", info.getContractAmount());
        this.setDynamicParamater(dynamicObject, "credittype", info.getCreditType());
        this.setDynamicParamater(dynamicObject, "creditmode", info.getCreditMode());
        this.setDynamicParamater(dynamicObject, "creditform", info.getCreditForm());
        if (info.getOpenDate() != null) {
            nowLocal = info.getOpenDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("opendate", (Object)due);
        }
        this.setDynamicParamater(dynamicObject, "moreproportion", info.getMoreProportion());
        this.setDynamicParamater(dynamicObject, "lessproportion", info.getLessProportion());
        if (info.getDueDate() != null) {
            nowLocal = info.getDueDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("duedate", (Object)due);
        }
        this.setDynamicParamater(dynamicObject, "dueaddress", info.getDueAddress());
        this.setDynamicParamater(dynamicObject, "applicantaddressen", info.getApplicantAddressEN());
        this.setDynamicParamater(dynamicObject, "counteraddress", info.getCounterAddress());
        this.setDynamicParamater(dynamicObject, "mrgnproportion", info.getMrgnProportion());
        this.setDynamicParamater(dynamicObject, "mrgnacctype", info.getMrgnAccType());
        this.setDynamicParamater(dynamicObject, "mrgnaccno", info.getMrgnAccno());
        this.setDynamicParamater(dynamicObject, "mrgncurrency", info.getMrgnCurrency());
        this.setDynamicParamater(dynamicObject, "characcno", info.getCharAccNo());
        this.setDynamicParamater(dynamicObject, "charcurrency", info.getCharCurrency());
        this.setDynamicParamater(dynamicObject, "costbear", info.getCostBear());
        this.setDynamicParamater(dynamicObject, "oprnm", info.getOprNm());
        this.setDynamicParamater(dynamicObject, "oprtel", info.getOprTel());
        this.setDynamicParamater(dynamicObject, "advicnapscode", info.getAdviCnapsCode());
        this.setDynamicParamater(dynamicObject, "adviaddress", info.getAdviAddress());
        this.setDynamicParamater(dynamicObject, "forwardcnapscode", info.getForwardCnapsCode());
        this.setDynamicParamater(dynamicObject, "forwardaddress", info.getForwardAddress());
        this.setDynamicParamater(dynamicObject, "avwtbank", info.getAvWtBank());
        this.setDynamicParamater(dynamicObject, "avwtbankbic", info.getAvWtBankBic());
        this.setDynamicParamater(dynamicObject, "avwtbanknmadd", info.getAvWtBankNmAdd());
        this.setDynamicParamater(dynamicObject, "draftcustflg", info.getDraftCustFlg());
        this.setDynamicParamater(dynamicObject, "paytype", info.getPayType());
        this.setDynamicParamater(dynamicObject, "paydays", info.getPayDays());
        this.setDynamicParamater(dynamicObject, "acceptorcnapscode", info.getAcceptorCnapsCode());
        this.setDynamicParamater(dynamicObject, "acceptoraddress", info.getAcceptorAddress());
        this.setDynamicParamater(dynamicObject, "cashway", info.getCashWay());
        this.setDynamicParamater(dynamicObject, "draftproportion", info.getDraftProportion());
        this.setDynamicParamater(dynamicObject, "draftamt", info.getDraftAmt());
        this.setDynamicParamater(dynamicObject, "mixdraftinvproportion", info.getMixDraftInvProportion());
        this.setDynamicParamater(dynamicObject, "mixdraftinvamt", info.getMixDraftInvAmt());
        this.setDynamicParamater(dynamicObject, "mixtenortype", info.getMixTenorType());
        this.setDynamicParamater(dynamicObject, "mixtenordays", info.getMixTenorDays());
        this.setDynamicParamater(dynamicObject, "explain", info.getExplain());
        this.setDynamicParamater(dynamicObject, "draweecnapscode", info.getDraweeCnapsCode());
        this.setDynamicParamater(dynamicObject, "draweeaddress", info.getDraweeAddress());
        this.setDynamicParamater(dynamicObject, "ispartship", info.getIsPartShip());
        this.setDynamicParamater(dynamicObject, "istranship", info.getIsTranShip());
        this.setDynamicParamater(dynamicObject, "shipdate", info.getShipDate());
        this.setDynamicParamater(dynamicObject, "presentperiod", info.getPresentPeriod());
        this.setDynamicParamater(dynamicObject, "presentday", info.getPresentDay());
        this.setDynamicParamater(dynamicObject, "deliveryport", info.getDeliveryPort());
        this.setDynamicParamater(dynamicObject, "startair", info.getStartAir());
        this.setDynamicParamater(dynamicObject, "terminiair", info.getTerminiAir());
        this.setDynamicParamater(dynamicObject, "termini", info.getTermini());
        this.setDynamicParamater(dynamicObject, "gasdescription", info.getGasDescription());
        this.setDynamicParamater(dynamicObject, "docclause_tag", info.getDocClause());
        this.setDynamicParamater(dynamicObject, "addclause_tag", info.getAddClause());
        this.setDynamicParamater(dynamicObject, "remark", info.getRemark());
        this.setDynamicParamater(dynamicObject, "bankrefdate", info.getBankRefDate());
        this.setDynamicParamater(dynamicObject, "bankrefkey", info.getBankRefKey());
        this.setDynamicParamater(dynamicObject, "fileurl", info.getFileUrl());
        this.setDynamicParamater(dynamicObject, "filename", info.getFileName());
        this.setDynamicParamater(dynamicObject, "reserved1", info.getReserved1());
        this.setDynamicParamater(dynamicObject, "reserved2", info.getReserved2());
        this.setDynamicParamater(dynamicObject, "creditstatus", info.getCreditStatus());
        this.setDynamicParamater(dynamicObject, "ebgid", info.getEbgID());
        this.setDynamicParamater(dynamicObject, "version", info.getVersion());
        this.setDynamicParamater(dynamicObject, "customid", info.getCustomID());
        this.setDynamicParamater(dynamicObject, "bankversionid", info.getBankVersionID());
        this.setDynamicParamater(dynamicObject, "bankloginid", info.getBankLoginID());
        this.setDynamicParamater(dynamicObject, "biztype", info.getBizType());
        this.setDynamicParamater(dynamicObject, "subbiztype", info.getSubBizType());
        this.setDynamicParamater(dynamicObject, "implclassname", info.getImplClassName());
        this.setDynamicParamater(dynamicObject, "queryimplclassname", info.getQueryImplClassName());
        this.setDynamicParamater(dynamicObject, "packagekey", info.getPackageKey());
        if (info.getUpdateTime() != null) {
            lastSubmitTime = Date.from(info.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("updatetime", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("updatetime", (Object)lastSubmitTime);
        }
        if (info.getInsertTime() != null) {
            lastSubmitTime = Date.from(info.getInsertTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("inserttime", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("inserttime", (Object)lastSubmitTime);
        }
        this.setDynamicParamater(dynamicObject, "status", info.getStatus());
        this.setDynamicParamater(dynamicObject, "statusname", info.getStatusName());
        this.setDynamicParamater(dynamicObject, "statusmsg", info.getStatusMsg());
        this.setDynamicParamater(dynamicObject, "bankstatus", info.getBankStatus());
        this.setDynamicParamater(dynamicObject, "bankmsg", info.getBankMsg());
        if (info.getPackageTime() != null) {
            lastSubmitTime = Date.from(info.getPackageTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("packagetime", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("packagetime", (Object)lastSubmitTime);
        }
        this.setDynamicParamater(dynamicObject, "bankbatchseqid", info.getBankBatchSeqId());
        this.setDynamicParamater(dynamicObject, "bankdetailseqid", info.getBankDetailSeqId());
        this.setDynamicParamater(dynamicObject, "bankserialno", info.getBankSerialNo());
        if (info.getSubmitSuccessTime() != null) {
            lastSubmitTime = Date.from(info.getSubmitSuccessTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submitsuccesstime", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("submitsuccesstime", (Object)lastSubmitTime);
        }
        if (info.getLastSyncTime() != null) {
            lastSubmitTime = Date.from(info.getLastSyncTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("lastsynctime", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("lastsynctime", (Object)lastSubmitTime);
        }
        this.setDynamicParamater(dynamicObject, "synccount", info.getSyncCount());
        if (info.getPayFinishTime() != null) {
            lastSubmitTime = Date.from(info.getPayFinishTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("payfinishtime", (Object)lastSubmitTime);
        }
        this.setDynamicParamater(dynamicObject, "flowserialno", info.getFlowSerialNo());
        this.setDynamicParamater(dynamicObject, "rqstserialno", info.getRqstSerialNo());
        if (info.getRequestTime() != null) {
            lastSubmitTime = Date.from(info.getRequestTime().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("requesttime", (Object)lastSubmitTime);
        } else {
            lastSubmitTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("requesttime", (Object)lastSubmitTime);
        }
        this.setDynamicParamater(dynamicObject, "batchseqid", info.getBatchSeqId());
        this.setDynamicParamater(dynamicObject, "accno", info.getAccno());
        this.setDynamicParamater(dynamicObject, "errormsg", info.getErrorMsg());
        this.setDynamicParamater(dynamicObject, "coninstructions", info.getConInstructions());
        if (info.getAcptDate() != null) {
            nowLocal = info.getAcptDate();
            due = Date.from(nowLocal.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
            dynamicObject.set("acptdate", (Object)due);
        }
        this.setDynamicParamater(dynamicObject, "busamt", info.getBusAmt());
        this.setDynamicParamater(dynamicObject, "costbearparty", info.getCostBearParty());
        this.setDynamicParamater(dynamicObject, "feemode", info.getFeeMode());
        this.setDynamicParamater(dynamicObject, "docpcsmode", info.getDocPcsMode());
        this.setDynamicParamater(dynamicObject, "buscurrency", info.getBusCurrency());
        this.setDynamicParamater(dynamicObject, "payaccno", info.getPayAccno());
        this.setDynamicParamater(dynamicObject, "payacccurrency", info.getPayAccCurrency());
        this.setDynamicParamater(dynamicObject, "payamt", info.getPayAmt());
        this.setDynamicParamater(dynamicObject, "payaccno2", info.getPayAccno2());
        this.setDynamicParamater(dynamicObject, "payacccurrency2", info.getPayAccCurrency2());
        this.setDynamicParamater(dynamicObject, "payamt2", info.getPayAmt2());
        this.setDynamicParamater(dynamicObject, "payeecountry", info.getPayeeCountry());
        this.setDynamicParamater(dynamicObject, "paynature", info.getPayNature());
        this.setDynamicParamater(dynamicObject, "ibpisref", info.getIbpIsref());
        this.setDynamicParamater(dynamicObject, "ibppaytype", info.getIbpPaytype());
        this.setDynamicParamater(dynamicObject, "trancode", info.getTranCode());
        this.setDynamicParamater(dynamicObject, "corramt", info.getCorrAmt());
        this.setDynamicParamater(dynamicObject, "txnpscpt", info.getTxnPscpt());
        this.setDynamicParamater(dynamicObject, "ibpRegno", info.getIbpRegno());
        this.setDynamicParamater(dynamicObject, "returndesc_tag", info.getReturnDesc());
        this.setDynamicParamater(dynamicObject, "refusepoint", info.getRefusePoint());
        this.setDynamicParamater(dynamicObject, "charfeeinfo_tag", info.getCharFeeInfo());
        this.setDynamicParamater(dynamicObject, "applicantname", info.getApplicantName());
        this.setDynamicParamater(dynamicObject, "countername", info.getCounterName());
        this.setDynamicParamater(dynamicObject, "countercountry", info.getCounterCountry());
        this.setDynamicParamater(dynamicObject, "transflag", info.getTransFlag());
        this.setDynamicParamater(dynamicObject, "contractcurrency", info.getContractCurrency());
        this.setDynamicParamater(dynamicObject, "afterfrom", info.getAfterFrom());
        this.setDynamicParamater(dynamicObject, "docs", info.getDocs());
        this.setDynamicParamater(dynamicObject, "reject", info.getReject());
        this.setDynamicParamater(dynamicObject, "drawon", info.getDrawOn());
        this.setDynamicParamater(dynamicObject, "lastshipdate", info.getLastShipDate());
        this.setDynamicParamater(dynamicObject, "mixtenor", info.getMixTenor());
        this.setDynamicParamater(dynamicObject, "receiptplace", info.getReceiptPlace());
        this.setDynamicParamater(dynamicObject, "charges", info.getCharges());
        this.setDynamicParamater(dynamicObject, "addamt", info.getAddAmt());
        this.setDynamicParamater(dynamicObject, "reduceamt", info.getReduceAmt());
        this.setDynamicParamater(dynamicObject, "modfrequency", info.getModFrequency());
        this.setDynamicParamater(dynamicObject, "lastmoddate", info.getLastModDate());
        return dynamicObject;
    }

    public DynamicObject transNotePayable(OpenCreditDetail info) {
        return this.transNotePayable(null, info);
    }

    public OpenCreditDetail packNotePayable(DynamicObject dynamicObject) {
        OpenCreditDetail openCreditDetail = new OpenCreditDetail();
        String time = "";
        openCreditDetail.setDetailSeqID(dynamicObject.getString("detailseqid"));
        openCreditDetail.setDetailBizNo(dynamicObject.getString("detailbizno"));
        openCreditDetail.setApplicantCreditNum(dynamicObject.getString("applicantcreditnum"));
        openCreditDetail.setCreditNo(dynamicObject.getString("creditno"));
        openCreditDetail.setCurrency(dynamicObject.getString("currency"));
        openCreditDetail.setAmount(dynamicObject.getBigDecimal("amount"));
        openCreditDetail.setContractNo(dynamicObject.getString("contractno"));
        openCreditDetail.setContractAmount(dynamicObject.getBigDecimal("contractamount"));
        openCreditDetail.setCreditType(dynamicObject.getString("credittype"));
        openCreditDetail.setCreditMode(dynamicObject.getString("creditmode"));
        openCreditDetail.setCreditForm(dynamicObject.getString("creditform"));
        time = dynamicObject.getString("opendate");
        if (!this.isEmpty(time)) {
            openCreditDetail.setOpenDate(DTFactoryUtil.parseDate((String)time));
        }
        openCreditDetail.setMoreProportion(dynamicObject.getString("moreproportion"));
        openCreditDetail.setLessProportion(dynamicObject.getString("lessproportion"));
        time = dynamicObject.getString("duedate");
        if (!this.isEmpty(time)) {
            openCreditDetail.setDueDate(DTFactoryUtil.parseDate((String)time));
        }
        openCreditDetail.setDueAddress(dynamicObject.getString("dueaddress"));
        openCreditDetail.setApplicantAddressEN(dynamicObject.getString("applicantaddressen"));
        openCreditDetail.setCounterAddress(dynamicObject.getString("counteraddress"));
        openCreditDetail.setMrgnProportion(dynamicObject.getString("mrgnproportion"));
        openCreditDetail.setMrgnAccType(dynamicObject.getString("mrgnacctype"));
        openCreditDetail.setMrgnAccno(dynamicObject.getString("mrgnaccno"));
        openCreditDetail.setMrgnCurrency(dynamicObject.getString("mrgncurrency"));
        openCreditDetail.setCharAccNo(dynamicObject.getString("characcno"));
        openCreditDetail.setCharCurrency(dynamicObject.getString("charcurrency"));
        openCreditDetail.setCostBear(dynamicObject.getString("costbear"));
        openCreditDetail.setOprNm(dynamicObject.getString("oprnm"));
        openCreditDetail.setOprTel(dynamicObject.getString("oprtel"));
        openCreditDetail.setAdviCnapsCode(dynamicObject.getString("advicnapscode"));
        openCreditDetail.setAdviAddress(dynamicObject.getString("adviaddress"));
        openCreditDetail.setForwardCnapsCode(dynamicObject.getString("forwardcnapscode"));
        openCreditDetail.setForwardAddress(dynamicObject.getString("forwardaddress"));
        openCreditDetail.setAvWtBank(dynamicObject.getString("avwtbank"));
        openCreditDetail.setAvWtBankBic(dynamicObject.getString("avwtbankbic"));
        openCreditDetail.setAvWtBankNmAdd(dynamicObject.getString("avwtbanknmadd"));
        openCreditDetail.setDraftCustFlg(dynamicObject.getString("draftcustflg"));
        openCreditDetail.setPayType(dynamicObject.getString("paytype"));
        openCreditDetail.setPayDays(dynamicObject.getString("paydays"));
        openCreditDetail.setAcceptorCnapsCode(dynamicObject.getString("acceptorcnapscode"));
        openCreditDetail.setAcceptorAddress(dynamicObject.getString("acceptoraddress"));
        openCreditDetail.setCashWay(dynamicObject.getString("cashway"));
        openCreditDetail.setDraftProportion(dynamicObject.getString("draftproportion"));
        openCreditDetail.setDraftAmt(dynamicObject.getBigDecimal("draftamt"));
        openCreditDetail.setMixDraftInvProportion(dynamicObject.getString("mixdraftinvproportion"));
        openCreditDetail.setMixDraftInvAmt(dynamicObject.getBigDecimal("mixdraftinvamt"));
        openCreditDetail.setMixTenorType(dynamicObject.getString("mixtenortype"));
        openCreditDetail.setMixTenorDays(dynamicObject.getString("mixtenordays"));
        openCreditDetail.setExplain(dynamicObject.getString("explain"));
        openCreditDetail.setDraweeCnapsCode(dynamicObject.getString("draweecnapscode"));
        openCreditDetail.setDraweeAddress(dynamicObject.getString("draweeaddress"));
        openCreditDetail.setIsPartShip(dynamicObject.getString("ispartship"));
        openCreditDetail.setIsTranShip(dynamicObject.getString("istranship"));
        openCreditDetail.setShipDate(dynamicObject.getString("shipdate"));
        openCreditDetail.setPresentPeriod(dynamicObject.getString("presentperiod"));
        openCreditDetail.setPresentDay(dynamicObject.getString("presentday"));
        openCreditDetail.setDeliveryPort(dynamicObject.getString("deliveryport"));
        openCreditDetail.setStartAir(dynamicObject.getString("startair"));
        openCreditDetail.setTerminiAir(dynamicObject.getString("terminiair"));
        openCreditDetail.setTermini(dynamicObject.getString("termini"));
        openCreditDetail.setGasDescription(dynamicObject.getString("gasdescription"));
        openCreditDetail.setDocClause(dynamicObject.getString("docclause_tag"));
        openCreditDetail.setAddClause(dynamicObject.getString("addclause_tag"));
        openCreditDetail.setRemark(dynamicObject.getString("remark"));
        openCreditDetail.setBankRefDate(dynamicObject.getString("bankrefdate"));
        openCreditDetail.setBankRefKey(dynamicObject.getString("bankrefkey"));
        openCreditDetail.setFileUrl(dynamicObject.getString("fileurl"));
        openCreditDetail.setFileName(dynamicObject.getString("filename"));
        openCreditDetail.setReserved1(dynamicObject.getString("reserved1"));
        openCreditDetail.setReserved2(dynamicObject.getString("reserved2"));
        openCreditDetail.setCreditStatus(dynamicObject.getString("creditstatus"));
        openCreditDetail.setId(dynamicObject.getLong("id"));
        openCreditDetail.setEbgID(dynamicObject.getString("ebgid"));
        openCreditDetail.setVersion(dynamicObject.getInt("version"));
        openCreditDetail.setCustomID(dynamicObject.getString("customid"));
        openCreditDetail.setBankVersionID(dynamicObject.getString("bankversionid"));
        openCreditDetail.setBankLoginID(dynamicObject.getString("bankloginid"));
        openCreditDetail.setBizType(dynamicObject.getString("biztype"));
        openCreditDetail.setSubBizType(dynamicObject.getString("subbiztype"));
        openCreditDetail.setImplClassName(dynamicObject.getString("implclassname"));
        openCreditDetail.setQueryImplClassName(dynamicObject.getString("queryimplclassname"));
        openCreditDetail.setPackageKey(dynamicObject.getString("packagekey"));
        time = dynamicObject.getString("updatetime");
        if (!this.isEmpty(time)) {
            openCreditDetail.setUpdateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("inserttime"))) {
            openCreditDetail.setInsertTime(DTFactoryUtil.parseDateTime((String)time));
        }
        openCreditDetail.setStatus(dynamicObject.getInt("status"));
        openCreditDetail.setStatusName(dynamicObject.getString("statusname"));
        openCreditDetail.setStatusMsg(dynamicObject.getString("statusmsg"));
        openCreditDetail.setBankStatus(dynamicObject.getString("bankstatus"));
        openCreditDetail.setBankMsg(dynamicObject.getString("bankmsg"));
        time = dynamicObject.getString("packagetime");
        if (!this.isEmpty(time)) {
            openCreditDetail.setPackageTime(DTFactoryUtil.parseDateTime((String)time));
        }
        openCreditDetail.setBankBatchSeqId(dynamicObject.getString("bankbatchseqid"));
        openCreditDetail.setBankDetailSeqId(dynamicObject.getString("bankdetailseqid"));
        openCreditDetail.setBankSerialNo(dynamicObject.getString("bankserialno"));
        time = dynamicObject.getString("submitsuccesstime");
        if (!this.isEmpty(time)) {
            openCreditDetail.setSubmitSuccessTime(DTFactoryUtil.parseDateTime((String)time));
        }
        if (!this.isEmpty(time = dynamicObject.getString("lastsynctime"))) {
            openCreditDetail.setLastSyncTime(DTFactoryUtil.parseDateTime((String)time));
        }
        openCreditDetail.setSyncCount(dynamicObject.getInt("synccount"));
        time = dynamicObject.getString("payfinishtime");
        if (!this.isEmpty(time)) {
            openCreditDetail.setPayFinishTime(DTFactoryUtil.parseDateTime((String)time));
        }
        openCreditDetail.setFlowSerialNo(dynamicObject.getString("flowserialno"));
        openCreditDetail.setRqstSerialNo(dynamicObject.getString("rqstserialno"));
        time = dynamicObject.getString("requesttime");
        if (!this.isEmpty(time)) {
            openCreditDetail.setRequestTime(DTFactoryUtil.parseDateTime((String)time));
        }
        openCreditDetail.setBatchSeqId(dynamicObject.getString("batchseqid"));
        openCreditDetail.setAccno(dynamicObject.getString("accno"));
        openCreditDetail.setErrorMsg(dynamicObject.getString("errormsg"));
        openCreditDetail.setConInstructions(dynamicObject.getString("coninstructions"));
        time = dynamicObject.getString("acptdate");
        if (!this.isEmpty(time)) {
            openCreditDetail.setAcptDate(DTFactoryUtil.parseDate((String)time));
        }
        openCreditDetail.setReceivedNo(dynamicObject.getString("receivedno"));
        openCreditDetail.setBusAmt(dynamicObject.getBigDecimal("busamt"));
        openCreditDetail.setCostBearParty(dynamicObject.getString("costbearparty"));
        openCreditDetail.setFeeMode(dynamicObject.getString("feemode"));
        openCreditDetail.setDocPcsMode(dynamicObject.getString("docpcsmode"));
        openCreditDetail.setBusCurrency(dynamicObject.getString("buscurrency"));
        openCreditDetail.setPayAccno(dynamicObject.getString("payaccno"));
        openCreditDetail.setPayAccCurrency(dynamicObject.getString("payacccurrency"));
        openCreditDetail.setPayAmt(dynamicObject.getBigDecimal("payamt"));
        openCreditDetail.setPayAccno2(dynamicObject.getString("payaccno2"));
        openCreditDetail.setPayAccCurrency2(dynamicObject.getString("payacccurrency2"));
        openCreditDetail.setPayAmt2(dynamicObject.getBigDecimal("payamt2"));
        openCreditDetail.setPayeeCountry(dynamicObject.getString("payeecountry"));
        openCreditDetail.setPayNature(dynamicObject.getString("paynature"));
        openCreditDetail.setIbpIsref(dynamicObject.getString("ibpisref"));
        openCreditDetail.setIbpPaytype(dynamicObject.getString("ibppaytype"));
        openCreditDetail.setTranCode(dynamicObject.getString("trancode"));
        openCreditDetail.setCorrAmt(dynamicObject.getBigDecimal("corramt"));
        openCreditDetail.setTxnPscpt(dynamicObject.getString("txnpscpt"));
        openCreditDetail.setIbpRegno(dynamicObject.getString("ibpregno"));
        openCreditDetail.setReturnDesc(dynamicObject.getString("returndesc_tag"));
        openCreditDetail.setRefusePoint(dynamicObject.getString("refusepoint"));
        openCreditDetail.setCharFeeInfo(dynamicObject.getString("charfeeinfo_tag"));
        openCreditDetail.setApplicantName(dynamicObject.getString("applicantname"));
        openCreditDetail.setCounterName(dynamicObject.getString("countername"));
        openCreditDetail.setCounterCountry(dynamicObject.getString("countercountry"));
        openCreditDetail.setTransFlag(dynamicObject.getString("transflag"));
        openCreditDetail.setContractCurrency(dynamicObject.getString("contractcurrency"));
        openCreditDetail.setAfterFrom(dynamicObject.getString("afterfrom"));
        openCreditDetail.setDocs(dynamicObject.getString("docs"));
        openCreditDetail.setReject(dynamicObject.getString("reject"));
        openCreditDetail.setDrawOn(dynamicObject.getString("drawon"));
        openCreditDetail.setLastShipDate(dynamicObject.getString("lastshipdate"));
        openCreditDetail.setMixTenor(dynamicObject.getString("mixtenor"));
        openCreditDetail.setReceiptPlace(dynamicObject.getString("receiptplace"));
        openCreditDetail.setCharges(dynamicObject.getString("charges"));
        openCreditDetail.setAddAmt(dynamicObject.getBigDecimal("addamt"));
        openCreditDetail.setReduceAmt(dynamicObject.getBigDecimal("reduceamt"));
        openCreditDetail.setModFrequency(dynamicObject.getString("modfrequency"));
        openCreditDetail.setLastModDate(dynamicObject.getString("lastmoddate"));
        return openCreditDetail;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public BatchUpdateCollector getBatchUpdateCollector(SaveDataSet saveDataSet) {
        BatchUpdateCollector batchUpdateCollector = new BatchUpdateCollector();
        ArrayList<Object[]> parasList = new ArrayList<Object[]>();
        Iterator dataTableIterator = saveDataSet.getTables().iterator();
        ISaveDataTable dataTable = (ISaveDataTable)dataTableIterator.next();
        ISaveMetaRow[] saveMetaRows = dataTable.getSaveRows();
        Iterator iSaveMetaRowIterable = Arrays.stream(saveMetaRows).iterator();
        while (iSaveMetaRowIterable.hasNext()) {
            List privateDirtyValues = ((ISaveMetaRow)iSaveMetaRowIterable.next()).getDirtyValues();
            ArrayList<Object> paras = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            int version = 0;
            long id = 0L;
            sql.append("UPDATE ");
            sql.append(dataTable.getSchema().getName());
            sql.append(" SET ");
            for (IColumnValuePair field : privateDirtyValues) {
                String columName = field.getColumn().getName();
                if (Objects.equals(columName.toLowerCase(Locale.ENGLISH), "fid")) {
                    id = (Long)field.getValue();
                    continue;
                }
                if (Objects.equals(columName.toLowerCase(Locale.ENGLISH), "fversion")) {
                    version = (Integer)field.getValue();
                    continue;
                }
                sql.append(columName).append("=?,");
                paras.add(field.getValue());
            }
            sql.append("fversion=fversion+1 ");
            sql.append("WHERE fversion=? and Fid=?");
            paras.add(version);
            paras.add(id);
            parasList.add(paras.toArray());
            if (!this.isEmpty(batchUpdateCollector.getSql())) continue;
            batchUpdateCollector.setSql(sql.toString());
        }
        batchUpdateCollector.setListParas(parasList);
        return batchUpdateCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWithVersion(DynamicObject[] dynamicObjects, List<OpenCreditDetail> openCreditDetails) {
        IDataEntityType type = dynamicObjects[0].getDataEntityType();
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        TXHandle h = TX.required();
        try {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                SaveDataSet saveDataSet = (SaveDataSet)dataManager.getSaveDataSet(Collections.singletonList(dynamicObjects[i]).toArray(), true);
                BatchUpdateCollector batchUpdateCollector = this.getBatchUpdateCollector(saveDataSet);
                int[] result = DB.executeBatch((DBRoute)DBRoute.of((String)dataManager.getDataEntityType().getDBRouteKey()), (String)batchUpdateCollector.getSql(), batchUpdateCollector.getListParas());
                if (result[0] == 0) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u4e0e\u6570\u636e\u5e93\u4e2d\u8bb0\u5f55\u7248\u672c\u53f7\u4e0d\u5339\u914d", (String)"NoteReceivableTransFormer_0", (String)"ebg-note-common", (Object[])new Object[0]));
                }
                openCreditDetails.get(i).setVersion(openCreditDetails.get(i).getVersion() + 1);
            }
        }
        catch (Throwable ex) {
            this.log.error("\u6570\u636e\u5e93\u5f02\u5e38", ex);
            h.markRollback();
            if (ex instanceof EBServiceException) {
                throw EBExceiptionUtil.serviceException((String)ex.getMessage(), (Throwable)ex);
            }
            if (ex instanceof KDException) {
                this.log.error("\u6570\u636e\u5e93\u5f02\u5e38" + ((KDException)ex).getMessage());
            }
        }
        finally {
            if (h != null) {
                try {
                    h.close();
                }
                catch (Throwable i) {}
            }
        }
    }
}

