/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.security.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kd.ebg.aqap.common.security.utils.StreamUtil;
import org.apache.commons.codec.binary.Base64;

public class SignatureUtil {
    private static final String SIGN_TYPE_RSA = "RSA";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final String CHARSETTING = "UTF-8";

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, String priKey) throws Exception {
        if (algorithm == null || "".equalsIgnoreCase(algorithm) || priKey == null || "".equalsIgnoreCase(priKey)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtil.readText(new ByteArrayInputStream(priKey.getBytes())).getBytes();
        encodedKey = Base64.decodeBase64((byte[])priKey.getBytes());
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, String pubKey) throws Exception {
        if (algorithm == null || "".equalsIgnoreCase(algorithm) || pubKey == null || "".equalsIgnoreCase(pubKey)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io(new InputStreamReader(new ByteArrayInputStream(pubKey.getBytes())), writer);
        byte[] encodeByte = writer.toString().getBytes();
        encodeByte = Base64.decodeBase64((byte[])pubKey.getBytes());
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodeByte));
    }

    public static String sign(String plain, String prikey) throws Exception {
        if (plain == null || "".equalsIgnoreCase(plain) || prikey == null || "".equalsIgnoreCase(prikey)) {
            return null;
        }
        PrivateKey privatekey = SignatureUtil.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, prikey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initSign(privatekey);
        signature.update(plain.getBytes(CHARSETTING));
        byte[] signed = signature.sign();
        return new String(Base64.encodeBase64((byte[])signed));
    }

    public static boolean virefy(String plain, String sign, String pubkey) throws Exception {
        if (plain == null || "".equalsIgnoreCase(plain) || sign == null || "".equalsIgnoreCase(sign) || pubkey == null || "".equalsIgnoreCase(pubkey)) {
            return false;
        }
        PublicKey publicKey = SignatureUtil.getPublicKeyFromX509(SIGN_TYPE_RSA, pubkey);
        Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
        signature.initVerify(publicKey);
        signature.update(plain.getBytes(CHARSETTING));
        return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
    }
}

