/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils;

import java.math.BigDecimal;
import java.util.Date;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class BankUniqueSeqUtil {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankUniqueSeqUtil.class);
    public static final char BANK_UNIQUE_SEQ_CHAR = '|';
    private static final String dateFormat = "yyyyMMdd";

    public static String parseDate(String date, String oldDateFormat) {
        if (dateFormat.equalsIgnoreCase(oldDateFormat)) {
            return date;
        }
        try {
            Date date1 = DateUtil.string2Date((String)date, (String)oldDateFormat);
            return DateUtil.formatDate((Date)date1, (String)dateFormat);
        }
        catch (Exception ex) {
            log.info("\u94f6\u884c\u4e3b\u952e\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8fd4\u56de\u539f\u65e5\u671f{}", (Object)date);
            return date;
        }
    }

    public static String parseNumber(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return "";
        }
        try {
            BigDecimal bigDecimal = NumberUtils.createBigDecimal((String)number);
            return BankUniqueSeqUtil.parseNumber(bigDecimal);
        }
        catch (Exception ex) {
            log.info("\u94f6\u884c\u4e3b\u952e\u91d1\u989d\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8fd4\u56de\u539f\u91d1\u989d{}", (Object)number);
            return number;
        }
    }

    public static String parseNumber(BigDecimal number) {
        try {
            number = number.multiply(BigDecimal.valueOf(100L)).setScale(0, 1);
            String val = number.toString();
            return val.replace(".", "");
        }
        catch (Exception ex) {
            log.info("\u94f6\u884c\u4e3b\u952e\u91d1\u989d\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff0c\u8fd4\u56de\u539f\u91d1\u989d{}", (Object)number);
            return String.valueOf(number);
        }
    }
}

