/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.service.payment.border;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import kd.ebg.aqap.banks.hsbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbc.dc.service.HSBC_DC_Packer;
import kd.ebg.aqap.banks.hsbc.dc.utils.TransactionRemarkUtils;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayPacker {
    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String connectCustomerID = RequestContextUtils.getBankParameterValue((String)"CONNECT_CUSTOMER_ID");
        Element simulator = new Element("simulator");
        Element head = HSBC_DC_Packer.createHead("BATCH_PAY");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        if ("iFile".equalsIgnoreCase(BankBusinessConfig.getBorderPay())) {
            JDomUtils.addChild((Element)reqPara, (String)"fileMethod", (String)"iFile");
        } else {
            JDomUtils.addChild((Element)reqPara, (String)"fileMethod", (String)"xml");
        }
        String bankMsg = Base64.getEncoder().encodeToString(this.packPayXmlPP(paymentInfos, connectCustomerID).getBytes(StandardCharsets.UTF_8));
        JDomUtils.addChild((Element)body, (String)"bankMsg", (String)bankMsg);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String packPayXmlPP(List<PaymentInfo> paymentInfos, String connectCustomerID) {
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element root = JDomUtils.createRoot((String)"Document");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = PayPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn, connectCustomerID);
        Element PmtInf = PayPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo item : paymentInfos) {
            String payerFeeType = item.getFeeType();
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)item.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)item.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)item.getAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(item.getAmount());
            InstdAmt.setAttribute("Ccy", item.getCurrency());
            if (!"CNY".equalsIgnoreCase(item.getCurrency())) {
                if ("1".equalsIgnoreCase(payerFeeType)) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
                } else if ("0".equalsIgnoreCase(payerFeeType)) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
                } else if ("2".equalsIgnoreCase(payerFeeType)) {
                    JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
                }
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            if (!StringUtils.isEmpty((String)item.getIncomeSwiftCode())) {
                JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)item.getIncomeSwiftCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)item.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            String benefitBankAddress = item.getIncomeBankAddress();
            kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil.addressSplit(CdtrAgt_FinInstnId_PstlAdr, benefitBankAddress);
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)"CN").setNamespace(ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil.formatStringByLength(item.getIncomeAccName(), 70)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil.addressSplit(Cdtr_PstlAdr, item.getIncomeAddress());
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)"CN").setNamespace(ns1);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)item.getIncomeAccNo()).setNamespace(ns1);
            if (!StringUtils.isEmpty((String)item.getExplanation())) {
                Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
                JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)item.getExplanation()).setNamespace(ns1);
            }
            if (StringUtils.isEmpty((String)item.getTransactionRemarks())) continue;
            Element RgltryRptg = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RgltryRptg").setNamespace(ns1);
            Element Dtls = JDomUtils.addChild((Element)RgltryRptg, (String)"Dtls").setNamespace(ns1);
            String Inf = TransactionRemarkUtils.getRemark(item.getTransactionRemarks());
            JDomUtils.addChild((Element)Dtls, (String)"Inf", (String)Inf).setNamespace(ns1);
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static Element packPayXmlPmtInfo(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String accNo = paymentInfo.getAccNo();
        LocalDateTime bookingTime = paymentInfo.getBookingTime();
        if (bookingTime == null) {
            bookingTime = LocalDateTime.now();
        }
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)"TRF").setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
        JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)"URGP").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns1);
        PaymentUtil.setBookPayFlag(paymentInfos);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)BankBusinessConfig.getCompany(accNo)).setNamespace(ns1);
        Element PstlAdr = JDomUtils.addChild((Element)Dbtr, (String)"PstlAdr").setNamespace(ns1);
        kd.ebg.aqap.banks.hsbc.dc.utils.PaymentUtil.addressSplit(PstlAdr, BankBusinessConfig.getStreet(accNo));
        JDomUtils.addChild((Element)PstlAdr, (String)"Ctry", (String)BankBusinessConfig.getCountry(accNo)).setNamespace(ns1);
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)BankBusinessConfig.getBicCode(accNo)).setNamespace(ns1);
        Element FinInstnId_PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns1);
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getAccCountry());
        }
        JDomUtils.addChild((Element)FinInstnId_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
        return PmtInf;
    }

    public static Element packPayXmlhead(List<PaymentInfo> paymentInfos, Element CstmrCdtTrfInitn, String connectCustomerID) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)LocalDateTime.now().toString()).setNamespace(ns1);
        String payProtocol = BankBusinessConfig.getPayProtocol();
        if (!StringUtils.isEmpty((String)payProtocol)) {
            Element Authstn = JDomUtils.addChild((Element)GrpHdr, (String)"Authstn").setNamespace(ns1);
            JDomUtils.addChild((Element)Authstn, (String)"Cd", (String)payProtocol).setNamespace(ns1);
        }
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        Element Id = JDomUtils.addChild((Element)InitgPty, (String)"Id").setNamespace(ns1);
        Element OrgId = JDomUtils.addChild((Element)Id, (String)"OrgId").setNamespace(ns1);
        Element Othr = JDomUtils.addChild((Element)OrgId, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)Othr, (String)"Id", (String)RequestContextUtils.getBankParameterValue((String)"CONNECT_CUSTOMER_ID")).setNamespace(ns1);
        return GrpHdr;
    }
}

