/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.dc.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class FileTransUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FileTransUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String fileToString(File file) {
        StringBuilder buffer = new StringBuilder();
        String line = "";
        if (!file.exists()) {
            logger.info("****************");
        } else {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
            }
            catch (FileNotFoundException e) {
                logger.info("\u6ca1\u6709\u627e\u5230\u6587\u4ef6");
            }
            catch (IOException e) {
                logger.info("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25");
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25");
                    }
                }
            }
        }
        return new String(buffer);
    }

    public static synchronized boolean cutFile(File file, String destPath) {
        if (!file.exists()) {
            return true;
        }
        File destDir = FileCommonUtils.getFileByPath((String)destPath);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        File destFile = FileCommonUtils.getFileByPath((String)destPath, (String)file.getName());
        int index = 1;
        while (destFile.exists()) {
            destFile = FileCommonUtils.getFileByPath((String)destPath, (String)(file.getName() + "-" + index));
            ++index;
        }
        return file.renameTo(destFile);
    }
}

