/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = HNB_DC_Packer.buildHead("200108", RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(responseStr = responseStr.substring(responseStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HNB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s,%2$s", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String acno = body.getChildTextTrim("acno");
        String cur_code = body.getChildTextTrim("cur_code");
        String balance = body.getChildTextTrim("balance");
        String use_balance = body.getChildTextTrim("use_balance");
        String freeze_bal = body.getChildTextTrim("freeze_bal");
        BalanceInfo balanceInfo = new BalanceInfo();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>();
        balances.add(balanceInfo);
        this.setBankAcnt(balanceInfo, request.getBankAcntList(), acno);
        this.setBankCurrency(balanceInfo, request.getBankCurrency(), cur_code);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, use_balance);
        this.setFreezeBalance(balanceInfo, freeze_bal);
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u6838\u5fc3\u4f59\u989d ", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

