/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.payment.salary;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.service.payment.PayParse;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryNoQuery
extends AbstractQueryPayImpl {
    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest request) {
        Element root = HNB_DC_Packer.buildHead("200100", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        JDomUtils.addChild((Element)body, (String)"start_date", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        responseStr = responseStr.substring(responseStr.indexOf("<ap>"));
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        String[] splits = PayParse.parserCommon(responseStr);
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        HashMap<String, String> map = new HashMap<String, String>(1);
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            String serialNo = splits[fieldNum * i + 0];
            String batch_no = splits[fieldNum * i + 1];
            map.put(batch_no, serialNo);
        }
        String serialNo = (String)map.get(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        if (!StringUtils.isNotEmpty((String)serialNo)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6d41\u6c34\u53f7serial_no\u4e3a\u7a7a\u3002", (String)"SalaryNoQuery_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]));
        }
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"serial_no", (String)serialNo);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200100";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1\u7ed3\u679c\u67e5\u8be2", (String)"SalaryNoQuery_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }
}

