/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.payment.salary;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.service.payment.PayParse;
import kd.ebg.aqap.banks.hnb.dc.service.payment.salary.SalaryNoQuery;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        Element root = HNB_DC_Packer.buildHead("200201", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqID());
        String serial_no = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"serial_no");
        if (StringUtils.isEmpty((String)serial_no)) {
            EBBankPayResponse response = new SalaryNoQuery().doBiz(request);
            serial_no = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)response.getPaymentInfos().get(0)), (String)"serial_no");
            PaymentInfoSysFiled.set((List)request.getPaymentInfos(), (String)"serial_no", (String)serial_no);
        }
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        responseStr = responseStr.substring(responseStr.indexOf("<ap>"));
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        String[] splits = PayParse.parserCommon(responseStr);
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        List<PaymentInfo> paymentInfos = this.preBatchSameItemCheck(request);
        ArrayList<Map<String, String>> bankData = new ArrayList<Map<String, String>>(1);
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            String accno = splits[fieldNum * i + 1];
            String accname = splits[fieldNum * i + 3];
            String amount = splits[fieldNum * i + 5];
            BigDecimal biga = new BigDecimal(amount);
            String key = accno + "_" + accname + "_" + BigDecimalHelper.plain2((BigDecimal)biga);
            PaymentInfo payInfo = this.selectPaymentInfo(paymentInfos, key);
            if (null == payInfo) {
                logger.info("info\u4e3a\u7a7a\uff0ckey\uff1a" + key);
                continue;
            }
            String STAT = splits[fieldNum * i + 9];
            String ERR_MSG = splits[fieldNum * i + 10];
            HashMap<String, String> result = new HashMap<String, String>(1);
            result.put("accno", accno);
            result.put("accname", accname);
            result.put("amount", amount);
            result.put("STAT", STAT);
            result.put("ERR_MSG", ERR_MSG);
            result.put("payKey", key);
            bankData.add(result);
            this.handlePayStatus(payInfo, STAT, ERR_MSG);
        }
        this.processingBankItemDataHandler(bankData);
        PayStatusMatchUtil.backBatchSameItemHandler((List)request.getPaymentInfos(), (boolean)false, (boolean)false);
        return new EBBankPayResponse(paymentInfos);
    }

    public void processingBankItemDataHandler(List<Map<String, String>> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Map<String, String> element : elementList) {
                    String bankDataKey = element.get("payKey");
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String orderState = element.get("STAT");
                    String errorMessage = element.get("ERR_MSG");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, orderState, errorMessage);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo payInfo, String STAT, String ERR_MSG) {
        if ("6".equalsIgnoreCase(STAT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        } else if ("9".equalsIgnoreCase(STAT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]));
        } else if ("3".equalsIgnoreCase(STAT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
        return payInfo;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    private PaymentInfo selectPaymentInfo(List<PaymentInfo> paymentInfos, String key) {
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = paymentInfos.get(i);
            if (!key.equals(paymentInfo.getIncomeAccNo() + "_" + paymentInfo.getIncomeAccName() + "_" + paymentInfo.getAmount())) continue;
            return paymentInfo;
        }
        return null;
    }
}

