/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.payment.single;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.service.payment.single.SingleQueryPayImpl;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SinglePayImpl
extends AbstractPayImpl
implements IPay {
    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 0;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SingleQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "300001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u5bf9\u5916\u652f\u4ed8", (String)"SinglePayImpl_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getTotalCount() == 1;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = HNB_DC_Packer.buildHead("300001", paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_type", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"bank_kind", (String)"");
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"booking_date", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_time", (String)"");
        JDomUtils.addChild((Element)body, (String)"saverecvinfo_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"mobiles", (String)paymentInfo.getMobiles());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)(responseStr = responseStr.substring(responseStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HNB_DC_Parser.parseResponeCode(root);
        if ("0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SinglePayImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SinglePayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

