/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.payment.single;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DCSeqState;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SingleQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return "deng_xu";
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4f01\u4e1a\u4ea4\u6613\u6d41\u6c34\u72b6\u6001 (200205\u4ea4\u6613)", (String)"SingleQueryPayImpl_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = HNB_DC_Packer.buildHead("200205", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"req_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"cms_corp_no", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(responseStr = responseStr.substring(responseStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HNB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SingleQueryPayImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("body");
        String reqNo = body.getChildTextTrim("req_no");
        String ret_code = body.getChildTextTrim("stat");
        String error_info = body.getChildTextTrim("error_info");
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (!paymentInfo.getBankDetailSeqId().equalsIgnoreCase(reqNo)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u4ea4\u6613\u6d41\u6c34\u53f7[%1$s]\u4e0e\u8fd4\u56de\u6d41\u6c34[%2$s]\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001", (String)"SingleQueryPayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), paymentInfo.getPackageId(), reqNo));
            return new EBBankPayResponse(paymentInfos);
        }
        String stateMsg = HNB_DCSeqState.getByStateID(ret_code);
        String eMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7ed3\u679c[\u72b6\u6001\u7801:%1$s,\u72b6\u6001\u7801\u63cf\u8ff0:%2$s,\u9519\u8bef\u63cf\u8ff0:%3$s]", (String)"SingleQueryPayImpl_3", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), ret_code, stateMsg, error_info);
        if ("6".equalsIgnoreCase(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SingleQueryPayImpl_4", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)ret_code, (String)eMsg);
        } else if ("9".equalsIgnoreCase(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SingleQueryPayImpl_5", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)ret_code, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SingleQueryPayImpl_5", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]));
        } else if ("3".equalsIgnoreCase(ret_code)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SingleQueryPayImpl_6", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)ret_code, (String)eMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SingleQueryPayImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)ret_code, (String)eMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

