/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service.balance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.huifu.dc.service.Crypto;
import kd.ebg.aqap.banks.huifu.dc.service.Request;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance,
IHisBalance {
    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        String msg = this.pack(request);
        String response = Request.post(msg, "/v2/trade/acctpayment/balance/query");
        return this.parse(request, response);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        JSONObject req = new JSONObject();
        String hfID = RequestContextUtils.getBankParameterValue((String)"hfId");
        String productID = RequestContextUtils.getBankParameterValue((String)"product_id");
        req.put("sys_id", (Object)hfID);
        req.put("product_id", (Object)productID);
        JSONObject data = new JSONObject();
        data.put("req_date", (Object)bankBalanceRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        data.put("req_seq_id", (Object)Sequence.gen18Sequence());
        data.put("huifu_id", (Object)bankBalanceRequest.getAcnt().getAccNo());
        String sign = Crypto.sign(data.clone());
        req.put("data", (Object)data);
        req.put("sign", (Object)sign);
        return req.toJSONString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        JSONObject resp = Crypto.verify(s);
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        String acctInfo_list = resp.getString("acctInfo_list");
        JSONArray acctInfos = JSON.parseArray((String)acctInfo_list);
        BalanceInfo balanceInfo = new BalanceInfo();
        for (int i = 0; i < acctInfos.size(); ++i) {
            JSONObject acctInfo = acctInfos.getJSONObject(i);
            balanceInfo.setBankAcnt(acnt);
            balanceInfo.setCurrentBalance(acctInfo.getBigDecimal("balance_amt"));
            balanceInfo.setAvailableBalance(acctInfo.getBigDecimal("avl_bal"));
            balanceInfo.setBalanceDateTime(bankBalanceRequest.getStartDate().atTime(0, 0, 0));
            balanceInfo.setBankCurrency(bankBalanceRequest.getCurrency());
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "/v2/trade/acctpayment/balance/query";
    }

    public String getBizCode() {
        return "null";
    }

    public String getBizDesc() {
        return "";
    }

    public LocalDate limitDate() {
        return null;
    }

    public boolean async() {
        return false;
    }

    public int queryDays() {
        return 1;
    }
}

