/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.huifu.dc.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.ebg.aqap.banks.huifu.dc.service.Crypto;
import kd.ebg.aqap.banks.huifu.dc.service.Request;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList detailList = new ArrayList(16);
        this.setCurrentPage("1");
        this.setLastPage(false);
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        while (!startDate.isAfter(endDate)) {
            try {
                do {
                    String msg;
                    String response;
                    EBBankDetailResponse bankDetailResponse;
                    List subDetailList;
                    if (!CollectionUtil.isNotEmpty((Collection)(subDetailList = (bankDetailResponse = this.parse(request, response = Request.post(msg = this.pack(request), "/v2/trade/acctpayment/acctlog/query"))).getDetails()))) continue;
                    detailList.addAll(subDetailList);
                } while (!this.isLastPage());
            }
            catch (Exception var5) {
                throw EBExceiptionUtil.serviceException((Throwable)var5);
            }
            startDate = startDate.plusDays(1L);
            request.setStartDate(startDate);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String hfID = RequestContextUtils.getBankParameterValue((String)"hfId");
        String productID = RequestContextUtils.getBankParameterValue((String)"product_id");
        JSONObject req = new JSONObject();
        req.put("sys_id", (Object)hfID);
        req.put("product_id", (Object)productID);
        JSONObject data = new JSONObject();
        data.put("acct_date", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        data.put("req_seq_id", (Object)Sequence.gen18Sequence());
        data.put("huifu_id", (Object)bankDetailRequest.getAcnt().getAccNo());
        data.put("page_size", (Object)"100");
        data.put("page_num", (Object)this.getCurrentPage());
        String sign = Crypto.sign(data.clone());
        req.put("data", (Object)data);
        req.put("sign", (Object)sign);
        return req.toJSONString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1 + "");
        JSONObject resp = Crypto.verify(s);
        String acct_log_list_str = resp.getString("acct_log_list");
        JSONArray acct_log_list = JSON.parseArray((String)acct_log_list_str);
        this.setLastPage(acct_log_list.size() < 100);
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(1);
        for (int i = 0; i < acct_log_list.size(); ++i) {
            JSONObject detail = acct_log_list.getJSONObject(i);
            DetailInfo detailInfo = new DetailInfo();
            String acct_log_id = detail.getString("acct_log_id");
            String acct_date_time = detail.getString("trans_date_time");
            String acct_trans_type = detail.getString("acct_trans_type");
            String debit_type = detail.getString("debit_type");
            BigDecimal trans_amt = detail.getBigDecimal("trans_amt");
            BigDecimal fee_amt = detail.getBigDecimal("fee_amt");
            BigDecimal balance_amt = detail.getBigDecimal("balance_amt");
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setBalance(balance_amt);
            if (trans_amt == null) {
                trans_amt = BigDecimal.ZERO;
            }
            if (fee_amt != null && fee_amt.compareTo(BigDecimal.ZERO) != 0) {
                trans_amt = fee_amt;
            }
            if ("C".equalsIgnoreCase(debit_type)) {
                detailInfo.setCreditAmount(trans_amt);
                detailInfo.setDebitAmount(BigDecimal.ZERO);
            } else {
                detailInfo.setDebitAmount(trans_amt);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
            }
            detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
            LocalDateTime tranDateTime = LocalDateTime.parse(acct_date_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransDate(tranDateTime.toLocalDate());
            detailInfo.setTransTime(tranDateTime);
            detailInfo.setExplanation(acct_trans_type);
            detailInfo.setBankDetailNo(acct_log_id);
            detailInfo.setJsonMap(detail.toJSONString());
            result.add(detailInfo);
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "/v2/trade/acctpayment/acctlog/query";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean isSupportPage() {
        return true;
    }
}

