/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.utils.MessageUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Detail1009Impl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Detail1009Impl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        JSONObject body = MessageUtils.getReqBody();
        String currentPage = this.getCurrentPage();
        if ("0".equalsIgnoreCase(currentPage)) {
            this.setCurrentPage("1");
        }
        body.put("tradeAccount", (Object)bankDetailRequest.getAcnt().getAccNo());
        body.put("currency", (Object)bankDetailRequest.getBankCurrency());
        body.put("currentPage", (Object)this.getCurrentPage());
        body.put("dateType", (Object)"BOOKING");
        body.put("fromDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        body.put("toDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        return MessageUtils.sendToBank(bankDetailRequest.getHeader(), this.getBizCode(), body);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailInfoList = new ArrayList<DetailInfo>(8);
        JSONObject body = MessageUtils.receive(s);
        if (body == null) {
            return new EBBankDetailResponse(detailInfoList);
        }
        String isEnd = body.getString("isEnd");
        if ("N".equalsIgnoreCase(isEnd)) {
            this.setLastPage(false);
            String currentPage = this.getCurrentPage();
            int page = Integer.parseInt(currentPage);
            this.setCurrentPage(page + 1);
        }
        JSONArray tranHisList = body.getJSONArray("tranHisList");
        for (int i = 0; i < tranHisList.size(); ++i) {
            JSONObject trans = tranHisList.getJSONObject(i);
            try {
                DetailInfo detailInfo = new DetailInfo();
                String accountNo = bankDetailRequest.getAcnt().getAccNo();
                String currency = trans.getString("currency");
                String debitAmt = trans.getString("debitAmt");
                String creditAmt = trans.getString("creditAmt");
                String tranNo = trans.getString("tranNo");
                String submissionDate = trans.getString("submissionDate");
                String submissionTime = trans.getString("submissionTime");
                String balance = trans.getString("balance");
                String transactionType = trans.getString("transactionType");
                String cnDescription = trans.getString("cnDescription");
                String accName = bankDetailRequest.getAcnt().getAccName();
                String oppAccNo = trans.getString("counterpartyAccountNumber");
                String oppAccName = trans.getString("counterpartyAccountNameInfo");
                detailInfo.setTransType(transactionType);
                detailInfo.setBankDetailNo(tranNo);
                detailInfo.setAccNo(accountNo);
                detailInfo.setAccName(accName);
                detailInfo.setOppAccNo(oppAccNo);
                detailInfo.setOppAccName(oppAccName);
                detailInfo.setBalance(MessageUtils.checkNumStrLegal(balance));
                detailInfo.setDebitAmount(BigDecimal.ZERO);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
                if (StringUtils.isNotEmpty((String)debitAmt)) {
                    detailInfo.setDebitAmount(new BigDecimal(debitAmt));
                }
                if (StringUtils.isNotEmpty((String)creditAmt)) {
                    detailInfo.setCreditAmount(new BigDecimal(creditAmt));
                }
                detailInfo.setCurrency(currency);
                if (StringUtils.isEmpty((String)submissionTime)) {
                    submissionTime = "000000";
                }
                LocalDateTime transTime = LocalDateTime.parse(submissionDate + submissionTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                LocalDate transDate = transTime.toLocalDate();
                detailInfo.setTransDate(transDate);
                detailInfo.setTransTime(transTime);
                detailInfo.setExplanation(cnDescription);
                detailInfo.setJsonMap(trans.toJSONString());
                detailInfoList.add(detailInfo);
                continue;
            }
            catch (Exception e) {
                logger.info("\u89e3\u6790\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff1a{}\u3002", (Object)trans.toJSONString());
            }
        }
        return new EBBankDetailResponse(detailInfoList);
    }

    public boolean isSupportPage() {
        return true;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "1009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"Detail1009Impl_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        MessageUtils.setRequestProperty(factory);
    }
}

