/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.wlbl.services.pay.tk;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.wlbl.utils.MessageUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class Pay2010Impl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public void configFactory(ConnectionFactory factory) {
        MessageUtils.setRequestProperty(factory);
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return null;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        JSONObject body = MessageUtils.getReqBody();
        String feeType = paymentInfo.getPayerFeeType();
        if ("01".equalsIgnoreCase(feeType)) {
            body.put("chargeType", (Object)"SHA");
            body.put("serviceChargeAccount", (Object)paymentInfo.getPayerFeeAccNo());
            body.put("serviceChargeCcy", (Object)paymentInfo.getPayerFeeCurrency());
        } else if ("02".equalsIgnoreCase(feeType)) {
            body.put("chargeType", (Object)"BEN");
            body.put("serviceChargeAccount", (Object)paymentInfo.getAccNo());
            body.put("serviceChargeCcy", (Object)paymentInfo.getPayerFeeCurrency());
        } else {
            body.put("chargeType", (Object)"OUR");
            body.put("serviceChargeAccount", (Object)paymentInfo.getPayerFeeAccNo());
            body.put("serviceChargeCcy", (Object)paymentInfo.getPayerFeeCurrency());
        }
        body.put("payAccount", (Object)paymentInfo.getAccNo());
        body.put("payAccountCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("debitMoney", (Object)"");
        body.put("transferAmt", (Object)"");
        if ("EUR".equalsIgnoreCase(bankPayRequest.getAcnt().getCurrency()) && "GBP".equalsIgnoreCase(paymentInfo.getPayCurrency())) {
            body.put("debitMoney", (Object)paymentInfo.getAmount().toPlainString());
        } else {
            body.put("transferAmt", (Object)paymentInfo.getAmount().toPlainString());
        }
        body.put("transferCurrency", (Object)paymentInfo.getPayCurrency());
        body.put("toBankCodeType", (Object)"HK");
        body.put("toBankCodeField", (Object)paymentInfo.getPayeeBankCode());
        CountryISOCode incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getIncomeCountry());
        if (incomeIsoCode == null) {
            incomeIsoCode = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        }
        body.put("toCountry", (Object)incomeIsoCode.geteChart2());
        body.put("recAccount", (Object)paymentInfo.getIncomeAccNo());
        body.put("recAccountName", (Object)paymentInfo.getIncomeAccName());
        body.put("toAcctCountry", (Object)"HK");
        body.put("paymentDetail", (Object)MessageUtils.checkRem2(paymentInfo.getExplanation(), 140));
        body.put("payUse", (Object)"");
        body.put("mobileNo", (Object)"");
        body.put("regInd", (Object)"N");
        return MessageUtils.sendToBankForPay(bankPayRequest.getHeader(), this.getBizCode(), body, paymentInfo.getBankBatchSeqID());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        JSONObject body = MessageUtils.receive(s);
        String orderFlowNo = body.getString("orderFlowNo");
        if (StringUtils.isEmpty((String)orderFlowNo)) {
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4ea4\u6613\u6d41\u6c34\u53f7\u3002", (String)"Pay2010Impl_0", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]), (String)"", (String)"");
        } else {
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setBankRefID(orderFlowNo);
            EBGBusinessUtils.setPaymentState((List)bankPayRequest.getPaymentInfos(), (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "2010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7279\u5feb\u8f6c\u8d26EDIT MODE", (String)"Pay2010Impl_1", (String)"ebg-aqap-banks-cmb-wlbl", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

