/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdnx.dc;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdnx.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.sdnx.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.sdnx.dc.services.detail.DetailImpl;
import kd.ebg.aqap.banks.sdnx.dc.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.sdnx.dc.services.payment.inner.SameBankPayImpl;
import kd.ebg.aqap.banks.sdnx.dc.services.payment.inner.SameBankQueryPayImpl;
import kd.ebg.aqap.banks.sdnx.dc.services.payment.outer.OtherPayImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class SdnxMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String CifNo = "CifNo";
    public static final String OpNo = "OpNo";
    public static final String SIGNDATE = "signData";
    public static final String ACCESSNUM = "password";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTP");
        this.setTimeOut(3);
        this.setCharSet("GBK");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5c71\u4e1c\u519c\u4fe1\u793e", (String)"SdnxMetaDataImpl_0", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]));
        this.setBankVersionID("SDNX_DC");
        this.setBankShortName("SDNX");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5c71\u4e1c\u519c\u4fe1\u793e\u76f4\u8054\u7248", (String)"SdnxMetaDataImpl_1", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5c71\u4e1c\u519c\u4fe1\u793e", (String)"SdnxMetaDataImpl_0", (String)"ebg-aqap-banks-sdnx-dc", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        List bankFrontConfig = super.getBankFrontConfig();
        BankLoginConfig charSetConfig = bankFrontConfig.stream().filter(config -> config.getKey().getBankConfigId().equalsIgnoreCase("charset")).findFirst().orElse(null);
        if (charSetConfig != null) {
            charSetConfig.setSourceValues((List)Lists.newArrayList((Object[])new String[]{"UTF-8", "GBK"}));
            charSetConfig.setReadOnly(Boolean.valueOf(false));
            charSetConfig.setInputType(ConfigInputType.SELECT.getInputType());
            charSetConfig.setSourceNames(charSetConfig.getSourceValues());
        }
        return bankFrontConfig;
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)CifNo, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u7f16\u53f7", "SdnxMetaDataImpl_2", "ebg-aqap-banks-sdnx-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7531\u94f6\u884c\u65b9\u63d0\u4f9b", "SdnxMetaDataImpl_3", "ebg-aqap-banks-sdnx-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)ACCESSNUM, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u5bc6\u7801", "SdnxMetaDataImpl_4", "ebg-aqap-banks-sdnx-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7528\u6237\u5bc6\u7801,\u94f6\u884c\u65b9\u63d0\u4f9b", "SdnxMetaDataImpl_5", "ebg-aqap-banks-sdnx-dc"), (String)"", (boolean)false, (boolean)false).set2password(), BankLoginConfigUtil.getMlBankLoginConfig((String)SIGNDATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u662f\u5426\u9700\u8981\u5bf9\u62a5\u6587\u8fdb\u884c\u7b7e\u540d\u3002", "SdnxMetaDataImpl_6", "ebg-aqap-banks-sdnx-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u9ed8\u8ba4\u4e3a1\uff0c\u5373\u9700\u8981\u7b7e\u540d,\u4e0d\u9700\u8981\u7b7e\u540d\u586b0\u3002", "SdnxMetaDataImpl_7", "ebg-aqap-banks-sdnx-dc"), (String)"1", (boolean)false, (boolean)false)});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, DetailImpl.class, SameBankPayImpl.class, SameBankQueryPayImpl.class, OtherPayImpl.class, PretreatmentImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public boolean isDetailSupportMultiCurrency() {
        return true;
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("transferDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("hostFlowNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("onloanFlag", DetailUniqueTypeEnum.STRING.getType());
        result.put("amount", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

