/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class TodayBalanceParser
extends BalanceUtil {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = CIB_DC_Parser.parseString2Root((String)rspStr);
        Element SIGNONMSGSRSV1 = root.getChild("SIGNONMSGSRSV1");
        if (null != SIGNONMSGSRSV1) {
            String CODE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("CODE");
            String MESSAGE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("MESSAGE");
            if (!"0".equalsIgnoreCase(CODE.trim())) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u767b\u5f55\u54cd\u5e94\u72b6\u6001\u5f02\u5e38\uff1a%1$s\uff08\u671f\u671b\u503c\uff1a0\uff09\uff0c\u72b6\u6001\u4fe1\u606f\uff1a%2$s\u3002", (String)"TodayBalanceParser_6", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), CODE, MESSAGE));
            }
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("SCUSTSTMTTRNRS");
        Element status = eb.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        if (!"0".equalsIgnoreCase(iRetCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%1$s\uff08\u671f\u671b\u503c\uff1a0\uff09\uff0c\u72b6\u6001\u4fe1\u606f\uff1a%2$s\u3002", (String)"TodayBalanceParser_7", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), iRetCode, msg));
        }
        Element stmtrs = eb.getChild("SCUSTSTMTRS");
        String CurrType = stmtrs.getChildText("CURDEF");
        Element acctfom = stmtrs.getChild("ACCTFROM");
        String AccNo = acctfom.getChildText("ACCTID");
        Element ledgerBal = stmtrs.getChild("LEDGERBAL");
        Element availbal = stmtrs.getChild("AVAILBAL");
        BalanceInfo balance = new BalanceInfo();
        String currentBalance = ledgerBal.getChildTextTrim("BALAMT");
        String availBalance = availbal.getChildTextTrim("BALAMT");
        BankAcnt acnt = rqst.getAcnt();
        if (!acnt.getAccNo().equalsIgnoreCase(AccNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[%1$s]\u4e0e\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"TodayBalanceParser_8", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), AccNo, acnt.getAccNo()));
        }
        balance.setBankAcnt(acnt);
        if (StringUtils.isEmpty((String)currentBalance)) {
            balance.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"TodayBalanceParser_9", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        } else {
            balance.setCurrentBalance(new BigDecimal(currentBalance));
        }
        if (!StringUtils.isEmpty((String)availBalance)) {
            balance.setAvailableBalance(new BigDecimal(availBalance));
        }
        balance.setBankCurrency(CurrType);
        balance.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }

    public EBBankBalanceResponse parseCURRACCTQUERYTRNRQTodayBalance(BankBalanceRequest request, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root((String)rspStr);
        Element SIGNONMSGSRSV1 = root.getChild("SIGNONMSGSRSV1");
        if (null != SIGNONMSGSRSV1) {
            String CODE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("CODE");
            String MESSAGE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("MESSAGE");
            if (!"0".equalsIgnoreCase(CODE.trim())) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)CODE, (String)MESSAGE));
            }
        }
        Element sMsg = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = sMsg.getChild("CURRACCTQUERYTRNRS");
        Element status = eb.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        if (!"0".equalsIgnoreCase(iRetCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)iRetCode, (String)msg));
        }
        Element body = eb.getChild("RSBODY");
        String acctid = body.getChildText("ACCTID");
        String balamt = body.getChildText("BALAMT");
        String availbal = body.getChildText("AVAILBAL");
        String freezelmt = body.getChildText("FREEZELMT");
        String currency = body.getChildText("CURRENCY");
        BalanceInfo balanceInfo = new BalanceInfo();
        TodayBalanceParser.setBankAcnt((BalanceInfo)balanceInfo, (List)request.getBankAcntList(), (String)acctid);
        TodayBalanceParser.setBalanceDate((BalanceInfo)balanceInfo, (LocalDate)LocalDate.now());
        TodayBalanceParser.setCurrentBalance((BalanceInfo)balanceInfo, (String)balamt);
        TodayBalanceParser.setAvailableBalance((BalanceInfo)balanceInfo, (String)availbal);
        TodayBalanceParser.setFreezeBalance((BalanceInfo)balanceInfo, (String)freezelmt);
        TodayBalanceParser.setBankCurrency((BalanceInfo)balanceInfo, (String)request.getBankCurrency(), (String)currency);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }
}

