/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.utils.DateHelper;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class DetailParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailParser.class);

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return this.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        BankAcnt acnt = rqst.getAcnt();
        Element root = CIB_DC_Parser.parseString2Root((String)rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("SCUSTSTMTTRNRS");
        Element status = eb.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        if (!"0".equalsIgnoreCase(iRetCode)) {
            if ("6421".equalsIgnoreCase(iRetCode)) {
                return new ArrayList<DetailInfo>(1);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u72b6\u6001\u7801\uff1a%1$s\uff08\u671f\u671b\u503c\uff1a0\uff09\uff0c\u72b6\u6001\u4fe1\u606f\uff1a%2$s\u3002", (String)"DetailParser_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), iRetCode, msg));
        }
        Element stmtrs = eb.getChild("SCUSTSTMTRS");
        Element acctfom = stmtrs.getChild("ACCTFROM");
        String AccNo = acctfom.getChildText("ACCTID");
        Element tranList = stmtrs.getChild("TRANLIST");
        List list = tranList.getChildren("STMTTRN");
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < list.size(); ++i) {
            Element e = (Element)list.get(i);
            String Balance = e.getChildTextTrim("BALAMT");
            String RecipAccNo = e.getChildText("CORRELATE_ACCTID");
            String RecipName = e.getChildText("CORRELATE_NAME");
            String RecipBankName = e.getChildText("CORRELATE_BANKNAME");
            String currency = e.getChildText("CURRENCY");
            DetailInfo detailInfo = new DetailInfo();
            details.add(detailInfo);
            detailInfo.setAccNo(acnt.getAccNo());
            detailInfo.setOppAccNo(RecipAccNo);
            detailInfo.setOppAccName(RecipName);
            detailInfo.setOppBankName(RecipBankName);
            String trnCode = e.getChildText("TRNCODE");
            detailInfo.setTransType(this.getTransType(trnCode));
            String Time = e.getChildText("DTACCT");
            if ("DEBIT".equalsIgnoreCase(e.getChildText("TRNTYPE"))) {
                String DebitAmount = e.getChildTextTrim("TRNAMT");
                detailInfo.setDebitAmount(new BigDecimal(DebitAmount));
                detailInfo.setCreditAmount(new BigDecimal("0"));
            }
            if ("CREDIT".equalsIgnoreCase(e.getChildText("TRNTYPE"))) {
                detailInfo.setDebitAmount(new BigDecimal("0"));
                String CreditAmount = e.getChildTextTrim("TRNAMT");
                detailInfo.setCreditAmount(new BigDecimal(CreditAmount));
            }
            if (!StringUtils.isEmpty((String)Balance)) {
                detailInfo.setBalance(new BigDecimal(Balance));
            }
            detailInfo.setCurrency(StringUtils.isEmpty((String)currency) ? rqst.getBankCurrency() : currency);
            String tt = Time.replace('T', ' ');
            detailInfo.setTransDate(DateHelper.parseDate((String)Time.substring(0, 10), (String)"yyyy-MM-dd"));
            if (Time.length() > 18) {
                detailInfo.setTransTime(DateHelper.parse((String)tt, (String)"yyyy-MM-dd HH:mm:ss"));
            } else {
                this.log.error("TimeStamp format is error!!");
            }
            String memo = e.getChildText("MEMO");
            if (!StringUtils.isEmpty((String)memo)) {
                int index = memo.indexOf("_KD_");
                if (index != -1 && "DEBIT".equalsIgnoreCase(e.getChildText("TRNTYPE"))) {
                    String bankDetailSeqId = BizNoUtil.getId((String)memo);
                    String exp = BizNoUtil.getMsg((String)memo);
                    if (bankDetailSeqId.length() > 8) {
                        exp = bankDetailSeqId.substring(0, bankDetailSeqId.length() - 8) + exp;
                        bankDetailSeqId = bankDetailSeqId.substring(bankDetailSeqId.length() - 8);
                    }
                    detailInfo.setExplanation(exp);
                    detailInfo.setKdFlag(bankDetailSeqId);
                    detailInfo.setPayBankDetailSeqID(bankDetailSeqId);
                } else {
                    detailInfo.setExplanation(memo);
                }
            }
            String attachInfo = e.getChildText("ATTACHINFO");
            String srvrtid = e.getChildText("SRVRTID");
            if (BankBusinessConfig.isAttachInfo()) {
                detailInfo.setBizRefNo(attachInfo);
            } else {
                detailInfo.setBizRefNo(srvrtid);
            }
            String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(e);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("TRANSDATE", (Object)transDate);
            detailInfo.setJsonMap(jsonObject.toJSONString());
            String accNo = rqst.getHeader().getAcnt().getAccNo();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfo.setBankDetailNo(attachInfo);
        }
        return details;
    }

    private String getTransType(String trnCode) {
        if (this.isAutoTransUp(trnCode)) {
            return "autotransup";
        }
        if (this.isAutoTransDown(trnCode)) {
            return "autotransdown";
        }
        return "normal";
    }

    private boolean isAutoTransUp(String trnCode) {
        return "859".equalsIgnoreCase(trnCode) || "860".equalsIgnoreCase(trnCode) || "232".equalsIgnoreCase(trnCode);
    }

    private boolean isAutoTransDown(String trnCode) {
        return "861".equalsIgnoreCase(trnCode) || "862".equalsIgnoreCase(trnCode) || "233".equalsIgnoreCase(trnCode);
    }
}

