/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.utils;

import java.io.File;
import java.nio.charset.Charset;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jdom2.Element;

public class FileUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FileUtil.class);
    private static FileUtil instance = new FileUtil();

    public static FileUtil getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadFileByHttp(File sendFile) throws Exception {
        StringBuilder requestUrl = new StringBuilder();
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        requestUrl.append("http://").append(ip);
        String filePort = RequestContextUtils.getBankParameterValue((String)"fileport");
        requestUrl.append(":").append(filePort);
        requestUrl.append("/upload");
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(180000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
            HttpPost httpPost = new HttpPost(requestUrl.toString());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addBinaryBody("file", sendFile, ContentType.MULTIPART_FORM_DATA, sendFile.getName());
            ContentType contentType = ContentType.create((String)"multipart/form-data", (Charset)Charset.forName("UTF-8"));
            builder.addTextBody("bizCode", "101", contentType);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String file_id;
                HttpEntity responseEntity = response.getEntity();
                String responseStr = EntityUtils.toString((HttpEntity)responseEntity);
                logger.info("\u4e0a\u4f20\u6587\u4ef6\u54cd\u5e94\u62a5\u6587\uff1a" + responseStr);
                Element element = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
                Element file_info = element.getChild("FILE_INFO");
                String string = file_id = JDomUtils.getChildText((Element)file_info, (String)"FILE_ID");
                return string;
            }
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u975e200\u72b6\u6001\u7801:" + statusCode);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56dehttp\u72b6\u6001\u7801%s", (String)"AbstractAttachmentImpl_3", (String)"ebg-aqap-business", (Object[])new Object[0]), statusCode));
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a{}", new Object[]{e.getMessage()});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a%s\u3002", (String)"AbstractAttachmentImpl_4", (String)"ebg-aqap-business", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }
}

